/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class LargeComboBoxRenderer<E>
extends JLabel
implements ListCellRenderer<E> {
    private final int wordWrapWidth;

    public LargeComboBoxRenderer(int wordWrapWidth) {
        this.wordWrapWidth = wordWrapWidth;
        this.setOpaque(true);
    }

    private String getHtmlWrappedText(String text) {
        StringBuilder sb = new StringBuilder(250);
        sb.append("<html>");
        sb.append("<p style=\"");
        sb.append(this.getParagraphStyle());
        sb.append("\">");
        sb.append(text);
        sb.append("</p>");
        sb.append("</html>");
        return sb.toString();
    }

    private String getParagraphStyle() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("word-wrap: break-word;");
        sb.append("width: ");
        sb.append(this.wordWrapWidth);
        sb.append("px;");
        return sb.toString();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null) {
            String valueString = value.toString();
            if (index == -1) {
                this.setText(valueString);
            } else {
                this.setText(this.getHtmlWrappedText(valueString));
            }
        }
        return this;
    }
}

