/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.POSConstants;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public abstract class ProgressDialog
extends POSDialog
implements ProgressObserver {
    private JLabel lblProgress;
    private JPanel progressPanel;
    private JProgressBar jProgressBar = new JProgressBar();
    private PosButton btnCancel;
    private String successMsg;

    public ProgressDialog() {
        super(POSUtil.getFocusedWindow(), "", true);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.progressPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 20 20 5 20,center", "[250]", "[]"));
        this.lblProgress = new JLabel();
        this.progressPanel.add((Component)this.lblProgress, "wrap");
        this.progressPanel.add((Component)this.jProgressBar, "grow,span,wrap,h " + PosUIManager.getSize(50));
        this.btnCancel = new PosButton(POSConstants.CANCEL);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.closeDialog();
            }
        });
        this.progressPanel.add((Component)this.btnCancel, "center,gaptop 5,gapbottom 5");
        contentPanel.setMinimumSize(PosUIManager.getSize(300, 200));
        contentPanel.add(this.progressPanel);
        this.add(contentPanel);
        this.setDefaultCloseOperation(0);
    }

    public void setIndeterminate(boolean b) {
        this.jProgressBar.setIndeterminate(b);
    }

    public abstract void execute(ProgressObserver var1);

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.execute(ProgressDialog.this);
                    ProgressDialog.this.closeDialog();
                    if (StringUtils.isNotEmpty((String)ProgressDialog.this.successMsg)) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), ProgressDialog.this.successMsg);
                    }
                }
            });
            thread.start();
        }
        super.setVisible(b);
    }

    public void closeDialog() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void progress(int percent, String text) {
        this.lblProgress.setText(text);
        this.jProgressBar.setValue(percent);
    }

    @Override
    public void progress(int percent) {
        this.jProgressBar.setValue(percent);
    }

    @Override
    public void progress(String text) {
        this.lblProgress.setText(text);
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    public void setProgressLabelText(String text) {
        this.lblProgress.setText(text);
    }

    public void showCompleteMsg(String successMsg) {
        this.successMsg = successMsg;
    }

    public void setCancelable(boolean cancelable) {
        this.btnCancel.setVisible(cancelable);
    }
}

