/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class PosTableRenderer
extends DefaultTableCellRenderer {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, h:m a");
    private JCheckBox checkBox = new JCheckBox();
    private JLabel lblColor = new JLabel();

    public PosTableRenderer() {
        this.checkBox.setHorizontalAlignment(0);
        this.lblColor.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value instanceof String) {
            label.setText(value.toString());
        }
        label.setIcon(null);
        label.setHorizontalAlignment(10);
        if (value instanceof Boolean) {
            this.checkBox.setSelected((Boolean)value);
            if (isSelected) {
                this.checkBox.setBackground(table.getSelectionBackground());
            } else {
                this.checkBox.setBackground(table.getBackground());
            }
            return this.checkBox;
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            String rgb = Integer.toHexString(color.getRGB()).toUpperCase();
            rgb = rgb.substring(2, rgb.length());
            this.lblColor.setText(rgb);
            this.lblColor.setBackground(color);
            return this.lblColor;
        }
        if (value instanceof ImageIcon) {
            ImageIcon image = (ImageIcon)value;
            if ((image = new ImageIcon(image.getImage().getScaledInstance(48, 48, 4))) != null) {
                table.setRowHeight(PosUIManager.getSize(60));
            }
            JLabel l = new JLabel(image);
            MatteBorder unselectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, table.getBackground());
            l.setBorder(unselectedBorder);
            return l;
        }
        if (column == 0) {
            Terminal terminal;
            ListTableModel listTableModel;
            Object rowData;
            Ticket ticket = null;
            TableModel tableModel = table.getModel();
            if (tableModel instanceof ListTableModel && (rowData = (listTableModel = (ListTableModel)tableModel).getRowData(row)) instanceof Ticket) {
                ticket = (Ticket)rowData;
            }
            if (ticket == null) {
                return label;
            }
            if (ticket.isSourceOnline()) {
                label.setIcon(IconFactory.getIcon("/ui_icons/", "cloud.png"));
            }
            if ((terminal = ticket.getTerminal()) != null && terminal.getDeviceType() == 1) {
                label.setIcon(IconFactory.getIcon("/ui_icons/", "mobile_32px.png"));
            }
        }
        if (value instanceof Double) {
            label.setHorizontalAlignment(4);
        }
        return label;
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        String text = value.toString();
        if (value instanceof Double || value instanceof Float) {
            text = NumberUtil.formatNumber(((Number)value).doubleValue(), true);
            this.setHorizontalAlignment(4);
        } else if (value instanceof Integer) {
            this.setHorizontalAlignment(4);
        } else if (value instanceof Date) {
            text = dateFormat.format(value);
            this.setHorizontalAlignment(2);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setText(" " + text + " ");
    }
}

