/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AutoLogOffAlertDialog
extends POSDialog {
    private Timer timer;
    private JLabel lblCountTimer;

    public AutoLogOffAlertDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
        this.startCountDown();
    }

    private void startCountDown() {
        this.timer = new Timer(0, new CountDownTask());
        this.timer.setDelay(1000);
        this.timer.start();
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 20, 30));
        JLabel lblAutoLogOffMsg = new JLabel("Auto log off in", 0);
        Font font1 = new Font(lblAutoLogOffMsg.getName(), 1, PosUIManager.getFontSize(30));
        lblAutoLogOffMsg.setFont(font1);
        this.lblCountTimer = new JLabel("30 s", 0);
        Font font2 = new Font(this.lblCountTimer.getName(), 1, PosUIManager.getFontSize(300));
        this.lblCountTimer.setFont(font2);
        PosButton btnCancel = new PosButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoLogOffAlertDialog.this.setCanceled(true);
                AutoLogOffAlertDialog.this.dispose();
            }
        });
        contentPanel.add((Component)lblAutoLogOffMsg, "North");
        contentPanel.add(this.lblCountTimer);
        contentPanel.add((Component)btnCancel, "South");
        this.add(contentPanel);
    }

    private class CountDownTask
    implements ActionListener {
        int count = 30;
        int countLabelFontSize = PosUIManager.getFontSize(300);
        int subscriptFontSize = PosUIManager.getFontSize(36);

        private CountDownTask() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.count >= 0) {
                String text = String.format("<html><span style='font-size: %d'>%d</span><sub style='font-size: %d'>sec</sub>", this.countLabelFontSize, this.count, this.subscriptFontSize);
                AutoLogOffAlertDialog.this.lblCountTimer.setText(text);
            } else {
                AutoLogOffAlertDialog.this.timer.stop();
                AutoLogOffAlertDialog.this.setCanceled(false);
                AutoLogOffAlertDialog.this.dispose();
            }
            --this.count;
        }
    }
}

