/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class ComboTicketItemSelectionDialog
extends OkCancelOptionDialog {
    private JPanel menuItemViewPanel;
    private ScrollableFlowPanel buttonsPanel;
    private ScrollableFlowPanel comboGroupPanel;
    private Map<String, TicketItem> ticketItemComboMap = new LinkedHashMap<String, TicketItem>();
    private Map<String, List<MenuItem>> groupMap = new HashMap<String, List<MenuItem>>();
    private MenuItem parentMenuItem;
    private ComboTicketItem ticketItem;
    private ComboGroup selectedComboGroup;
    private JTable table;
    private PosButton btnCustomQuantity;
    private PosButton btnIncreaseQuantity;
    private PosButton btnDecreaseQuantity;

    public ComboTicketItemSelectionDialog(MenuItem menuItem, TicketItem ticketItem) {
        super((Frame)Application.getPosWindow(), true);
        this.ticketItem = (ComboTicketItem)ticketItem;
        this.parentMenuItem = menuItem;
        this.initComponent();
        this.rendererGroup();
        this.updateView();
    }

    private void initComponent() {
        this.setOkButtonText("DONE");
        this.setCaption(this.parentMenuItem + " - Select combo items");
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.menuItemViewPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.buttonsPanel = new ScrollableFlowPanel(1);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(60, 0));
        scrollPane.setBorder(null);
        this.menuItemViewPanel.add((Component)scrollPane, "grow,span");
        centerPanel.add((Component)this.menuItemViewPanel, "Center");
        this.getContentPanel().add((Component)centerPanel, "Center");
        this.table = new JTable();
        this.table.setRowHeight(40);
        this.table.setModel(new ComboTicketItemTableModel());
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(Object.class, new MultiLineTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                boolean editable = comboTicketItem != null && ComboTicketItemSelectionDialog.this.isGroupItem(comboTicketItem);
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnIncreaseQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnDecreaseQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setText("...");
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setEnabled(editable);
                if (comboTicketItem == null) {
                    return;
                }
                double quantity = comboTicketItem.getQuantity();
                ComboTicketItemSelectionDialog.this.updateQuantity(quantity);
            }
        });
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 2, 3), scroll.getBorder()));
        scroll.setPreferredSize(PosUIManager.getSize(250, 0));
        JPanel leftTableView = new JPanel(new BorderLayout());
        TitledBorder leftSelectedComboTitleBorder = new TitledBorder("Selected combo items");
        leftSelectedComboTitleBorder.setTitleJustification(2);
        leftTableView.setBorder(leftSelectedComboTitleBorder);
        leftTableView.add(scroll);
        this.getContentPanel().add((Component)leftTableView, "West");
        int size = PosUIManager.getSize(30);
        JPanel itemtemActionPanel = new JPanel();
        itemtemActionPanel.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + size + "px][grow][" + size + "px]", "[" + size + "]"));
        this.btnIncreaseQuantity = new PosButton();
        this.btnIncreaseQuantity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                if (comboTicketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.isGroupItem(comboTicketItem)) {
                    return;
                }
                double previousQuantity = comboTicketItem.getQuantity();
                comboTicketItem.setQuantity(previousQuantity + 1.0);
                if (!ComboTicketItemSelectionDialog.this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(comboTicketItem.getQuantity());
            }
        });
        this.btnCustomQuantity = new PosButton("...");
        this.btnCustomQuantity.setFont(new Font(this.btnCustomQuantity.getFont().getName(), 1, 20));
        this.btnCustomQuantity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                if (comboTicketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.isGroupItem(comboTicketItem)) {
                    return;
                }
                NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
                dialog.setTitle("Enter quantity");
                dialog.setFloatingPoint(false);
                dialog.pack();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                double quantity = (int)dialog.getValue();
                if (quantity <= 0.0) {
                    return;
                }
                double previousQuantity = comboTicketItem.getQuantity();
                comboTicketItem.setQuantity(quantity);
                if (!ComboTicketItemSelectionDialog.this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(comboTicketItem.getQuantity());
            }
        });
        this.btnDecreaseQuantity = new PosButton();
        this.btnDecreaseQuantity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                if (comboTicketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.isGroupItem(comboTicketItem)) {
                    return;
                }
                double previousQuantity = comboTicketItem.getQuantity();
                if (previousQuantity == 1.0) {
                    return;
                }
                comboTicketItem.setQuantity(previousQuantity - 1.0);
                if (!ComboTicketItemSelectionDialog.this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(comboTicketItem.getQuantity());
            }
        });
        this.btnIncreaseQuantity.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png"));
        this.btnDecreaseQuantity.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png"));
        itemtemActionPanel.add(this.btnDecreaseQuantity);
        itemtemActionPanel.add((Component)this.btnCustomQuantity, "grow");
        itemtemActionPanel.add(this.btnIncreaseQuantity);
        leftTableView.add((Component)itemtemActionPanel, "South");
        this.comboGroupPanel = new ScrollableFlowPanel(1);
        SimpleScrollPane scrollPane2 = new SimpleScrollPane((Component)this.comboGroupPanel);
        scrollPane2.setBorder(null);
        scrollPane2.setHorizontalScrollBarPolicy(30);
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setViewportView((Component)this.comboGroupPanel);
        JPanel menuGroupContainer = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder titledBorder = new TitledBorder("Group");
        titledBorder.setTitleJustification(2);
        menuGroupContainer.setBorder(titledBorder);
        menuGroupContainer.setPreferredSize(PosUIManager.getSize(0, 110));
        menuGroupContainer.add((Component)scrollPane2, "grow");
        centerPanel.add((Component)menuGroupContainer, "North");
        PosButton btnModify = new PosButton("MODIFY");
        btnModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                if (comboTicketItem == null) {
                    return;
                }
                comboTicketItem.setTicket(OrderView.getInstance().getCurrentTicket());
                if (comboTicketItem instanceof ModifiableTicketItem || comboTicketItem.isPizzaType().booleanValue()) {
                    ComboTicketItemSelectionDialog.this.openModifierDialog(comboTicketItem);
                    comboTicketItem.setTicket(null);
                    ComboTicketItemSelectionDialog.this.updateView();
                }
            }
        });
        this.getButtonPanel().add((Component)btnModify, 0);
    }

    private boolean isGroupItem(TicketItem comboTicketItem) {
        return comboTicketItem.getGroupId() != null;
    }

    private boolean hasGroupOrValidateQuantity(TicketItem comboTicketItem, double previousQuantity) {
        if (comboTicketItem.getGroupId() == null) {
            return false;
        }
        if (this.parentMenuItem.getComboGroups() != null) {
            for (ComboGroup group : this.parentMenuItem.getComboGroups()) {
                if (!group.getId().equals(comboTicketItem.getGroupId())) continue;
                this.selectedComboGroup = group;
                this.rendererItems(this.selectedComboGroup);
                break;
            }
        }
        int count = 0;
        for (TicketItem ticketItem : this.ticketItemComboMap.values()) {
            if (!this.selectedComboGroup.getId().equals(ticketItem.getGroupId())) continue;
            count = (int)((double)count + ticketItem.getQuantity());
        }
        if (count > this.selectedComboGroup.getMaxQuantity()) {
            comboTicketItem.setQuantity(previousQuantity);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Maximum limit is : " + this.selectedComboGroup.getMaxQuantity());
            return false;
        }
        return true;
    }

    protected void updateQuantity(double quantity) {
        this.btnCustomQuantity.setText(NumberUtil.trimDecilamIfNotNeeded(quantity));
        this.table.repaint();
    }

    private TicketItem getComboTicketItem() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        int index = this.table.convertRowIndexToModel(row);
        ITicketItem item = (ITicketItem)((ComboTicketItemTableModel)this.table.getModel()).getRowData(index);
        TicketItem comboTicketItem = null;
        if (item instanceof TicketItem) {
            comboTicketItem = (TicketItem)item;
        } else if (item instanceof TicketItemModifier) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)item;
            comboTicketItem = ticketItemModifier.getTicketItem();
        }
        return comboTicketItem;
    }

    public void openModifierDialog(TicketItem ticketItem) {
        try {
            POSDialog dialog;
            Ticket ticket = ticketItem.getTicket();
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
            if (ticketItemModifiers == null) {
                ticketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            TicketItem cloneTicketItem = ticketItem.clone();
            boolean pizzaType = ticketItem.isPizzaType();
            if (pizzaType) {
                dialog = new PizzaModifierSelectionDialog(ticket, cloneTicketItem, menuItem, true);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                TicketItemModifier sizeModifier = cloneTicketItem.getSizeModifier();
                sizeModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(sizeModifier);
                ticketItem.setQuantity(cloneTicketItem.getQuantity());
                ticketItem.setUnitPrice(cloneTicketItem.getUnitPrice());
            } else {
                dialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, cloneTicketItem, menuItem));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
            List<TicketItemModifier> addedTicketItemModifiers = cloneTicketItem.getTicketItemModifiers();
            if (addedTicketItemModifiers == null) {
                addedTicketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            ticketItemModifiers.clear();
            for (TicketItemModifier ticketItemModifier : addedTicketItemModifiers) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void rendererGroup() {
        List<ComboGroup> comboGroups;
        List<TicketItem> comboItems = this.ticketItem.getComboItems();
        if (comboItems != null) {
            for (TicketItem ticketItem : comboItems) {
                if (ticketItem.getGroupId() == null) continue;
                this.ticketItemComboMap.put(ticketItem.getMenuItemId(), ticketItem);
            }
        }
        if (this.parentMenuItem.isVariant().booleanValue()) {
            this.parentMenuItem = this.parentMenuItem.getParentMenuItem();
            MenuItemDAO.getInstance().initialize(this.parentMenuItem);
        }
        if ((comboGroups = this.parentMenuItem.getComboGroups()) != null) {
            TitledBorder titleBorder;
            Dimension size = PosUIManager.getSize(115, 60);
            ButtonGroup group = new ButtonGroup();
            boolean selectedFirst = true;
            for (ComboGroup comboGroup : comboGroups) {
                ComboGroupButton groupButton = new ComboGroupButton(comboGroup);
                groupButton.setSelected(selectedFirst);
                groupButton.setPreferredSize(size);
                this.comboGroupPanel.add(groupButton);
                List<MenuItem> items = comboGroup.getItems();
                try {
                    if (items != null) {
                        for (MenuItem item : items) {
                            TicketItem ticketItem = this.ticketItemComboMap.get(item.getId());
                            if (ticketItem == null) continue;
                            ticketItem.setMenuItem(item);
                        }
                        this.groupMap.put(comboGroup.getId(), items);
                    }
                }
                catch (PosException e) {
                    e.printStackTrace();
                }
                group.add(groupButton);
                selectedFirst = false;
            }
            if (comboGroups != null && comboGroups.size() > 0) {
                this.selectedComboGroup = comboGroups.get(0);
                this.rendererItems(this.selectedComboGroup);
                titleBorder = BorderFactory.createTitledBorder(this.selectedComboGroup.getName() + " Min:" + this.selectedComboGroup.getMinQuantity() + " Max:" + this.selectedComboGroup.getMaxQuantity());
                titleBorder.setTitleJustification(2);
                this.menuItemViewPanel.setBorder(titleBorder);
            } else {
                titleBorder = BorderFactory.createTitledBorder("-");
                titleBorder.setTitleJustification(2);
                this.menuItemViewPanel.setBorder(titleBorder);
            }
        }
    }

    private void rendererItems(ComboGroup comboGroup) {
        try {
            this.buttonsPanel.getContentPane().removeAll();
            Dimension size = PosUIManager.getSize(115, 80);
            if (comboGroup == null) {
                return;
            }
            List<MenuItem> items = this.groupMap.get(comboGroup.getId());
            if (items != null) {
                for (MenuItem menuItem : items) {
                    MenuItemButton btnMenuItem = new MenuItemButton(menuItem);
                    TicketItem ticketItem = this.ticketItemComboMap.get(menuItem.getId());
                    if (ticketItem != null) {
                        btnMenuItem.setSelected(true);
                    }
                    this.buttonsPanel.getContentPane().add(btnMenuItem);
                    btnMenuItem.setPreferredSize(size);
                }
            }
            this.buttonsPanel.getContentPane().revalidate();
            this.buttonsPanel.getContentPane().repaint();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doOk() {
        if (!this.isRequiredItemsAdded()) {
            return;
        }
        List<TicketItem> comboItems = this.ticketItem.getComboItems();
        if (comboItems != null) {
            Iterator<TicketItem> iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.getGroupId() == null) continue;
                iterator.remove();
            }
        }
        for (TicketItem item : this.ticketItemComboMap.values()) {
            item.setParentTicketItem(this.ticketItem);
            item.setTicket(null);
            this.ticketItem.addTocomboItems(item);
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean isRequiredItemsAdded() {
        List<ComboGroup> comboGroups = this.parentMenuItem.getComboGroups();
        if (comboGroups == null) {
            return true;
        }
        for (ComboGroup group : comboGroups) {
            int count = 0;
            for (TicketItem ticketItem : this.ticketItemComboMap.values()) {
                if (!group.getId().equals(ticketItem.getGroupId())) continue;
                count = (int)((double)count + ticketItem.getQuantity());
            }
            if (count >= group.getMinQuantity()) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select minimum " + group.getMinQuantity() + " quantity from group " + group.getName());
            this.rendererItems(group);
            return false;
        }
        return true;
    }

    private void updateView() {
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        ArrayList<ITicketItem> items = new ArrayList<ITicketItem>();
        List<TicketItem> comboItems = this.ticketItem.getComboItems();
        if (comboItems != null) {
            for (TicketItem comboItem : comboItems) {
                if (comboItem.getGroupId() != null) continue;
                items.add(comboItem);
            }
        }
        items.addAll(this.ticketItemComboMap.values());
        model.setRows((List<ITicketItem>)items);
    }

    @Override
    public void doCancel() {
        this.ticketItemComboMap.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public Collection<TicketItem> getSelectedMenuItems() {
        return this.ticketItemComboMap.values();
    }

    private boolean validQuantity() {
        int count = 1;
        for (TicketItem ticketItem : this.ticketItemComboMap.values()) {
            if (!this.selectedComboGroup.getId().equals(ticketItem.getGroupId())) continue;
            count = (int)((double)count + ticketItem.getQuantity());
        }
        return count <= this.selectedComboGroup.getMaxQuantity();
    }

    public boolean addComboItem(MenuItem menuItem) {
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        TicketItem comboTicketItem = menuItem.convertToTicketItem(currentTicket, 1.0);
        comboTicketItem.setMenuItem(menuItem);
        comboTicketItem.setTicket(currentTicket);
        if (menuItem.isPizzaType().booleanValue()) {
            PizzaModifierSelectionDialog dialog = new PizzaModifierSelectionDialog(currentTicket, comboTicketItem, menuItem, false);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return false;
            }
        } else if (menuItem.hasMandatoryModifiers()) {
            ModifierSelectionDialog dialog = new ModifierSelectionDialog(new ModifierSelectionModel(currentTicket, comboTicketItem, menuItem));
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
        }
        this.ticketItemComboMap.put(menuItem.getId(), comboTicketItem);
        comboTicketItem.setMenuItemId(menuItem.getId());
        comboTicketItem.setGroupId(this.selectedComboGroup.getId());
        comboTicketItem.setName(menuItem.getName());
        comboTicketItem.setTicket(null);
        comboTicketItem.setQuantity(1.0);
        return true;
    }

    public class ComboTicketItemTableModel
    extends ListTableModel<ITicketItem> {
        public ComboTicketItemTableModel() {
            super(new String[]{"Item"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ITicketItem item = (ITicketItem)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return item.getItemQuantityDisplay() + "x " + item.getNameDisplay();
                }
            }
            return null;
        }

        @Override
        public void setRows(List<ITicketItem> rows) {
            ArrayList<ITicketItem> ticketItemWithModifiers = new ArrayList<ITicketItem>();
            for (ITicketItem item : rows) {
                TicketItem ticketItem;
                ticketItemWithModifiers.add(item);
                if (!(item instanceof TicketItem) || !(ticketItem = (TicketItem)item).isHasModifiers().booleanValue() || ticketItem.getTicketItemModifiers() == null) continue;
                ticketItemWithModifiers.addAll(ticketItem.getTicketItemModifiers());
            }
            super.setRows(ticketItemWithModifiers);
        }
    }

    private class ComboGroupButton
    extends POSToggleButton
    implements ActionListener {
        ComboGroup comboGroup;

        ComboGroupButton(ComboGroup comboGroup) {
            this.comboGroup = comboGroup;
            this.setText("<html><body><center>" + comboGroup.getName() + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboTicketItemSelectionDialog.this.menuItemViewPanel.setBorder(BorderFactory.createTitledBorder(this.comboGroup.getName() + " Min:" + this.comboGroup.getMinQuantity() + " Max:" + this.comboGroup.getMaxQuantity()));
            ComboTicketItemSelectionDialog.this.rendererItems(this.comboGroup);
            ComboTicketItemSelectionDialog.this.selectedComboGroup = this.comboGroup;
        }
    }

    private class MenuItemButton
    extends POSToggleButton
    implements ActionListener {
        private int BUTTON_SIZE = 100;
        MenuItem menuItem;

        MenuItemButton(MenuItem menuItem) {
            Color textColor;
            this.menuItem = menuItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.BUTTON_SIZE = PosUIManager.getSize(100);
            ImageIcon image = menuItem.getImage();
            if (image != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getName() + "</center></body></html>");
            }
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = menuItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.setPreferredSize(new Dimension(this.BUTTON_SIZE, this.BUTTON_SIZE));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block7: {
                if (this.isSelected()) {
                    if (!ComboTicketItemSelectionDialog.this.validQuantity()) {
                        this.setSelected(false);
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Maximum limit is : " + ComboTicketItemSelectionDialog.this.selectedComboGroup.getMaxQuantity());
                        return;
                    }
                    Session session = null;
                    try {
                        session = MenuItemDAO.getInstance().getSession();
                        this.menuItem = (MenuItem)session.merge((Object)this.menuItem);
                        if (!ComboTicketItemSelectionDialog.this.addComboItem(this.menuItem)) {
                            this.setSelected(false);
                            return;
                        }
                        break block7;
                    }
                    finally {
                        MenuItemDAO.getInstance().closeSession(session);
                    }
                }
                TicketItem ticketItem = (TicketItem)ComboTicketItemSelectionDialog.this.ticketItemComboMap.get(this.menuItem.getId());
                if (ticketItem != null) {
                    ComboTicketItemSelectionDialog.this.ticketItemComboMap.remove(this.menuItem.getId());
                }
            }
            ComboTicketItemSelectionDialog.this.updateView();
        }
    }
}

