/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class DrawerAndStaffBankReportHistoryDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JTable tableDrawerReport;
    private DrawerReportTableModel tableModel;
    private List<CashDrawer> drawerPullReportList;
    private DefaultListSelectionModel selectionModel;
    private User user;
    private PosButton btnCancel;
    private Terminal currentTerminal;
    private JLabel lblTotalCash;
    private StoreSession currentStoreOperationData;

    public DrawerAndStaffBankReportHistoryDialog(JFrame parent, User user, StoreSession currentStoreOperationData) {
        super((Frame)parent, true);
        this.setTitle("Store history");
        this.user = user;
        this.currentStoreOperationData = currentStoreOperationData;
        this.initComponents();
        this.initData();
        this.updateView();
    }

    public void initData() {
        this.currentTerminal = Application.getInstance().getTerminal();
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.tableDrawerReport.getSelectionModel().setSelectionMode(0);
        this.tableDrawerReport.setDefaultRenderer(Object.class, new TableRenderer());
        this.tableModel = new DrawerReportTableModel();
        this.tableDrawerReport.setModel(this.tableModel);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                CashDrawer pullReport = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.tableModel.getRowData(row);
                DrawerAndStaffBankReportHistoryDialog.this.showReport(pullReport);
                DrawerAndStaffBankReportHistoryDialog.this.updateView();
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.tableDrawerReport, action, 5){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.tableDrawerReport.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.tableDrawerReport.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnCancel.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnCancel.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        this.resizeTableColumns();
    }

    private void updateView() {
        if (this.currentStoreOperationData == null) {
            return;
        }
        this.drawerPullReportList = new ArrayList<CashDrawer>();
        List<CashDrawer> drawerStatusList = CashDrawerDAO.getInstance().findByStoreOperationData(this.currentStoreOperationData);
        for (CashDrawer cashDrawer : drawerStatusList) {
            this.drawerPullReportList.add(cashDrawer);
        }
        this.tableModel.setItems(this.drawerPullReportList);
        this.tableModel.fireTableDataChanged();
        this.lblTotalCash.setText(NumberUtil.formatNumber(this.tableModel.getTotalCashDeposit()));
    }

    private void resizeTableColumns() {
        this.tableDrawerReport.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(200));
        this.setColumnWidth(1, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.tableDrawerReport.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void initComponents() {
        TransparentPanel container = new TransparentPanel();
        this.titlePanel = new TitlePanel();
        TransparentPanel contentPanel = new TransparentPanel();
        TransparentPanel bottomActionPanel = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator1 = new JSeparator();
        this.btnCancel = new PosButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.tableDrawerReport = new JTable();
        this.tableDrawerReport.setRowHeight(PosUIManager.getSize(30));
        this.tableDrawerReport.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jSeparator1, "North");
        this.btnCancel.setText(POSConstants.SAVE_BUTTON_TEXT);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DrawerAndStaffBankReportHistoryDialog.this.btnCloseActionPerformed(evt);
            }
        });
        bottomActionPanel.add(this.btnCancel);
        container.add((Component)bottomActionPanel, "Center");
        this.getContentPane().add((Component)container, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.titlePanel, "North");
        jScrollPane1.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 15, 10, 15), jScrollPane1.getBorder()));
        jScrollPane1.setViewportView(this.tableDrawerReport);
        contentPanel.add((Component)jScrollPane1, "Center");
        JPanel cashSummaryPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 20 0 20"));
        this.lblTotalCash = new JLabel();
        Font font = new Font(null, 1, 14);
        this.lblTotalCash.setFont(font);
        JLabel lblCash = new JLabel("TOTAL CASH DEPOSIT: ");
        lblCash.setFont(font);
        cashSummaryPanel.add(lblCash);
        cashSummaryPanel.add((Component)this.lblTotalCash, "gapright 20");
        contentPanel.add((Component)cashSummaryPanel, "South");
        this.getContentPane().add((Component)contentPanel, "Center");
        this.setSize(PosUIManager.getSize(830, 550));
    }

    private void showReport(CashDrawer report) {
        if (report == null) {
            return;
        }
        if (report.getDrawerType() == DrawerType.STAFF_BANK) {
            this.showBankStatus(report);
        } else {
            this.showDrawerStatus(report);
        }
    }

    private void showBankStatus(CashDrawer report) {
        try {
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.user, report);
            dialog.setTitle("BANK STATUS");
            dialog.showInfoOnly(true);
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void showDrawerStatus(CashDrawer report) {
        try {
            if (report.getTerminal() == null) {
                return;
            }
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.user, report);
            dialog.setTitle(POSConstants.DRAWER_PULL_BUTTON_TEXT);
            dialog.showInfoOnly(true);
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void setInfo(String info) {
        this.titlePanel.setTitle(info);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            if (column == 0) {
                CashDrawer cashDrawer = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.drawerPullReportList.get(row);
                Terminal terminal = cashDrawer.getTerminal();
                if (cashDrawer.getDrawerType() != DrawerType.STAFF_BANK && terminal != null && terminal.getId().intValue() == DrawerAndStaffBankReportHistoryDialog.this.currentTerminal.getId().intValue()) {
                    label.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                }
            }
            if (value instanceof Date) {
                String string = this.dateFormat.format(value);
                label.setText(string);
                label.setHorizontalAlignment(4);
            }
            if (column == 3 || column == 4 || value instanceof Double) {
                label.setHorizontalAlignment(4);
            } else {
                label.setHorizontalAlignment(2);
            }
            if (column == 1 || column == 2) {
                label.setHorizontalAlignment(0);
            }
            return label;
        }
    }

    class DrawerReportTableModel
    extends ListTableModel<CashDrawer> {
        private double totalCashDeposit;

        public DrawerReportTableModel() {
            super(new String[]{"Drawer/Staff Bank Name", "Type", "Status", "Cash Deposit", "Final Balance", ""});
        }

        public void setItems(List<CashDrawer> drawerPullReportList) {
            double totalCashDeposit = 0.0;
            if (drawerPullReportList != null) {
                for (CashDrawer report : drawerPullReportList) {
                    totalCashDeposit += report.getCashToDeposit().doubleValue();
                }
            }
            this.setTotalCashDeposit(totalCashDeposit);
            this.setRows(drawerPullReportList);
        }

        public double getTotalCashDeposit() {
            return this.totalCashDeposit;
        }

        public void setTotalCashDeposit(double totalCashDeposit) {
            this.totalCashDeposit = totalCashDeposit;
        }

        @Override
        public int getRowCount() {
            if (DrawerAndStaffBankReportHistoryDialog.this.drawerPullReportList == null) {
                return 0;
            }
            int size = DrawerAndStaffBankReportHistoryDialog.this.drawerPullReportList.size();
            return size;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }

        public CashDrawer getSelectedRow() {
            int index = DrawerAndStaffBankReportHistoryDialog.this.tableDrawerReport.getSelectedRow();
            if (index < 0) {
                return null;
            }
            index = DrawerAndStaffBankReportHistoryDialog.this.tableDrawerReport.convertRowIndexToModel(index);
            return (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.tableModel.getRowData(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (DrawerAndStaffBankReportHistoryDialog.this.drawerPullReportList == null) {
                return "";
            }
            CashDrawer t = (CashDrawer)DrawerAndStaffBankReportHistoryDialog.this.drawerPullReportList.get(rowIndex);
            User assignedUser = t.getAssignedUser();
            switch (columnIndex) {
                case 0: {
                    if (t.getDrawerType() == DrawerType.DRAWER) {
                        return "Terminal - " + t.getTerminal();
                    }
                    return t.getAssignedUser();
                }
                case 1: {
                    return t.getDrawerType().toString();
                }
                case 2: {
                    if (assignedUser != null) {
                        return t.getReportTime() == null ? "ASSIGNED" : "CLOSED";
                    }
                }
                case 3: {
                    if (assignedUser != null) {
                        return NumberUtil.formatNumber(t.getCashToDeposit());
                    }
                }
                case 4: {
                    if (assignedUser != null) {
                        return NumberUtil.formatNumber(t.getDrawerAccountable());
                    }
                }
                case 5: {
                    return "STATUS";
                }
            }
            return "";
        }
    }
}

