/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class GratuityDialog
extends OkCancelOptionDialog
implements ActionListener {
    private JList<User> userJList;
    private JButton btnGo;
    private JLabel lblUserId;
    private JLabel lblUserName;
    private JLabel lblTotalGratuity;
    private JTable tableGratuityViewer;
    private JPanel contentPane;
    private GratuityTableModel gratuityTableModel;
    private PosButton btnGratuityHistory;
    private JLabel lblTipsDue;
    private JLabel lblTipsPaid;
    private PosButton btnGratuityDetails;
    private Map<String, TipsCashoutReportData> itemMap;
    private User currentUser;

    public GratuityDialog(Window parent, User assignedUser) {
        super(parent, "");
        this.currentUser = assignedUser;
        this.setModal(true);
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
        UserDAO userDAO = new UserDAO();
        ArrayList<Object> users = new ArrayList<Object>();
        users.add("ALL");
        users.addAll(userDAO.findAll());
        this.userJList.setModel(new ListComboBoxModel(users));
        this.tableGratuityViewer.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.tableGratuityViewer.setRowHeight(PosUIManager.getSize(35));
        this.tableGratuityViewer.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.gratuityTableModel = new GratuityTableModel(null);
        this.tableGratuityViewer.setModel(this.gratuityTableModel);
        for (Object e : users) {
            if (!(e instanceof User) || !((User)e).getId().equals(assignedUser.getId())) continue;
            this.userJList.setSelectedValue(e, true);
            break;
        }
        this.btnGo.addActionListener(this);
    }

    private void initComponents() {
        this.setCaption("SERVER GRATUITY");
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new MigLayout("fill"));
        this.userJList = new JList();
        JPanel leftUserListPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        leftUserListPanel.setBorder(BorderFactory.createTitledBorder("Users"));
        leftUserListPanel.setPreferredSize(PosUIManager.getSize(200, 0));
        leftUserListPanel.add((Component)new JScrollPane(this.userJList), "grow");
        this.getContentPanel().add((Component)leftUserListPanel, "West");
        this.userJList.setFixedCellHeight(40);
        this.userJList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GratuityDialog.this.showGratuity(GratuityDialog.this.getSelectedUser());
            }
        });
        this.btnGo = new JButton();
        this.btnGratuityHistory = new PosButton();
        this.btnGratuityHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GratuityDialog.this.showServerTipsHistory();
            }
        });
        this.btnGratuityHistory.setText("HISTORY");
        this.btnGratuityDetails = new PosButton();
        this.btnGratuityDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GratuityDialog.this.showServerTipsDetails();
            }
        });
        this.btnGratuityDetails.setText("DETAILS");
        this.getButtonPanel().add((Component)this.btnGratuityDetails, 0);
        this.getButtonPanel().add((Component)this.btnGratuityHistory, 0);
        this.contentPane.add(new JLabel(POSConstants.USER_ID + ":"));
        this.lblUserId = new JLabel();
        this.contentPane.add((Component)this.lblUserId, "wrap");
        this.contentPane.add(new JLabel(POSConstants.USER_NAME + ":"));
        this.lblUserName = new JLabel();
        this.contentPane.add((Component)this.lblUserName, "wrap");
        this.contentPane.add(new JLabel(POSConstants.DETAILS));
        this.contentPane.add((Component)new JSeparator(), "grow,span");
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, "grow,span");
        this.tableGratuityViewer = new JTable();
        scrollPane1.setViewportView(this.tableGratuityViewer);
        this.contentPane.add((Component)new JSeparator(), "newline,span");
        JLabel lblGratuity = new JLabel(POSConstants.TOTAL_GRATUITY + ":");
        this.lblTotalGratuity = new JLabel();
        this.lblTipsPaid = new JLabel();
        this.lblTipsDue = new JLabel();
        Font font = new Font(null, 1, 14);
        this.lblTipsDue.setFont(font);
        this.contentPane.add((Component)lblGratuity, "split 2,right,span");
        this.contentPane.add((Component)this.lblTotalGratuity, "wrap,gapright 5");
        this.contentPane.add((Component)new JLabel("Paid amount: "), "split 2,right,span");
        this.contentPane.add((Component)this.lblTipsPaid, "wrap,gapright 5");
        this.contentPane.add((Component)new JLabel("Due amount: "), "split 2,right,span");
        this.contentPane.add((Component)this.lblTipsDue, "wrap,gapright 5");
        this.getContentPanel().add(this.contentPane);
    }

    private void showServerTipsHistory() {
        try {
            ListComboBoxModel model = (ListComboBoxModel)this.userJList.getModel();
            TipsCashoutReportDialog dialog = new TipsCashoutReportDialog(null, model, this.getSelectedUser(), true);
            dialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            dialog.setSize(650, 600);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void showServerTipsDetails() {
        try {
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport report = gratuityDAO.createReport(null, null, this.getSelectedUser());
            TipsCashoutReportDialog dialog = new TipsCashoutReportDialog(report);
            dialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            dialog.setSize(650, 600);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void showGratuity(User user) {
        GratuityDAO dao = new GratuityDAO();
        List<Gratuity> gratuities = dao.findByUser(user, true);
        this.itemMap = new HashMap<String, TipsCashoutReportData>();
        for (Gratuity gratuity : gratuities) {
            String ownerId = gratuity.getOwnerId();
            if (ownerId == null) continue;
            TipsCashoutReportData serverTipsData = this.itemMap.get(ownerId);
            if (serverTipsData == null) {
                TipsCashoutReportData newTipsData = new TipsCashoutReportData();
                newTipsData.setOwner(user);
                newTipsData.setTicketId(gratuity.getTicketId());
                newTipsData.setAmount(gratuity.getTransactionTipsAmount());
                newTipsData.setTipsPaidAmount(gratuity.getTipsPaidAmount());
                this.itemMap.put(ownerId, newTipsData);
                continue;
            }
            serverTipsData.setAmount(serverTipsData.getAmount() + gratuity.getTransactionTipsAmount());
            serverTipsData.setTipsPaidAmount(serverTipsData.getTipsPaidAmount() + gratuity.getTipsPaidAmount());
        }
        double totalGratuity = 0.0;
        double paidTips = 0.0;
        Iterator<TipsCashoutReportData> iterator = this.itemMap.values().iterator();
        while (iterator.hasNext()) {
            TipsCashoutReportData data = iterator.next();
            if (data.getAmount() - data.getTipsPaidAmount() <= 0.0) {
                iterator.remove();
                continue;
            }
            totalGratuity += data.getAmount().doubleValue();
            paidTips += data.getTipsPaidAmount().doubleValue();
        }
        if (user != null) {
            this.lblUserId.setText(String.valueOf(user.getId()));
            this.lblUserName.setText(user.getFirstName() + " " + user.getLastName());
        } else {
            this.lblUserId.setText("ALL");
            this.lblUserName.setText("ALL");
        }
        this.lblTotalGratuity.setText(NumberUtil.formatNumber(totalGratuity));
        this.lblTipsPaid.setText(NumberUtil.formatNumber(paidTips));
        this.lblTipsDue.setText(NumberUtil.formatNumber(totalGratuity - paidTips));
        this.gratuityTableModel.setRows(new ArrayList<TipsCashoutReportData>(this.itemMap.values()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.GO.equalsIgnoreCase(actionCommand)) {
            this.showGratuity(this.getSelectedUser());
        }
    }

    private User getSelectedUser() {
        User selectedObj = this.userJList.getSelectedValue();
        if (selectedObj instanceof User) {
            return selectedObj;
        }
        return null;
    }

    @Override
    public void doOk() {
        try {
            List<Gratuity> rows;
            User user = this.getSelectedUser();
            TipsCashoutReportData tipsData = null;
            if (user == null) {
                int selectedRow = this.tableGratuityViewer.getSelectedRow();
                if (selectedRow == -1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select tips entry which you want to pay.");
                    return;
                }
                tipsData = (TipsCashoutReportData)this.gratuityTableModel.getRowData(selectedRow);
                if (tipsData == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select tips entry which you want to pay.");
                    return;
                }
                user = UserDAO.getInstance().get(tipsData.getOwner().getId());
            }
            if ((rows = GratuityDAO.getInstance().findByUser(user, false)) == null || rows.size() <= 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Grautity not found.");
                return;
            }
            if (tipsData == null && this.gratuityTableModel.getRowCount() > 0) {
                tipsData = (TipsCashoutReportData)this.gratuityTableModel.getRowData(0);
            }
            double tipsDueAmount = 0.0;
            if (tipsData != null) {
                try {
                    tipsDueAmount = tipsData.getAmount() - tipsData.getTipsPaidAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tipsDueAmount == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Nothing to pay.");
                return;
            }
            Double cashTipsPayAmount = NumberSelectionDialog2.takeDoubleInput("Enter tips amount ", tipsDueAmount = NumberUtil.roundToTwoDigit(tipsDueAmount));
            if (cashTipsPayAmount == -1.0) {
                return;
            }
            if (cashTipsPayAmount < 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Negetive amount not allowed.");
                return;
            }
            if (cashTipsPayAmount > tipsDueAmount) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Exceed tips amount cannot be accepted.");
                return;
            }
            double totalInputTipsAmount = cashTipsPayAmount;
            ArrayList<Gratuity> gratuityList = new ArrayList<Gratuity>();
            ArrayList<GratuityPaymentHistory> gratuityPaymentHistoryList = new ArrayList<GratuityPaymentHistory>();
            for (Gratuity gratuity : rows) {
                if (gratuity.isPaid().booleanValue()) continue;
                gratuityList.add(gratuity);
                double tipsTenderedAmount = gratuity.getAmount();
                double paidAmount = gratuity.getTipsPaidAmount();
                gratuity.calculateTransactionTips();
                double tipsTransactionAmount = gratuity.getTransactionTipsAmount();
                double tipsDue = NumberUtil.roundToTwoDigit(tipsTransactionAmount - paidAmount);
                GratuityPaymentHistory paymentHistory = new GratuityPaymentHistory();
                paymentHistory.setAmount(tipsDue);
                paymentHistory.setTenderedAmount(totalInputTipsAmount);
                paymentHistory.setCashDrawer(user.getActiveDrawerPullReport());
                paymentHistory.setTransactionTime(new Date());
                paymentHistory.setGratuity(gratuity);
                paymentHistory.setPaidBy(this.currentUser);
                paymentHistory.setStoreSessionId(DataProvider.get().getStoreSession().getId());
                gratuityPaymentHistoryList.add(paymentHistory);
                if (cashTipsPayAmount == tipsDue) {
                    gratuity.setTipsPaidAmount(paidAmount + tipsDue);
                    if (tipsTenderedAmount != tipsTransactionAmount) break;
                    gratuity.setPaid(true);
                    break;
                }
                if (cashTipsPayAmount > tipsDue) {
                    gratuity.setTipsPaidAmount(paidAmount + tipsDue);
                    if (tipsTenderedAmount == tipsTransactionAmount) {
                        gratuity.setPaid(true);
                    }
                    cashTipsPayAmount = cashTipsPayAmount - tipsDue;
                    continue;
                }
                paymentHistory.setAmount(cashTipsPayAmount);
                gratuity.setTipsPaidAmount(paidAmount + cashTipsPayAmount);
                gratuity.setPaid(false);
                break;
            }
            new GratuityDAO().payGratuities(gratuityList, gratuityPaymentHistoryList);
            String actionMessage = POSConstants.PAY_TIPS;
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.PAY_TIPS, actionMessage);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Successfully complete");
            this.showGratuity(this.getSelectedUser());
        }
        catch (PosException ex) {
            BOMessageDialog.showError(this.contentPane, ex.getMessage(), ex);
        }
    }

    private class GratuityTableModel
    extends ListTableModel {
        public GratuityTableModel(List<TipsCashoutReportData> gratuities) {
            super(new String[]{"User Id", POSConstants.FIRST_NAME, POSConstants.LAST_NAME, POSConstants.AMOUNT, "Due"}, gratuities);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TipsCashoutReportData gratuity = (TipsCashoutReportData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return gratuity.getOwner().getId();
                }
                case 1: {
                    return gratuity.getOwner().getFirstName();
                }
                case 2: {
                    return gratuity.getOwner().getLastName();
                }
                case 3: {
                    return NumberUtil.roundToTwoDigit(gratuity.getAmount());
                }
                case 4: {
                    return NumberUtil.roundToTwoDigit(gratuity.getAmount() - gratuity.getTipsPaidAmount());
                }
            }
            return null;
        }
    }
}

