/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.config.AppProperties;
import com.floreantpos.model.GuestCheckPrint;
import com.floreantpos.model.dao.GuestCheckPrintDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class GuestChkBillDialog
extends POSDialog {
    private BeanTableModel<GuestCheckPrint> tableModel;

    public GuestChkBillDialog() {
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        this.setLayout((LayoutManager)new MigLayout("fill"));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.add((Component)mainPanel, "grow");
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Time Since Bill Print");
        JTable table = new JTable();
        this.tableModel = new BeanTableModel(GuestCheckPrint.class);
        this.tableModel.addColumn("Ticket Id", "ticketId");
        this.tableModel.addColumn("Table #", "tableNo");
        this.tableModel.addColumn("Server", "user");
        this.tableModel.addColumn("Print", "printTime");
        this.tableModel.addColumn("Elapsed Time", "diffInBillPrint");
        table.setModel(this.tableModel);
        table.setRowHeight(60);
        table.setDefaultRenderer(Object.class, new PosTableRenderer());
        table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Integer) {
                    lbl.setHorizontalAlignment(2);
                    return lbl;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        table.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm a");
                    return super.getTableCellRendererComponent(table, dateFormat.format(date), isSelected, hasFocus, row, column);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnDone = new PosButton("Done");
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuestChkBillDialog.this.dispose();
            }
        });
        bottomPanel.add(btnDone);
        mainPanel.add((Component)titlePanel, "North");
        mainPanel.add((Component)new JScrollPane(table), "Center");
        mainPanel.add((Component)bottomPanel, "South");
    }

    private void initData() {
        List<GuestCheckPrint> guestCheckPrints = GuestCheckPrintDAO.getInstance().findRecentPrints();
        this.tableModel.setRows(guestCheckPrints);
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(100);
        columnWidth.add(200);
        columnWidth.add(200);
        return columnWidth;
    }
}

