/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.ImageUploaderDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ImagePanel;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class ImageGalleryDialog
extends POSDialog
implements ActionListener {
    private static ImageGalleryDialog instance = null;
    private JPanel centerPanel;
    private JButton btnBack;
    private JButton btnForward;
    private ImageResource selectedImageResource;
    private PaginatedTableModel imageGalleryModel = new PaginatedTableModel(){

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    };
    private JPanel southPanel;
    private POSToggleButton tbtnAll;
    private POSToggleButton tbtnUnlisted;
    private POSToggleButton tbtnFloorPlan;
    private POSToggleButton tbtnProducts;
    private POSToggleButton tbtnPeople;
    private POSToggleButton tbtnDeleted;
    private ImageResource.IMAGE_CATEGORY defaultCategory;
    private JButton btnSearch;
    private POSTextField tfSearch;
    private PosButton btnDelete;
    private int maxWidth;
    private int maxHeight;
    private PosButton btnSelect;

    public static synchronized ImageGalleryDialog getInstance() {
        if (instance == null) {
            instance = new ImageGalleryDialog();
        }
        return instance;
    }

    private ImageGalleryDialog() {
        super((Window)POSUtil.getBackOfficeWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.imageGalleryModel.setPageSize(10);
        this.imageGalleryModel.setNumRows(BaseImageResourceDAO.getInstance().rowCount());
        this.init();
        this.setSize(PosUIManager.getSize(950, 720));
        this.setResizable(true);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Image Gallery");
        topPanel.add((Component)titlePanel, "North");
        JPanel filterPanel = new JPanel();
        ButtonGroup btnGroup = new ButtonGroup();
        this.tbtnAll = new POSToggleButton("ALL");
        this.tbtnUnlisted = new POSToggleButton("UNLISTED");
        this.tbtnFloorPlan = new POSToggleButton("FLOORPLAN");
        this.tbtnProducts = new POSToggleButton("PRODUCTS");
        this.tbtnPeople = new POSToggleButton("PEOPLE");
        this.tbtnDeleted = new POSToggleButton("DELETED");
        btnGroup.add(this.tbtnAll);
        btnGroup.add(this.tbtnUnlisted);
        btnGroup.add(this.tbtnFloorPlan);
        btnGroup.add(this.tbtnProducts);
        btnGroup.add(this.tbtnPeople);
        btnGroup.add(this.tbtnDeleted);
        this.tbtnAll.addActionListener(this);
        this.tbtnUnlisted.addActionListener(this);
        this.tbtnFloorPlan.addActionListener(this);
        this.tbtnProducts.addActionListener(this);
        this.tbtnPeople.addActionListener(this);
        this.tbtnDeleted.addActionListener(this);
        filterPanel.add(this.tbtnAll);
        filterPanel.add(this.tbtnUnlisted);
        filterPanel.add(this.tbtnFloorPlan);
        filterPanel.add(this.tbtnProducts);
        filterPanel.add(this.tbtnPeople);
        filterPanel.add(this.tbtnDeleted);
        topPanel.add((Component)filterPanel, "Center");
        JLabel lblSearch = new JLabel("Search");
        lblSearch.setHorizontalAlignment(0);
        this.tfSearch = new POSTextField(25);
        this.btnSearch = new JButton("Search");
        JPanel searchPanel = new JPanel();
        searchPanel.add((Component)lblSearch, "right,growx");
        searchPanel.add((Component)this.tfSearch, "grow");
        searchPanel.add((Component)this.btnSearch, "grow");
        topPanel.add((Component)searchPanel, "Last");
        this.add((Component)topPanel, "North");
        this.centerPanel = new JPanel((LayoutManager)new MigLayout("center,wrap 5", "sg,fill", ""));
        this.centerPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.southPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.centerPanel, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel backwordForwardButtonPanel = new JPanel(new BorderLayout(5, 5));
        backwordForwardButtonPanel.setBorder(new EmptyBorder(10, 5, 0, 5));
        this.btnBack = new JButton("<<<");
        this.btnForward = new JButton(">>>");
        this.btnBack.setEnabled(false);
        backwordForwardButtonPanel.add((Component)this.btnBack, "West");
        backwordForwardButtonPanel.add((Component)this.btnForward, "East");
        this.tbtnAll.setSelected(true);
        this.defaultCategory = null;
        this.createImagePanel(this.defaultCategory, null);
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.imageGalleryModel.setCurrentRowIndex(ImageGalleryDialog.this.imageGalleryModel.getNextRowIndex());
                ImageGalleryDialog.this.createImagePanel(ImageGalleryDialog.this.defaultCategory, null);
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.imageGalleryModel.setCurrentRowIndex(ImageGalleryDialog.this.imageGalleryModel.getPreviousRowIndex());
                ImageGalleryDialog.this.createImagePanel(ImageGalleryDialog.this.defaultCategory, null);
            }
        });
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.setLayout(new BorderLayout());
        JPanel insideBtnPanel = new JPanel(new FlowLayout());
        buttonPanel.add(insideBtnPanel);
        PosButton btnUpload = new PosButton("Upload");
        btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.doShowUploadDialog();
            }
        });
        PosButton btnBulkImport = new PosButton("Bulk import");
        btnBulkImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.doShowBulkImportDialog();
            }
        });
        JPanel westPanel = new JPanel();
        westPanel.add(btnUpload);
        westPanel.add(btnBulkImport);
        buttonPanel.add((Component)westPanel, "West");
        PosButton btnCancel = new PosButton("Close");
        buttonPanel.add((Component)btnCancel, "East");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.setCanceled(true);
                ImageGalleryDialog.this.dispose();
            }
        });
        PosButton btnEdit = new PosButton("Edit");
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.doShowEditDialog();
            }
        });
        this.btnDelete = new PosButton("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.doDeleteImage();
            }
        });
        this.btnSelect = new PosButton("Select");
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageGalleryDialog.this.selectedImageResource == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select image!");
                    return;
                }
                ImageGalleryDialog.this.setCanceled(false);
                ImageGalleryDialog.this.dispose();
            }
        });
        insideBtnPanel.add(this.btnSelect);
        insideBtnPanel.add(btnEdit);
        insideBtnPanel.add(this.btnDelete);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.createImagePanel(ImageGalleryDialog.this.defaultCategory, ImageGalleryDialog.this.tfSearch.getText());
            }
        });
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGalleryDialog.this.createImagePanel(ImageGalleryDialog.this.defaultCategory, ImageGalleryDialog.this.tfSearch.getText());
            }
        });
        this.southPanel.add((Component)backwordForwardButtonPanel, "North");
        this.southPanel.add((Component)buttonPanel, "South");
        this.add((Component)this.southPanel, "South");
    }

    public ImageResource getImageResource() {
        if (this.selectedImageResource != null) {
            return this.selectedImageResource;
        }
        return null;
    }

    private void createImagePanel(ImageResource.IMAGE_CATEGORY imgCategory, String description) {
        this.centerPanel.removeAll();
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
        BaseImageResourceDAO.getInstance().getImages(this.imageGalleryModel, imgCategory, description);
        List rows = this.imageGalleryModel.getRows();
        ButtonGroup btnGroup = new ButtonGroup();
        for (ImageResource imageResource : rows) {
            ImagePanel imgPanel = new ImagePanel(this, imageResource, btnGroup);
            this.centerPanel.add((Component)imgPanel, "aligny, top");
        }
        this.btnBack.setEnabled(this.imageGalleryModel.hasPrevious());
        this.btnForward.setEnabled(this.imageGalleryModel.hasNext());
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doCategorySelection(e);
    }

    private void doCategorySelection(ActionEvent e) {
        JToggleButton tgButton = (JToggleButton)e.getSource();
        if (tgButton.isSelected()) {
            this.selectedImageResource = (ImageResource)tgButton.getClientProperty("selected");
        }
        if (e.getSource() == this.tbtnAll) {
            this.defaultCategory = null;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(true);
        } else if (e.getSource() == this.tbtnUnlisted) {
            this.defaultCategory = ImageResource.IMAGE_CATEGORY.UNLISTED;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(true);
        } else if (e.getSource() == this.tbtnFloorPlan) {
            this.defaultCategory = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(true);
        } else if (e.getSource() == this.tbtnPeople) {
            this.defaultCategory = ImageResource.IMAGE_CATEGORY.PEOPLE;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(true);
        } else if (e.getSource() == this.tbtnProducts) {
            this.defaultCategory = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(true);
        } else if (e.getSource() == this.tbtnDeleted) {
            this.defaultCategory = ImageResource.IMAGE_CATEGORY.DELETED;
            this.createImagePanel(this.defaultCategory, null);
            this.btnDelete.setEnabled(false);
        }
    }

    private void doDeleteImage() {
        if (this.selectedImageResource == null) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to delete this item?", "Delete");
        if (option != 0) {
            return;
        }
        try {
            this.selectedImageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.DELETED.getType());
            BaseImageResourceDAO.getInstance().delete(this.selectedImageResource);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Image successfully deleted!");
            this.createImagePanel(this.defaultCategory, null);
        }
        catch (Exception error) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), error.getMessage(), error);
        }
    }

    private void doShowUploadDialog() {
        try {
            ImageUploaderDialog dialog = new ImageUploaderDialog(null);
            dialog.setImageMaximumSize(this.maxWidth, this.maxHeight);
            dialog.selectImage();
            File selectedImageFile = dialog.getSelectedImageFile();
            if (selectedImageFile == null) {
                return;
            }
            dialog.setTitle("Image Upload");
            dialog.setDefaultCloseOperation(2);
            dialog.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.createImagePanel(this.defaultCategory, null);
        }
        catch (PosException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", 0);
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            JOptionPane.showMessageDialog(null, "Unexpected error", "Error", 0);
        }
    }

    private void doShowBulkImportDialog() {
        try {
            ImageUploaderDialog dialog = new ImageUploaderDialog();
            dialog.setImageMaximumSize(this.maxWidth, this.maxHeight);
            dialog.selectBulkImage();
            List<File> selectedImageFile = dialog.getSelectedImageFiles();
            if (selectedImageFile == null || selectedImageFile.size() < 1) {
                return;
            }
            dialog.setTitle("Image Upload");
            dialog.setDefaultCloseOperation(2);
            dialog.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.createImagePanel(this.defaultCategory, null);
        }
        catch (PosException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", 0);
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            JOptionPane.showMessageDialog(null, "Unexpected error", "Error", 0);
        }
    }

    private void doShowEditDialog() {
        if (this.selectedImageResource == null) {
            return;
        }
        ImageUploaderDialog dialog = new ImageUploaderDialog(this.selectedImageResource);
        dialog.setTitle("Image Edit");
        dialog.setDefaultCloseOperation(2);
        dialog.openFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        this.createImagePanel(this.defaultCategory, null);
    }

    public void setImageMaximumSize(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setSelectBtnVisible(boolean isVisible) {
    }
}

