/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    public static ImageResource.IMAGE_CATEGORY imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    public JLabel lblImagePreview;
    public JLabel lblDescription;
    public File imageFile;
    public File[] imageFiles;
    public ImageResource imgResource;
    public POSTextField tfDescription;
    public POSToggleButton tbtnUnlisted;
    public POSToggleButton tbtnFloorPlan;
    public POSToggleButton tbtnProducts;
    public POSToggleButton tbtnPeople;
    private int maxWidth;
    private int maxHeight;
    private JPanel imagePanel;
    private ArrayList<File> imageList;
    private boolean isMultipleSelection;
    private JProgressBar progressBar;
    private JLabel lblProgressing;
    private PosButton btnSelect;
    boolean cancel = false;

    public ImageUploaderDialog(ImageResource imgResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imgResource = imgResource;
        this.init();
        this.updateView();
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.init();
        this.updateView();
        this.isMultipleSelection = true;
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Image Upload");
        this.add((Component)titlePanel, "North");
        JPanel filterPanel = new JPanel();
        ButtonGroup btnGroup = new ButtonGroup();
        this.tbtnUnlisted = new POSToggleButton("UNLISTED");
        this.tbtnFloorPlan = new POSToggleButton("FLOORPLAN");
        this.tbtnProducts = new POSToggleButton("PRODUCTS");
        this.tbtnPeople = new POSToggleButton("PEOPLE");
        btnGroup.add(this.tbtnUnlisted);
        btnGroup.add(this.tbtnFloorPlan);
        btnGroup.add(this.tbtnProducts);
        btnGroup.add(this.tbtnPeople);
        filterPanel.add(this.tbtnUnlisted);
        filterPanel.add(this.tbtnFloorPlan);
        filterPanel.add(this.tbtnProducts);
        filterPanel.add(this.tbtnPeople);
        this.tbtnProducts.setEnabled(true);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setBorder(new EmptyBorder(20, 5, 20, 5));
        centerPanel.add((Component)filterPanel, "North");
        this.lblImagePreview = new JLabel();
        this.lblDescription = new JLabel("Description");
        this.tfDescription = new POSTextField(50);
        JLabel lblSeparator = new JLabel(" ");
        this.imagePanel = new JPanel(new FlowLayout());
        this.imagePanel.add((Component)this.lblImagePreview, "center");
        JScrollPane scrollPane = new JScrollPane(this.imagePanel, 20, 30);
        scrollPane.setPreferredSize(new Dimension(350, 220));
        scrollPane.setVisible(true);
        centerPanel.add(scrollPane);
        JPanel desPanel = new JPanel();
        desPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        desPanel.setLayout(new BorderLayout(5, 0));
        desPanel.add((Component)this.lblDescription, "West");
        desPanel.add((Component)this.tfDescription, "Center");
        centerPanel.add((Component)desPanel, "South");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(40, 40, 160, 30);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setStringPainted(true);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.btnSelect = new PosButton("Select Image");
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ImageUploaderDialog.this.isMultipleSelection) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", 0);
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Unsupported File Format", "Error", 0);
                }
            }
        });
        PosButton btnOk = new PosButton("Done");
        btnOk.setPreferredSize(PosUIManager.getSize(100, 0));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton btnCancel = new PosButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.lblProgressing = new JLabel("Importing Images: ");
        this.lblProgressing.setVisible(false);
        buttonPanel.add((Component)this.btnSelect, "");
        buttonPanel.add((Component)this.lblProgressing, "left,split 2");
        buttonPanel.add((Component)this.progressBar, "");
        buttonPanel.add((Component)btnOk, "growy,right,skip 2, split 2");
        buttonPanel.add((Component)btnCancel, "");
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void doOk() {
        if (!this.isMultipleSelection) {
            this.doSaveSingleImage();
            ImageResourceDAO.getInstance().saveOrUpdate(this.imgResource);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void doSaveSingleImage() {
        try {
            if (this.imgResource == null) {
                this.imgResource = new ImageResource();
            }
            this.imgResource.setDescription(this.tfDescription.getText());
            File imageFile = (File)this.lblImagePreview.getClientProperty("image");
            if (imageFile != null) {
                this.imgResource.setImageData(POSUtil.convertImageToBlob(imageFile));
            }
            if (this.tbtnUnlisted.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.tbtnFloorPlan.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.tbtnPeople.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.tbtnProducts.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception e) {
            PosLog.error(ImageUploaderDialog.class, e.getMessage(), e);
        }
    }

    public void doSaveMultipleImage() {
        try {
            ArrayList<ImageResource> imageResourceList = new ArrayList<ImageResource>();
            for (File file : this.imageList) {
                this.imgResource = new ImageResource();
                if (file != null) {
                    this.imgResource.setImageData(POSUtil.convertImageToBlob(file));
                }
                if (this.tbtnUnlisted.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.tbtnFloorPlan.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.tbtnPeople.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.tbtnProducts.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                imageResourceList.add(this.imgResource);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(imageResourceList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectBulkImage() throws Exception {
        block7: {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser fileChooser = null;
            fileChooser = LAST_USED_FOLDER != null ? new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new JFileChooser();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setAcceptAllFileFilterUsed(false);
            int option = fileChooser.showOpenDialog(this);
            this.imageList = new ArrayList();
            if (option == 0) {
                File[] selectedFiles;
                for (File file : selectedFiles = fileChooser.getSelectedFiles()) {
                    if (file.isDirectory()) {
                        File[] f = file.listFiles();
                        for (int i = 0; i < f.length; ++i) {
                            if (f[i].isDirectory()) {
                                this.addFileIfImageType(f[i]);
                                continue;
                            }
                            this.addFileIfImageType(f[i]);
                        }
                        continue;
                    }
                    this.addFileIfImageType(file);
                }
                break block7;
            }
            return;
        }
        System.out.println();
    }

    public void showImages() {
        if (!this.isMultipleSelection) {
            this.progressBar.setVisible(false);
            return;
        }
        this.btnSelect.setVisible(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageUploaderDialog.this.cancel) {
                        return;
                    }
                    int i = 1;
                    ImageUploaderDialog.this.progressBar.setMaximum(ImageUploaderDialog.this.imageList.size());
                    ImageUploaderDialog.this.lblProgressing.setVisible(true);
                    for (File file : ImageUploaderDialog.this.imageList) {
                        JLabel lblImagePreview = new JLabel();
                        BufferedImage rImage = ImageIO.read(file);
                        lblImagePreview.putClientProperty("image", file);
                        ImageIcon imageIcon = new ImageIcon(rImage.getScaledInstance(500, 500, 1));
                        lblImagePreview.setIcon(imageIcon);
                        ImageUploaderDialog.this.imagePanel.add(lblImagePreview);
                        ImageUploaderDialog.this.imagePanel.revalidate();
                        ImageUploaderDialog.this.imagePanel.repaint();
                        Thread.sleep(500L);
                        ImageUploaderDialog.this.progressBar.setValue(i);
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addFileIfImageType(File file) {
        String mimetype = new MimetypesFileTypeMap().getContentType(file);
        String type = mimetype.split("/")[0];
        if (type.equals("image")) {
            this.imageList.add(file);
        }
    }

    public void selectImage() throws Exception {
        block8: {
            Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
            JFileChooser fileChooser = null;
            fileChooser = LAST_USED_FOLDER != null ? new JFileChooser(prefs.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new JFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            int option = fileChooser.showOpenDialog(this);
            if (option != 0) break block8;
            this.imageFile = fileChooser.getSelectedFile();
            prefs.put(LAST_USED_FOLDER, this.imageFile.getPath());
            byte[] itemImage = FileUtils.readFileToByteArray((File)this.imageFile);
            int imageSize = itemImage.length / 1024;
            Image rImage = null;
            if (imageSize > 500 && this.maxWidth <= 0 && this.maxHeight <= 0) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "The image is too large. Do you want to resize?", "Confirm") != 0) {
                    itemImage = null;
                    throw new PosException("The image is too large. Please select an image within 500kb in size");
                }
                this.maxWidth = 200;
                this.maxHeight = 200;
            }
            if (this.maxWidth > 0 && this.maxHeight > 0) {
                rImage = ImageIO.read(this.imageFile).getScaledInstance(this.maxWidth, this.maxHeight, 4);
                BufferedImage bufferedImage = new BufferedImage(rImage.getWidth(null), rImage.getHeight(null), 2);
                Graphics2D bGr = bufferedImage.createGraphics();
                bGr.drawImage(rImage, 0, 0, null);
                bGr.dispose();
                File outputfile = new File("saved.png");
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
                }
                catch (IOException e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
                }
                this.lblImagePreview.putClientProperty("image", outputfile);
            } else {
                rImage = ImageIO.read(this.imageFile);
                this.lblImagePreview.putClientProperty("image", this.imageFile);
            }
            this.lblImagePreview.setText("");
            this.lblImagePreview.setIcon(new ImageIcon(rImage));
        }
    }

    private void updateView() {
        ImageResource.IMAGE_CATEGORY selectedImageType = imageType;
        if (this.imgResource != null && this.imgResource.getImageCategory() != null) {
            selectedImageType = this.imgResource.getImageCategory();
        }
        if (selectedImageType == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.tbtnUnlisted.setSelected(true);
        } else if (selectedImageType == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.tbtnFloorPlan.setSelected(true);
        } else if (selectedImageType == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.tbtnProducts.setSelected(true);
        } else if (selectedImageType == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.tbtnPeople.setSelected(true);
        }
        if (this.imgResource == null) {
            return;
        }
        ImageIcon rImage = this.imgResource.getScaledImage(120, 120);
        if (rImage == null) {
            return;
        }
        this.lblImagePreview.setText("");
        this.lblImagePreview.setIcon(rImage);
        Image image = rImage.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        File outputfile = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
        }
        catch (IOException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        this.lblImagePreview.putClientProperty("image", outputfile);
        if (this.imgResource.getDescription() != null) {
            this.tfDescription.setText(this.imgResource.getDescription());
        }
    }

    public File getSelectedImageFile() {
        return this.imageFile;
    }

    public List<File> getSelectedImageFiles() {
        return this.imageList;
    }

    public void setImageMaximumSize(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    @Override
    public void open() {
        this.showImages();
        super.open();
    }
}

