/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.views.MenuCategorySelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuCategorySelectionDialog
extends POSDialog
implements ActionListener {
    private MenuCategorySelectionView menuCategorySelectorPanel;
    private List<MenuCategory> categoryList;
    private int selectionMode;
    private TitlePanel titelpanel;
    private static MenuCategorySelectionDialog instance;

    public MenuCategorySelectionDialog(List<MenuCategory> menuCategoryList) {
        super(POSUtil.getFocusedWindow(), "");
        this.categoryList = menuCategoryList;
        this.initComponents();
    }

    public MenuCategorySelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle("Select menu category");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Menu Category");
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle("Select one or more menu category");
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.menuCategorySelectorPanel = new MenuCategorySelectionView(this.categoryList);
        contentPane.add((Component)this.menuCategorySelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton("SELECT");
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton btnEdit = new PosButton();
        PosButton btnAdd = new PosButton();
        btnAdd.setText(POSConstants.ADD.toUpperCase());
        btnEdit.setText(POSConstants.EDIT.toUpperCase());
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuCategory menuCategory = new MenuCategory();
                    MenuCategoryForm editor = new MenuCategoryForm(menuCategory);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(900, 650));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuCategory category = (MenuCategory)editor.getBean();
                    MenuCategorySelectionDialog.this.menuCategorySelectorPanel.getModel().addRow(category);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (selectionMode == 0) {
            this.titelpanel.setTitle("SELECT A MENU CATEGORY");
        } else {
            this.titelpanel.setTitle("Select one or more menu category");
        }
        this.menuCategorySelectorPanel.setSelectionMode(selectionMode);
    }

    public void setSelectedOrderType(OrderType orderType) {
        this.menuCategorySelectorPanel.setSelectedOrdertype(orderType);
    }

    private void doOk() {
        if (this.selectionMode == 0) {
            MenuCategory category = this.getSelectedRowData();
            if (category == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu category");
                return;
            }
        } else {
            List<MenuCategory> menuCategories = this.menuCategorySelectorPanel.getSelectedMenuCategoryList();
            if (menuCategories == null || menuCategories.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu category");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.menuCategorySelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuCategory category = this.menuCategorySelectorPanel.getModel().getRow(index);
            MenuCategoryDAO.getInstance().initialize(category);
            this.menuCategorySelectorPanel.getModel().setRow(index, category);
            MenuCategoryForm editor = new MenuCategoryForm(category);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.menuCategorySelectorPanel.repaintTable();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuCategory> getSelectedCategories() {
        return this.menuCategorySelectorPanel.getSelectedMenuCategoryList();
    }

    public MenuCategory getSelectedRowData() {
        int index = this.menuCategorySelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.menuCategorySelectorPanel.getModel().getRow(index);
    }

    public static MenuCategorySelectionDialog getInstance() {
        if (instance == null) {
            instance = new MenuCategorySelectionDialog();
        }
        return instance;
    }
}

