/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.views.MenuGroupSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuGroupSelectionDialog
extends POSDialog
implements ActionListener {
    private MenuGroupSelectionView menuGroupSelectorPanel;
    private List<MenuGroup> menuGroupList;
    private int selectionMode;
    private TitlePanel titelpanel;
    private static MenuGroupSelectionDialog instance;

    public MenuGroupSelectionDialog(List<MenuGroup> menuGroupList) {
        super(POSUtil.getFocusedWindow(), "");
        this.menuGroupList = menuGroupList;
        this.initComponents();
    }

    public MenuGroupSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle("Select menu group");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Menu Group");
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle("Select one or more menu group");
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.menuGroupSelectorPanel = new MenuGroupSelectionView(this.menuGroupList);
        contentPane.add((Component)this.menuGroupSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton("SELECT");
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton btnEdit = new PosButton();
        PosButton btnAdd = new PosButton();
        btnAdd.setText(POSConstants.ADD.toUpperCase());
        btnEdit.setText(POSConstants.EDIT.toUpperCase());
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroup menuGroup = new MenuGroup();
                    MenuGroupForm editor = new MenuGroupForm(menuGroup);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(900, 650));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    menuGroup = (MenuGroup)editor.getBean();
                    MenuGroupSelectionDialog.this.menuGroupSelectorPanel.getModel().addRow(menuGroup);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (selectionMode == 0) {
            this.titelpanel.setTitle("SELECT A MENU GROUP");
        } else {
            this.titelpanel.setTitle("Select one or more menu group");
        }
        this.menuGroupSelectorPanel.setSelectionMode(selectionMode);
    }

    public void setSelectedGroup(MenuCategory menuCategory) {
        this.menuGroupSelectorPanel.setSelectedCategory(menuCategory);
    }

    private void doOk() {
        if (this.selectionMode == 0) {
            MenuGroup menuItem = this.getSelectedRowData();
            if (menuItem == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu group");
                return;
            }
        } else {
            List<MenuGroup> menuGroupList = this.menuGroupSelectorPanel.getSelectedMenuGroupList();
            if (menuGroupList == null || menuGroupList.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu group");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.menuGroupSelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuGroup menuGroup = this.menuGroupSelectorPanel.getModel().getRow(index);
            MenuGroupDAO.getInstance().initialize(menuGroup);
            this.menuGroupSelectorPanel.getModel().setRow(index, menuGroup);
            MenuGroupForm editor = new MenuGroupForm(menuGroup);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.menuGroupSelectorPanel.repaintTable();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuGroup> getSelectedMenuGroups() {
        return this.menuGroupSelectorPanel.getSelectedMenuGroupList();
    }

    public MenuGroup getSelectedRowData() {
        int index = this.menuGroupSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.menuGroupSelectorPanel.getModel().getRow(index);
    }

    public static MenuGroupSelectionDialog getInstance() {
        if (instance == null) {
            instance = new MenuGroupSelectionDialog();
        }
        return instance;
    }
}

