/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuItemSelectionDialog
extends POSDialog
implements ActionListener {
    private MenuItemSelectionView menuSelectorPanel;
    private List<MenuItem> menuItemList;
    private int selectionMode;
    private TitlePanel titelpanel;
    private boolean inventoryItemOnly;
    private static MenuItemSelectionDialog instance;

    public MenuItemSelectionDialog(List<MenuItem> menuItemList) {
        super(POSUtil.getFocusedWindow(), "");
        this.menuItemList = menuItemList;
        this.initComponents();
    }

    public MenuItemSelectionDialog(List<MenuItem> menuItemList, boolean inventoryItemOnly) {
        super(POSUtil.getFocusedWindow(), "");
        this.menuItemList = menuItemList;
        this.inventoryItemOnly = inventoryItemOnly;
        this.initComponents();
    }

    public MenuItemSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle("Select menu item");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Menu Item");
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle("Select one or more menu item");
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.menuSelectorPanel = new MenuItemSelectionView(this.menuItemList, this.inventoryItemOnly, this);
        contentPane.add((Component)this.menuSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton("SELECT");
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton btnEdit = new PosButton();
        PosButton btnAdd = new PosButton();
        btnAdd.setText(POSConstants.ADD.toUpperCase());
        btnEdit.setText(POSConstants.EDIT.toUpperCase());
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuItem menuMenuItem = new MenuItem();
                    MenuItemForm editor = new MenuItemForm(menuMenuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(1000, 700);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuItem menuItemItem = (MenuItem)editor.getBean();
                    MenuItemSelectionDialog.this.menuSelectorPanel.getModel().addItem(menuItemItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (selectionMode == 0) {
            this.titelpanel.setTitle("SELECT A MENU ITEM");
        } else {
            this.titelpanel.setTitle("Select one or more menu item");
        }
        this.menuSelectorPanel.setSelectionMode(selectionMode);
    }

    public void setSelectedGroup(MenuGroup group) {
        this.menuSelectorPanel.setSelectedGroup(group);
    }

    private void doOk() {
        if (this.selectionMode == 0) {
            MenuItem menuItem = this.getSelectedRowData();
            if (menuItem == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu Item");
                return;
            }
        } else {
            List<MenuItem> menuMenuItems = this.menuSelectorPanel.getSelectedMenuItemList();
            if (menuMenuItems == null || menuMenuItems.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu Item");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.menuSelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuItem menuItem = (MenuItem)this.menuSelectorPanel.getModel().getRowData(index);
            MenuItemDAO.getInstance().initialize(menuItem);
            this.menuSelectorPanel.getModel().addItem(menuItem);
            BeanEditor editor = null;
            editor = menuItem.isPizzaType() != false ? new PizzaItemForm(menuItem) : new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), editor);
            dialog.openWithScale(1000, 700);
            if (dialog.isCanceled()) {
                return;
            }
            this.menuSelectorPanel.repaintTable();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuItem> getSelectedItems() {
        return this.menuSelectorPanel.getSelectedMenuItemList();
    }

    public MenuItem getSelectedRowData() {
        int index = this.menuSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return (MenuItem)this.menuSelectorPanel.getModel().getRowData(index);
    }

    public static MenuItemSelectionDialog getInstance() {
        if (instance == null) {
            instance = new MenuItemSelectionDialog();
        }
        return instance;
    }

    public void doSearch(String searchText) {
        this.menuSelectorPanel.searchItem(searchText);
    }

    public void setShowVariantParent(boolean isShowVarParent) {
        this.menuSelectorPanel.setShowVariantParent(isShowVarParent);
    }
}

