/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultiCurrencyAmountSelectionDialog
extends OkCancelOptionDialog {
    private List<Currency> currencyList;
    private double totalAmount;
    private List<CurrencyRow> currencyRows = new ArrayList<CurrencyRow>();
    private CashDrawer cashDrawer;
    private boolean reconcile;
    private String initialAmount;

    public MultiCurrencyAmountSelectionDialog(CashDrawer cashDrawer, double initialAmount, List<Currency> currencyList) {
        super(POSUtil.getFocusedWindow());
        this.currencyList = currencyList;
        this.cashDrawer = cashDrawer;
        this.initialAmount = "" + initialAmount;
        this.init();
        this.setDefaultCloseOperation(2);
    }

    public void setReconcile(boolean reconcile) {
        this.reconcile = reconcile;
    }

    private void init() {
        JPanel contentPane = this.getContentPanel();
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setTitle(Messages.getString("MultiCurrencyAssignDrawerDialog.0"));
        this.setCaption(Messages.getString("MultiCurrencyAssignDrawerDialog.1"));
        contentPane.setLayout(new BorderLayout(5, 5));
        JPanel inputPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 2, 10, 5);
        inputPanel.setLayout(gridLayout);
        JLabel lblCurrency = this.getJLabel(Messages.getString("MultiCurrencyAssignDrawerDialog.2"), 1, 16, 0);
        JLabel lblAmount = this.getJLabel(Messages.getString("MultiCurrencyAssignDrawerDialog.3"), 1, 16, 0);
        inputPanel.add(lblCurrency);
        inputPanel.add(lblAmount);
        for (Currency currency : this.currencyList) {
            JLabel currencyName = this.getJLabel(currency.getName(), 0, 16, 0);
            DoubleTextField tfTenderedAmount = currency.isMain() != false ? this.getDoubleTextField(this.initialAmount, 0, 16, 4) : this.getDoubleTextField("", 0, 16, 4);
            inputPanel.add(currencyName);
            inputPanel.add(tfTenderedAmount);
            CurrencyRow item = new CurrencyRow(currency, tfTenderedAmount);
            this.currencyRows.add(item);
        }
        NumericKeypad numericKeypad = new NumericKeypad();
        JPanel container = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        container.add(inputPanel);
        JScrollPane scrollPane = new JScrollPane(container);
        contentPane.add(scrollPane);
        contentPane.add((Component)numericKeypad, "South");
    }

    private JLabel getJLabel(String text, int bold, int fontSize, int align) {
        JLabel lbl = new JLabel(text);
        lbl.setFont(lbl.getFont().deriveFont(bold, PosUIManager.getSize(fontSize)));
        lbl.setHorizontalAlignment(align);
        return lbl;
    }

    private DoubleTextField getDoubleTextField(String text, int bold, int fontSize, int align) {
        DoubleTextField tf = new DoubleTextField();
        tf.setText(text);
        tf.setFont(tf.getFont().deriveFont(bold, PosUIManager.getSize(fontSize)));
        tf.setHorizontalAlignment(align);
        tf.setBackground(Color.WHITE);
        return tf;
    }

    @Override
    public void doOk() {
        this.totalAmount = 0.0;
        for (CurrencyRow rowItem : this.currencyRows) {
            double amount;
            CashBreakdown item = this.cashDrawer.getCurrencyBalance(rowItem.currency);
            if (item == null) {
                item = new CashBreakdown();
                item.setCurrency(rowItem.currency);
                this.cashDrawer.addTocashBreakdownList(item);
            }
            if (Double.isNaN(amount = rowItem.tfAmount.getDouble())) {
                amount = 0.0;
            }
            if (!this.reconcile) {
                item.setBalance(amount);
            } else {
                item.setTotalAmount(amount);
            }
            this.totalAmount += amount / rowItem.currency.getExchangeRate();
        }
        if (this.reconcile && this.totalAmount < this.cashDrawer.getDrawerAccountable() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to save partial reconciliation?", "Confirm") != 0) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    private class CurrencyRow {
        Currency currency;
        DoubleTextField tfAmount;

        public CurrencyRow(Currency currency, DoubleTextField tfAmount) {
            this.currency = currency;
            this.tfAmount = tfAmount;
        }
    }
}

