/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OroLicenseInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.CustomerInfoEntryDialog;
import com.orocube.licensemanager.ui.PluginFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class OroLicenceActivationDialog
extends POSDialog {
    private String productName;
    private String productVersion;
    private OroLicense license;
    private POSTextField tfTerminalKey;

    public OroLicenceActivationDialog(Frame parent, String productName, String productVersion) {
        super(parent, true);
        this.productName = productName;
        this.productVersion = productVersion;
        this.init();
        this.initData();
    }

    private void initData() {
        this.tfTerminalKey.setText(TerminalUtil.getSystemUID());
    }

    private void init() {
        this.setTitle(AppProperties.getAppName() + " License Activation");
        this.setSize(600, 350);
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][]", ""));
        JLabel lblActivationMsg = new JLabel("Please activate " + AppProperties.getAppName() + " to continue");
        lblActivationMsg.setFont(new Font(lblActivationMsg.getFont().getName(), 1, 20));
        lblActivationMsg.setHorizontalAlignment(0);
        JLabel lblTerminalKey = new JLabel("Terminal key:");
        this.tfTerminalKey = new POSTextField();
        this.tfTerminalKey.setEditable(false);
        JButton btnCopy = new JButton("Copy");
        btnCopy.setPreferredSize(PosUIManager.getSize(100, 0));
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String terminalKey = OroLicenceActivationDialog.this.tfTerminalKey.getText();
                if (StringUtils.isEmpty((String)terminalKey)) {
                    return;
                }
                StringSelection selection = new StringSelection(terminalKey);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        this.add((Component)lblActivationMsg, "North");
        centerPanel.add((Component)lblTerminalKey, "align trailing");
        centerPanel.add((Component)this.tfTerminalKey, "growx");
        centerPanel.add((Component)btnCopy, "");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnReqDemoLic = new PosButton("Request Demo License");
        buttonPanel.add((Component)btnReqDemoLic, "grow");
        btnReqDemoLic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    String terminalKey = OroLicenceActivationDialog.this.tfTerminalKey.getText();
                    if (StringUtils.isEmpty((String)terminalKey)) {
                        return;
                    }
                    CustomerInfoEntryDialog dialog = new CustomerInfoEntryDialog(POSUtil.getFocusedWindow());
                    dialog.setTitle(AppProperties.getAppName());
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    String customerName = dialog.getCustomerName();
                    String customerEmail = dialog.getCustomerEmail();
                    OroLicenceActivationDialog.this.doReqDemoLicense(customerName, customerEmail, OroLicenceActivationDialog.this.productName, OroLicenceActivationDialog.this.productVersion, terminalKey);
                }
                catch (HttpHostConnectException e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Unable to connect host server. please try again later.");
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        });
        PosButton btnSelectLicense = new PosButton("Select license");
        buttonPanel.add((Component)btnSelectLicense, "grow");
        btnSelectLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroLicenceActivationDialog.this.doSelectLicense();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, "Exit")));
        this.add((Component)buttonPanel, "South");
    }

    private void doSelectLicense() {
        File licenseFile = PluginFileChooser.selectPluginFile((Component)Application.getPosWindow());
        if (licenseFile == null) {
            return;
        }
        this.doSetLicense(licenseFile);
    }

    private void doSetLicense(File licenseFile) {
        try {
            OroLicense newLicense = LicenseUtil.loadAndValidate((File)licenseFile, (String)this.productName, (String)this.productVersion, (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)licenseFile, (String)this.productName);
            this.setLicense(newLicense);
            if (this.isValidLicense()) {
                OroLicenseInfoDialog licenseInfoDialog = new OroLicenseInfoDialog(newLicense);
                licenseInfoDialog.setSize(PosUIManager.getSize(500, 500));
                licenseInfoDialog.setLocationRelativeTo(null);
                licenseInfoDialog.setVisible(true);
                this.dispose();
            } else {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "License invalid.");
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    public static OroLicense showDialog(Frame parent, String productName, String productVersion) {
        OroLicenceActivationDialog dialog = new OroLicenceActivationDialog(parent, productName, productVersion);
        dialog.open();
        if (dialog.isCanceled() && !dialog.isValidLicense()) {
            System.exit(1);
        }
        return dialog.license;
    }

    public boolean isValidLicense() {
        if (this.license != null) {
            return this.license.isValid();
        }
        return false;
    }

    public OroLicense getLicense() {
        return this.license;
    }

    public void setLicense(OroLicense license) {
        this.license = license;
    }

    protected void doReqDemoLicense(String customerName, String customerEmail, String productName, String productVersion, String posTerminalKey) throws Exception {
        String url = this.getLicenseServerURL() + "/service/lm/demoLicReq";
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
        form.add(new BasicNameValuePair("customerName", customerName));
        form.add(new BasicNameValuePair("customerEmail", customerEmail));
        form.add(new BasicNameValuePair("product", productName));
        form.add(new BasicNameValuePair("product_version", productVersion));
        form.add(new BasicNameValuePair("terminal_key", posTerminalKey));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, Consts.UTF_8);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
        if (httpResponse == null) {
            throw new Exception("Response not found!");
        }
        String getResult = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (StringUtils.isEmpty((String)getResult)) {
            throw new Exception("Error: result null or empty!");
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(getResult));
        JsonObject readObject = reader.readObject();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String errorMessage = readObject.getString("message");
            throw new Exception("Error: " + errorMessage);
        }
        String message = readObject.getString("message");
        if (StringUtils.isEmpty((String)message)) {
            throw new Exception("No message found!");
        }
        JsonValue jsonValue = (JsonValue)readObject.get((Object)"content");
        String product = readObject.getString("product");
        if (jsonValue == null) {
            throw new Exception("No content found!");
        }
        String pathName = System.getProperty("java.io.tmpdir") + File.separator;
        pathName = pathName + product + ".lic";
        File pluginFile = new File(pathName);
        byte[] decodedContent = Base64.decodeBase64((String)jsonValue.toString());
        FileUtils.writeByteArrayToFile((File)pluginFile, (byte[])decodedContent);
        this.doSetLicense(pluginFile);
        if (httpPost != null) {
            httpPost.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLicenseServerURL() {
        String url = "https://orodev.net/lm";
        FileInputStream inputStream = null;
        try {
            File file = new File("app.config");
            if (!file.exists() || !file.isFile()) {
                String string = url;
                return string;
            }
            inputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(inputStream);
            String property = properties.getProperty("license.server.url");
            if (StringUtils.isNotEmpty((String)property)) {
                String string = property;
                return string;
            }
            String string = url;
            return string;
        }
        catch (Exception e) {
            String string = url;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

