/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class POSDialog
extends JDialog {
    protected boolean canceled = true;

    public POSDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, VersionInfo.getAppName(), modal, gc);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Dialog owner, String title, boolean modal) {
        super(owner, VersionInfo.getAppName(), modal);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Dialog owner, String title) {
        super(owner, VersionInfo.getAppName());
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Dialog owner) {
        super(owner);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, VersionInfo.getAppName(), modal, gc);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Frame owner, String title, boolean modal) {
        super(owner, VersionInfo.getAppName(), modal);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Frame owner, String title) {
        super(owner, VersionInfo.getAppName(), true);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Frame owner) {
        super(owner);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Window owner, Dialog.ModalityType modalityType) {
        super(owner, modalityType);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Window owner, String title, Dialog.ModalityType modalityType, GraphicsConfiguration gc) {
        super(owner, VersionInfo.getAppName(), modalityType, gc);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Window owner, String title, Dialog.ModalityType modalityType) {
        super(owner, VersionInfo.getAppName(), modalityType);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Window owner) {
        super(owner);
        this.setIcon();
        this.initUI();
    }

    public POSDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initUI();
        this.setIcon();
    }

    public POSDialog(Window owner, String title) {
        this(owner, VersionInfo.getAppName(), true);
        this.initUI();
        this.setIcon();
    }

    public POSDialog(Window owner, String title, boolean modal) {
        super(owner, VersionInfo.getAppName(), modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.initUI();
    }

    protected void initUI() {
    }

    public void open() {
        this.canceled = true;
        if (this.isUndecorated()) {
            Window owner = this.getOwner();
            if (owner instanceof JFrame) {
                JFrame frame = (JFrame)owner;
                this.setLocationRelativeTo(frame.getContentPane());
            } else {
                this.setLocationRelativeTo(owner);
            }
        } else {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setVisible(true);
    }

    public void openFullScreen() {
        this.canceled = true;
        if (TerminalConfig.isKioskMode()) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize);
            this.setUndecorated(true);
        } else {
            this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }
        this.setResizable(true);
        this.setLocationRelativeTo(POSUtil.getFocusedWindow());
        this.setVisible(true);
    }

    public void openUndecoratedFullScreen() {
        this.openFullScreen();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    private void setIcon() {
        PosWindow posWindow = Application.getPosWindow();
        if (posWindow != null) {
            this.setIconImage(posWindow.getIconImage());
        }
    }
}

