/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.PayOutTransactionDAO;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.PayOutView;
import com.floreantpos.util.NumberUtil;
import java.awt.Dialog;
import java.awt.Frame;

public class PayoutDialog
extends OkCancelOptionDialog {
    private PayOutView payOutView;
    private User currentUser;
    private Terminal drawerTerminal;

    public PayoutDialog(Dialog parent, User user, Terminal drawerTerminal) {
        super(parent, true);
        this.currentUser = user;
        this.drawerTerminal = drawerTerminal;
        this.setTitle(Application.getTitle() + POSConstants.PAYOUT_BUTTON_TEXT);
        this.initComponents();
        this.payOutView.initialize();
    }

    public PayoutDialog(Frame parent, User user, Terminal drawerTerminal) {
        super(parent, true);
        this.currentUser = user;
        this.drawerTerminal = drawerTerminal;
        this.setTitle(Application.getTitle() + POSConstants.PAYOUT_BUTTON_TEXT);
        this.initComponents();
        this.payOutView.initialize();
    }

    private void initComponents() {
        this.setCaption(POSConstants.PAYOUT_BUTTON_TEXT);
        this.setOkButtonText(POSConstants.FINISH);
        this.payOutView = new PayOutView();
        this.setDefaultCloseOperation(2);
        this.getContentPanel().add(this.payOutView);
        this.pack();
    }

    @Override
    public void doOk() {
        double payoutAmount = this.payOutView.getPayoutAmount();
        PayoutReason reason = this.payOutView.getReason();
        PayoutRecepient recepient = this.payOutView.getRecepient();
        String note = this.payOutView.getNote();
        try {
            PayOutTransactionDAO.getInstance().createPayoutTransaction(reason, recepient, note, payoutAmount, this.currentUser, this.drawerTerminal);
            String actionMessage = "";
            actionMessage = actionMessage + Messages.getString("PayoutDialog.2") + ":" + NumberUtil.formatNumber(payoutAmount);
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.PAY_OUT, actionMessage);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

