/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PinNumberInputDialog
extends POSDialog {
    private POSTextField tfPinNumber;
    private String hashCode;
    private String pinNumber;
    private TitlePanel titlePanel;
    private String email;

    public PinNumberInputDialog(String hashCode, String email) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.hashCode = hashCode;
        this.email = email;
        this.setTitle(VersionInfo.getAppName());
        this.setSize(PosUIManager.getSize(500, 220));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle("Enter pin number");
        JLabel lblEnterText = new JLabel("Please enter pin number for email \"" + this.email + "\"");
        this.tfPinNumber = new POSTextField(20);
        this.tfPinNumber.addActionListener(e -> this.doOk());
        JPanel centerLayout = new JPanel((LayoutManager)new MigLayout("center"));
        centerLayout.add((Component)lblEnterText, "grow, center, wrap");
        centerLayout.add((Component)this.tfPinNumber, "center, grow");
        PosButton btnDone = new PosButton("Ok");
        PosButton btnCancel = new PosButton("Cancel");
        btnDone.addActionListener(e -> this.doOk());
        btnCancel.addActionListener(e -> {
            this.setCanceled(true);
            this.dispose();
        });
        JPanel bottomLayout = new JPanel((LayoutManager)new MigLayout("center"));
        bottomLayout.add(btnDone);
        bottomLayout.add(btnCancel);
        this.add((Component)this.titlePanel, "North");
        this.add(centerLayout);
        this.add((Component)bottomLayout, "South");
    }

    private void doOk() {
        this.pinNumber = this.tfPinNumber.getText().trim();
        if (StringUtils.isEmpty((String)this.pinNumber)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter pin number!");
            return;
        }
        if (!this.pinNumber.equals(this.hashCode)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Invalid number! Please enter valid pin number!");
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public String getPinNumber() {
        return this.pinNumber;
    }

    public void setCaption(String caption) {
        this.titlePanel.setTitle(caption);
    }

    public static void main(String[] args) {
        PinNumberInputDialog dialog = new PinNumberInputDialog("aaa", "bbb");
        dialog.open();
    }
}

