/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ReorderDialog
extends POSDialog {
    private Ticket ticket;
    private List<TicketItem> ticketItems;
    private TicketViewerTable reorderedItemsTable;

    public ReorderDialog(Ticket ticket) {
        this.ticket = ticket;
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Reorder Items");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[grow][][grow][]", ""));
        JPanel leftTicketPanel = new JPanel(new BorderLayout());
        JLabel lblTitle1 = new JLabel("Ticket");
        lblTitle1.setForeground(Color.BLUE);
        TitledSeparator sep1 = new TitledSeparator((JComponent)lblTitle1, 0);
        JLabel lblTitle2 = new JLabel("Reordered Items");
        lblTitle2.setForeground(Color.BLUE);
        TitledSeparator sep2 = new TitledSeparator((JComponent)lblTitle2, 0);
        JPanel centerSelectPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSelect = new PosButton();
        btnSelect.setToolTipText("Send single item");
        btnSelect.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        PosButton btnSendAll = new PosButton();
        btnSendAll.setToolTipText("Send all");
        btnSendAll.setIcon(IconFactory.getIcon("/ui_icons/", "triple_arrow.png"));
        PosButton btnLastOrder = new PosButton();
        btnLastOrder.setToolTipText("Send last order");
        btnLastOrder.setIcon(IconFactory.getIcon("/ui_icons/", "double_arrow.png"));
        centerSelectPanel.add((Component)btnSelect, "center, wrap");
        centerSelectPanel.add((Component)btnLastOrder, "center, wrap");
        centerSelectPanel.add((Component)btnSendAll, "center, wrap");
        JPanel rightSelectedItemPanel = new JPanel(new BorderLayout());
        JPanel rightControlPanel = new JPanel((LayoutManager)new MigLayout());
        PosButton btnAdd = new PosButton();
        PosButton btnSub = new PosButton();
        PosButton btnRemove = new PosButton();
        PosButton btnRemoveAll = new PosButton();
        btnAdd.setToolTipText("Increase item number");
        btnSub.setToolTipText("Decrease item number");
        btnRemove.setToolTipText("Remove item");
        btnRemoveAll.setToolTipText("Remove all");
        btnAdd.setIcon(IconFactory.getIcon("/ui_icons/", "add.png"));
        btnSub.setIcon(IconFactory.getIcon("/ui_icons/", "remove.png"));
        btnRemove.setIcon(IconFactory.getIcon("/ui_icons/", "clear.png"));
        btnRemoveAll.setIcon(IconFactory.getIcon("/ui_icons/", "remove_all.png"));
        int height = 50;
        btnAdd.setPreferredSize(PosUIManager.getSize(0, height));
        btnSub.setPreferredSize(PosUIManager.getSize(0, height));
        btnRemove.setPreferredSize(PosUIManager.getSize(0, height));
        rightControlPanel.add((Component)btnAdd, "growx, wrap");
        rightControlPanel.add((Component)btnSub, "growx, wrap");
        rightControlPanel.add((Component)btnRemove, "growx, wrap");
        rightControlPanel.add((Component)btnRemoveAll, "growx, wrap");
        final TicketViewerTable ticketViewerTable = new TicketViewerTable(this.ticket);
        ticketViewerTable.setRowHeight(PosUIManager.getSize(45));
        this.resizeColumnWidth(ticketViewerTable);
        ticketViewerTable.setSelectionMode(0);
        PosScrollPane scrollPane = new PosScrollPane(ticketViewerTable, 20, 31);
        Ticket newTicket = new Ticket(true);
        this.reorderedItemsTable = new TicketViewerTable(newTicket);
        this.reorderedItemsTable.setRowHeight(PosUIManager.getSize(45));
        this.resizeColumnWidth(this.reorderedItemsTable);
        this.reorderedItemsTable.setSelectionMode(0);
        PosScrollPane rightScrollPane = new PosScrollPane(this.reorderedItemsTable, 20, 31);
        leftTicketPanel.add((Component)sep1, "North");
        leftTicketPanel.add((Component)scrollPane, "Center");
        rightSelectedItemPanel.add((Component)sep2, "North");
        rightSelectedItemPanel.add((Component)rightScrollPane, "Center");
        centerPanel.add((Component)leftTicketPanel, "grow");
        centerPanel.add((Component)centerSelectPanel, "");
        centerPanel.add((Component)rightSelectedItemPanel, "grow");
        centerPanel.add((Component)rightControlPanel, "");
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doAddReOrderTicketItem(ticketViewerTable);
                ticketViewerTable.clearSelection();
            }
        });
        btnSendAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doSendAllItems(ticketViewerTable);
                ticketViewerTable.clearSelection();
            }
        });
        btnLastOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doAddLastOrder(ticketViewerTable);
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doAddReorderTicketItems();
            }
        });
        btnSub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doSubstractReorderTicketItems();
            }
        });
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doRemoveReorderTicketItems();
            }
        });
        btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doRemoveAll();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center, insets 10 10 10 80", "sg, fill", ""));
        PosButton btnDone = new PosButton("DONE");
        buttonPanel.add((Component)btnDone, "grow");
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderDialog.this.doReorder();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardDeActiveView.11"))));
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(PosUIManager.getSize(250));
        columnWidth.add(PosUIManager.getSize(30));
        columnWidth.add(PosUIManager.getSize(30));
        return columnWidth;
    }

    public void doReorder() {
        List<TicketItem> ticketItems = this.reorderedItemsTable.getTicketItems();
        if (ticketItems == null) {
            return;
        }
        this.setTicketItems(ticketItems);
        this.setCanceled(false);
        this.dispose();
    }

    private void doAddLastOrder(TicketViewerTable ticketViewerTable) {
        KitchenTicket lastKitchenTicket = KitchenTicketDAO.getInstance().findByLastOrderParentId(this.ticket.getId());
        List<KitchenTicketItem> kitchenTicketItems = lastKitchenTicket.getTicketItems();
        for (KitchenTicketItem kitchenTicketItem : kitchenTicketItems) {
            List<TicketItem> ticketItems = ticketViewerTable.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                if (!ticketItem.getId().equals(kitchenTicketItem.getTicketItemId())) continue;
                TicketItem newTicketItem = ticketItem.cloneAsNew();
                newTicketItem.calculatePrice();
                this.reorderedItemsTable.addTicketItem(newTicketItem);
            }
        }
        this.reorderedItemsTable.repaint();
    }

    private void doAddReOrderTicketItem(TicketViewerTable ticketViewerTable) {
        try {
            int index = ticketViewerTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = ticketViewerTable.convertRowIndexToModel(index);
            TicketViewerTableModel ticketViewerTableModel = ticketViewerTable.getModel();
            Object selectedItem = ticketViewerTableModel.get(index);
            if (selectedItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)selectedItem;
                TicketItem newTicketItem = ticketItem.cloneAsNew();
                newTicketItem.calculatePrice();
                this.reorderedItemsTable.addTicketItem(newTicketItem);
                this.reorderedItemsTable.repaint();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void doSendAllItems(TicketViewerTable ticketViewerTable) {
        try {
            List<TicketItem> ticketItems = ticketViewerTable.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                TicketItem newTicketItem = ticketItem.cloneAsNew();
                newTicketItem.calculatePrice();
                this.reorderedItemsTable.addTicketItem(newTicketItem);
            }
            this.reorderedItemsTable.repaint();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public List<TicketItem> getTicketItems() {
        return this.ticketItems;
    }

    public void setTicketItems(List<TicketItem> ticketItems) {
        this.ticketItems = ticketItems;
    }

    private void doAddReorderTicketItems() {
        int index = this.reorderedItemsTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.reorderedItemsTable.convertRowIndexToModel(index);
        TicketViewerTableModel reorderedTicketItemsTableModel = this.reorderedItemsTable.getModel();
        Object selectedItem = reorderedTicketItemsTableModel.get(index);
        if (selectedItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)selectedItem;
            ticketItem.setQuantity(ticketItem.getQuantity() + 1.0);
            ticketItem.calculatePrice();
            reorderedTicketItemsTableModel.update();
            this.reorderedItemsTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private void doSubstractReorderTicketItems() {
        int index = this.reorderedItemsTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.reorderedItemsTable.convertRowIndexToModel(index);
        TicketViewerTableModel reorderedTicketItemsTableModel = this.reorderedItemsTable.getModel();
        Object selectedItem = reorderedTicketItemsTableModel.get(index);
        if (selectedItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)selectedItem;
            if (ticketItem.getQuantity() == 1.0) {
                reorderedTicketItemsTableModel.delete(index);
            } else {
                ticketItem.setQuantity(ticketItem.getQuantity() - 1.0);
                ticketItem.calculatePrice();
                reorderedTicketItemsTableModel.update();
                this.reorderedItemsTable.getSelectionModel().setSelectionInterval(index, index);
            }
        }
    }

    private void doRemoveReorderTicketItems() {
        int index = this.reorderedItemsTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.reorderedItemsTable.convertRowIndexToModel(index);
        TicketViewerTableModel reorderedTicketItemsTableModel = this.reorderedItemsTable.getModel();
        Object selectedItem = reorderedTicketItemsTableModel.get(index);
        if (selectedItem instanceof TicketItem) {
            reorderedTicketItemsTableModel.delete(index);
        }
    }

    private void doRemoveAll() {
        this.reorderedItemsTable.getModel().removeAll();
        this.reorderedItemsTable.repaint();
    }
}

