/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class SalesAreaSelectionDialog
extends POSDialog {
    private ScrollableFlowPanel buttonsPanel;
    private SalesArea addedSalesArea;

    public SalesAreaSelectionDialog() {
        this.initializeComponent();
        this.rendererSalesAreas();
        this.setResizable(true);
    }

    private void initializeComponent() {
        this.setTitle("Select sales area");
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Select sales area");
        this.add((Component)titlePanel, "North");
        JPanel buttonActionPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SalesAreaSelectionDialog.this.setCanceled(true);
                SalesAreaSelectionDialog.this.dispose();
            }
        });
        buttonActionPanel.add((Component)btnCancel, "w 120!,center");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        footerPanel.add((Component)new JSeparator(), "North");
        footerPanel.add(buttonActionPanel);
        this.add((Component)footerPanel, "South");
        this.buttonsPanel = new ScrollableFlowPanel(3);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        this.add((Component)scrollPane, "Center");
        this.setSize(800, 600);
    }

    private void rendererSalesAreas() {
        try {
            this.buttonsPanel.getContentPane().removeAll();
            Terminal terminal = Application.getInstance().getTerminal();
            Department dept = terminal.getDepartment();
            SalesArea salesArea = terminal.getSalesArea();
            if (dept != null) {
                List<SalesArea> salesAreas = SalesAreaDAO.getInstance().findSalesAreaByDept(dept);
                this.setSalesAreaButtonPanel(salesArea, salesAreas);
            } else if (dept == null) {
                List<SalesArea> salesAreas = SalesAreaDAO.getInstance().findAll();
                this.setSalesAreaButtonPanel(salesArea, salesAreas);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    private void setSalesAreaButtonPanel(SalesArea salesArea, List<SalesArea> salesAreas) {
        ButtonGroup group = new ButtonGroup();
        for (SalesArea sArea : salesAreas) {
            SalesAreaButton salesAreaButton = new SalesAreaButton(sArea);
            if (salesArea != null && salesArea.equals(sArea)) {
                salesAreaButton.setFocusable(true);
                salesAreaButton.setFocusPainted(true);
            }
            this.buttonsPanel.add(salesAreaButton);
            group.add(salesAreaButton);
        }
        this.buttonsPanel.repaint();
        this.buttonsPanel.revalidate();
    }

    public SalesArea getSelectedSalesArea() {
        return this.addedSalesArea;
    }

    private class SalesAreaButton
    extends POSToggleButton
    implements ActionListener {
        private static final int BUTTON_SIZE = 119;
        SalesArea salesArea;

        SalesAreaButton(SalesArea salesArea) {
            this.salesArea = salesArea;
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setText("<html><body><center>" + salesArea.getName() + "</center></body></html>");
            this.setPreferredSize(new Dimension(119, TerminalConfig.getMenuItemButtonHeight()));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SalesAreaSelectionDialog.this.addedSalesArea = this.salesArea;
            SalesAreaSelectionDialog.this.setCanceled(false);
            SalesAreaSelectionDialog.this.dispose();
        }
    }
}

