/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class SendToKitchenOptionSelectionDialog
extends POSDialog {
    Ticket ticket;
    private PosButton btnSendNewItem;
    private PosButton btnSendAll;
    private RefreshableView refreshableView;

    public SendToKitchenOptionSelectionDialog(Ticket ticket) {
        this(ticket, null);
    }

    public SendToKitchenOptionSelectionDialog(Ticket ticket, RefreshableView refreshableView) throws HeadlessException {
        this.ticket = ticket;
        this.refreshableView = refreshableView;
        this.initializeComponent();
    }

    private void initializeComponent() {
        this.setTitle("Select option");
        this.setResizable(false);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Send ticket to kitchen");
        this.add((Component)titlePanel, "North");
        JPanel splitTypePanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 1,inset 10", "sg", ""));
        Font f = new Font("Verdana", 1, PosUIManager.getFontSize(20));
        int width = PosUIManager.getSize(300);
        int height = PosUIManager.getSize(70);
        this.btnSendNewItem = new PosButton("SEND NEW ITEMS");
        this.btnSendNewItem.setFont(f);
        this.btnSendNewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SendToKitchenOptionSelectionDialog.this.setCanceled(false);
                    SendToKitchenOptionSelectionDialog.this.dispose();
                    SendToKitchenOptionSelectionDialog.this.doSendNewItemsToKitchen();
                    POSMessageDialog.showMessage("Items send to kitchen.");
                }
                catch (StaleStateException x) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), SendToKitchenOptionSelectionDialog.this.refreshableView);
                }
            }
        });
        splitTypePanel.add((Component)this.btnSendNewItem, "w " + width + "!,h " + height + "!,grow");
        this.btnSendAll = new PosButton("SEND ALL");
        this.btnSendAll.setFont(f);
        this.btnSendAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SendToKitchenOptionSelectionDialog.this.setCanceled(false);
                    SendToKitchenOptionSelectionDialog.this.dispose();
                    SendToKitchenOptionSelectionDialog.this.doSendAllItemsToKitchen();
                    POSMessageDialog.showMessage("Items send to kitchen.");
                }
                catch (StaleStateException x) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), SendToKitchenOptionSelectionDialog.this.refreshableView);
                }
            }
        });
        splitTypePanel.add((Component)this.btnSendAll, "w " + width + "!,h " + height + "!,grow");
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendToKitchenOptionSelectionDialog.this.setCanceled(true);
                SendToKitchenOptionSelectionDialog.this.dispose();
            }
        });
        JPanel actionPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        actionPanel.add((Component)btnCancel, "w " + width + "!,h " + height + "!,grow");
        this.add((Component)splitTypePanel, "Center");
        this.add((Component)actionPanel, "South");
    }

    private void doSendNewItemsToKitchen() {
        OrderController.saveOrder(this.ticket);
        if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && this.ticket.needsKitchenPrint()) {
            ReceiptPrintService.printToKitchen(this.ticket, true);
        }
    }

    private void doSendAllItemsToKitchen() {
        OrderController.saveOrder(this.ticket);
        if (this.ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            ReceiptPrintService.printToKitchen(this.ticket, false);
        }
    }
}

