/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class ServerOpenTicketListDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JXTable tableTicket;
    private TicketTableModel tableModel;
    private List<Ticket> ticketList;
    private DefaultListSelectionModel selectionModel;
    private User currentUser;
    private User serverUser;
    private PosButton btnCancel;
    private boolean filterByUser;

    public ServerOpenTicketListDialog(User currentUser, User user, boolean filterByUser) {
        super((Frame)Application.getPosWindow(), true);
        this.currentUser = currentUser;
        this.serverUser = user;
        this.filterByUser = filterByUser;
        this.initComponents();
        this.initData();
        this.updateView();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(POSConstants.OPEN_TICKETS);
        this.titlePanel.setTitle(title);
    }

    private void initComponents() {
        TransparentPanel container = new TransparentPanel();
        this.titlePanel = new TitlePanel();
        TransparentPanel contentPanel = new TransparentPanel();
        TransparentPanel bottomActionPanel = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator1 = new JSeparator();
        this.btnCancel = new PosButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.tableTicket = new JXTable();
        this.tableTicket.setRowHeight(PosUIManager.getSize(30));
        this.tableTicket.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jSeparator1, "North");
        PosButton btnTransferAll = new PosButton(POSConstants.TRANSFER_ALL);
        btnTransferAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.doTransferTickets();
            }
        });
        bottomActionPanel.add(btnTransferAll);
        PosButton btnSettleAll = new PosButton(POSConstants.SETTLE_ALL);
        btnSettleAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.doGroupSettle();
            }
        });
        bottomActionPanel.add(btnSettleAll);
        PosButton btnCloseAll = new PosButton(POSConstants.CLOSE_ALL);
        btnCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.doCloseTickets();
            }
        });
        bottomActionPanel.add(btnCloseAll);
        this.btnCancel.setText("DONE");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.btnCloseActionPerformed(evt);
            }
        });
        bottomActionPanel.add(this.btnCancel);
        container.add((Component)bottomActionPanel, "Center");
        this.getContentPane().add((Component)container, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.titlePanel, "North");
        jScrollPane1.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 10, 5, 10), jScrollPane1.getBorder()));
        jScrollPane1.setViewportView((Component)this.tableTicket);
        contentPanel.add((Component)jScrollPane1, "Center");
        JPanel cashSummaryPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0"));
        contentPanel.add((Component)cashSummaryPanel, "South");
        this.getContentPane().add((Component)contentPanel, "Center");
    }

    public void initData() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.tableTicket.getSelectionModel().setSelectionMode(0);
        this.tableTicket.setDefaultRenderer(Object.class, (TableCellRenderer)new TableRenderer());
        this.tableModel = new TicketTableModel();
        this.tableTicket.setModel((TableModel)this.tableModel);
        AbstractAction transferAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(row);
                ServerOpenTicketListDialog.this.doTransferTicket(ticket);
                ServerOpenTicketListDialog.this.updateView();
            }
        };
        AbstractAction settleAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(row);
                new SettleTicketAction(ticket, ServerOpenTicketListDialog.this.currentUser).actionPerformed(e);
                ServerOpenTicketListDialog.this.updateView();
            }
        };
        AbstractAction closeTicketAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(row);
                ServerOpenTicketListDialog.this.doCloseTicket(ticket);
                ServerOpenTicketListDialog.this.updateView();
            }
        };
        this.addButtonColumnAction(transferAction, 5);
        this.addButtonColumnAction(settleAction, 6);
        this.addButtonColumnAction(closeTicketAction, 7);
        this.resizeTableColumns();
        TableColumnModelExt columnModel = (TableColumnModelExt)this.tableTicket.getColumnModel();
        columnModel.getColumnExt(2).setVisible(!this.filterByUser);
    }

    private void addButtonColumnAction(AbstractAction action, int columnNum) {
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.tableTicket, action, columnNum){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.tableTicket.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.tableTicket.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnCancel.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnCancel.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
    }

    private void doTransferTicket(Ticket ticket) {
        try {
            TicketTransferAction transferAction = new TicketTransferAction(ticket, this.currentUser);
            transferAction.execute();
            if (!transferAction.isTransfered()) {
                return;
            }
            this.updateView();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(Messages.getString("UserTransferDialog.4"));
            PosLog.error(this.getClass(), e1);
        }
    }

    protected void doCloseTicket(Ticket ticket) {
        int option;
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0 && (option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("ServerOpenTicketListDialog.0"), POSConstants.CONFIRM)) != 0) {
            return;
        }
        option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (option != 0) {
            return;
        }
        TicketDAO.closeOrders(ticket);
    }

    private void doTransferTickets() {
        List tickets = this.tableModel.getRows();
        if (tickets == null || tickets.isEmpty()) {
            return;
        }
        UserListDialog dialog = new UserListDialog();
        dialog.setTitle(Messages.getString("UserTransferDialog.0"));
        dialog.setCaption(Messages.getString("UserTransferDialog.1"));
        dialog.setSize(PosUIManager.getSize(400, 600));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        User selectedUser = dialog.getSelectedUser();
        if (selectedUser == null) {
            return;
        }
        try {
            for (Ticket ticket : tickets) {
                this.doTransferTicket(ticket, selectedUser);
            }
            POSMessageDialog.showMessage(Messages.getString("ServerOpenTicketListDialog.1"));
            this.updateView();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    protected void doTransferTicket(Ticket ticket, User selectedUser) {
        ticket.setOwner(selectedUser);
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    private void doCloseTickets() {
        List tickets = this.tableModel.getRows();
        if (tickets == null || tickets.isEmpty()) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("ServerOpenTicketListDialog.2"), POSConstants.CONFIRM);
        try {
            if (option == 0) {
                TicketDAO.closeOrders(tickets.toArray(new Ticket[tickets.size()]));
            }
            this.updateView();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doGroupSettle() {
        List ticketList = this.tableModel.getRows();
        if (ticketList == null || ticketList.isEmpty()) {
            return;
        }
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (Ticket ticket : ticketList) {
            if (ticket.getOrderType().isBarTab().booleanValue()) continue;
            tickets.add(ticket);
        }
        GroupSettleTicketAction action = new GroupSettleTicketAction(tickets, this.currentUser);
        action.actionPerformed(null);
        this.updateView();
    }

    private void updateView() {
        this.ticketList = this.filterByUser ? TicketDAO.getInstance().findOpenTicketsForUser(this.serverUser) : TicketDAO.getInstance().findOpenTickets();
        if (this.ticketList != null) {
            for (Ticket ticket : this.ticketList) {
                TicketDAO.getInstance().loadFullTicket(ticket);
            }
        }
        this.tableModel.setItems(this.ticketList);
        this.tableModel.fireTableDataChanged();
    }

    private void resizeTableColumns() {
        this.tableTicket.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(1, PosUIManager.getSize(150));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.tableTicket.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public void setInfo(String info) {
        this.titlePanel.setTitle(info);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setCanceled(false);
        this.dispose();
    }

    public boolean hasOpenTickets() {
        return this.tableModel.getRowCount() > 0;
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                label.setHorizontalAlignment(4);
            }
            if (value instanceof Double) {
                label.setHorizontalAlignment(4);
            } else if (column == 1) {
                label.setHorizontalAlignment(2);
            } else {
                label.setHorizontalAlignment(0);
            }
            return label;
        }
    }

    class TicketTableModel
    extends ListTableModel<Ticket> {
        public TicketTableModel() {
            super(new String[]{POSConstants.TOKEN.toUpperCase(), POSConstants.ORDER_TYPE.toUpperCase(), POSConstants.SERVER.toUpperCase(), POSConstants.TOTAL.toUpperCase(), POSConstants.DUE.toUpperCase(), "", "", ""});
        }

        public void setItems(List<Ticket> ticketList) {
            this.setRows(ticketList);
        }

        @Override
        public int getRowCount() {
            if (ServerOpenTicketListDialog.this.ticketList == null) {
                return 0;
            }
            int size = ServerOpenTicketListDialog.this.ticketList.size();
            return size;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5 || columnIndex == 6 || columnIndex == 7;
        }

        public Ticket getSelectedRow() {
            int index = ServerOpenTicketListDialog.this.tableTicket.getSelectedRow();
            if (index < 0) {
                return null;
            }
            index = ServerOpenTicketListDialog.this.tableTicket.convertRowIndexToModel(index);
            return (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (ServerOpenTicketListDialog.this.ticketList == null) {
                return "";
            }
            Ticket t = (Ticket)ServerOpenTicketListDialog.this.ticketList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return t.getTokenNo();
                }
                case 1: {
                    return t.getOrderType();
                }
                case 2: {
                    return t.getOwner();
                }
                case 3: {
                    return t.getTotalAmountWithTips();
                }
                case 4: {
                    return t.getDueAmount();
                }
                case 5: {
                    return POSConstants.TRANSFER;
                }
                case 6: {
                    return POSConstants.SETTLE;
                }
                case 7: {
                    return POSConstants.CLOSE.toUpperCase();
                }
            }
            return "";
        }
    }
}

