/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ServerSummaryReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class ServerSummaryReportDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private User currentUser;
    private CashDrawer serverSummaryReport;
    private StoreSession storeSession;
    private PosButton btnServerSummaryDetails;
    private JPanel buttonPanel;
    private PosButton btnFinish;
    private PosButton btnPrint;
    private JComboBox userCombo;
    private JPanel serverTopActionPanel;
    private JPanel reportViewPanel;
    private JasperPrint serverSummaryDetailjasperPrint;
    private JasperPrint serverSummaryjasperPrint;

    public ServerSummaryReportDialog(User currentUser, StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.currentUser = currentUser;
        this.storeSession = storeSession;
        this.initComponents();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.reportViewPanel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.btnPrint = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.btnFinish = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        this.btnServerSummaryDetails = new PosButton(POSConstants.DETAILS.toUpperCase());
        this.buttonPanel.add((Component)this.btnPrint, "grow");
        this.buttonPanel.add((Component)this.btnServerSummaryDetails, "grow");
        this.buttonPanel.add((Component)this.btnFinish, "grow");
        this.serverTopActionPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,center,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.serverTopActionPanel.setVisible(false);
        List<User> users = UserDAO.getInstance().findAll();
        JLabel userLabel = new JLabel(POSConstants.SELECT_USER + " :");
        this.userCombo = new JComboBox(new ListComboBoxModel(users));
        this.userCombo.setSelectedItem(this.currentUser);
        this.userCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ea) {
                try {
                    ServerSummaryReportDialog.this.currentUser = (User)ServerSummaryReportDialog.this.userCombo.getSelectedItem();
                    ServerSummaryReportDialog.this.refreshServerSummeryReport();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        });
        if (this.currentUser.isAdministrator() || this.currentUser.isManager()) {
            this.serverTopActionPanel.setVisible(true);
        }
        this.serverTopActionPanel.add((Component)userLabel, "right");
        this.serverTopActionPanel.add((Component)this.userCombo, "w 170!");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0"));
        centerPanel.add((Component)this.serverTopActionPanel, "grow,wrap");
        centerPanel.add((Component)new PosScrollPane(this.reportViewPanel), "grow");
        this.add((Component)this.titlePanel, "North");
        this.add(centerPanel);
        this.add((Component)this.buttonPanel, "South");
        this.btnServerSummaryDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSummaryReportDialog.this.doShowServerDetailsReport();
            }
        });
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSummaryReportDialog.this.doCloseDialog();
            }
        });
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSummaryReportDialog.this.doPrintReport();
            }
        });
    }

    private void doShowServerDetailsReport() {
        try {
            this.buildServerDetailTransationReport();
            DetailReportDialog dialog = new DetailReportDialog(this.serverSummaryDetailjasperPrint);
            dialog.setTitle("Server Detail Report");
            dialog.updateView();
            dialog.open();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void buildServerDetailTransationReport() throws JRException {
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForServer(this.storeSession.getId(), this.currentUser.getId());
        allTransactionsList.addAll(transactions);
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = Application.getInstance().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", "Server Detail Report");
        if (this.currentUser != null) {
            String userInfo = this.currentUser.getFullName();
            map.put("serverName", "Staff : " + userInfo);
        }
        Date storeCloseTime = this.storeSession != null ? this.storeSession.getCloseTime() : new Date();
        String strDate = "<b>From:</b> " + DateUtil.formatFullDateAndTimeAsString(this.storeSession.getOpenTime()) + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(storeCloseTime != null ? storeCloseTime : new Date());
        map.put("startDate", strDate);
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? "No transaction found." : null);
        JasperReport masterReport = ReportUtil.getReport("server_details_report");
        this.serverSummaryDetailjasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
    }

    private void doCloseDialog() {
        this.dispose();
    }

    private void doPrintReport() {
        try {
            PosPrintService.printReportByJasperPrint(this.serverSummaryjasperPrint);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + ex.getMessage());
            PosLog.error(this.getClass(), ex);
        }
    }

    public void refreshServerSummeryReport() throws Exception {
        this.createServerSummaryReport();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(AppProperties.getAppName());
    }

    public void createServerSummaryReport() throws Exception {
        this.reportViewPanel.removeAll();
        ServerSummaryReportService reportService = new ServerSummaryReportService(this.currentUser, this.storeSession);
        this.serverSummaryReport = reportService.populateServerSummaryReport();
        this.serverSummaryjasperPrint = PosPrintService.populateServerSummaryReportParameters(this.serverSummaryReport);
        TicketReceiptView receiptView = new TicketReceiptView(this.serverSummaryjasperPrint);
        receiptView.setZoom(1.25f);
        this.reportViewPanel.add(receiptView.getReportPanel());
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }
}

