/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.StoreSessionSummaryReportService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class StoreSessionSummaryReportDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private CashDrawer reportData;
    private PosButton btnStoreSessionSummaryDetails;
    private JPanel buttonPanel;
    private PosButton btnFinish;
    private PosButton btnPrint;
    private StoreSession storeSession;
    private JPanel reportViewPanel;
    private JasperPrint storeSessionSummaryDetailJasperPrint;
    private JasperPrint jasperPrint;

    public StoreSessionSummaryReportDialog(StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.storeSession = storeSession;
        this.initComponents();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.add((Component)this.titlePanel, "North");
        this.reportViewPanel = new JPanel(new BorderLayout());
        this.add(new PosScrollPane(this.reportViewPanel));
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.btnPrint = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.btnFinish = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        this.btnStoreSessionSummaryDetails = new PosButton(POSConstants.DETAILS.toUpperCase());
        this.buttonPanel.add((Component)this.btnPrint, "grow");
        this.buttonPanel.add((Component)this.btnStoreSessionSummaryDetails, "grow");
        this.buttonPanel.add((Component)this.btnFinish, "grow");
        this.add((Component)this.buttonPanel, "South");
        this.btnStoreSessionSummaryDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionSummaryReportDialog.this.doShowStoreSessionSummaryDetailsReport();
            }
        });
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionSummaryReportDialog.this.doCloseDialog();
            }
        });
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionSummaryReportDialog.this.doPrintReport();
            }
        });
    }

    private void doShowStoreSessionSummaryDetailsReport() {
        try {
            this.buildStoreSessionDetailsTransationReport();
            DetailReportDialog dialog = new DetailReportDialog(this.storeSessionSummaryDetailJasperPrint);
            dialog.setTitle("Store Session Detail Report");
            dialog.updateView();
            dialog.open();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void buildStoreSessionDetailsTransationReport() throws JRException {
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        if (this.reportData == null) {
            return;
        }
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForSession(this.storeSession.getId());
        allTransactionsList.addAll(transactions);
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = Application.getInstance().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", "Store Session Detail Report");
        Date storeCloseTime = this.storeSession != null ? this.storeSession.getCloseTime() : new Date();
        String strDate = "<b>From:</b> " + DateUtil.formatFullDateAndTimeAsString(this.reportData.getStartTime()) + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(storeCloseTime != null ? storeCloseTime : new Date());
        map.put("startDate", strDate);
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? "No transaction found." : null);
        JasperReport masterReport = ReportUtil.getReport("server_details_report");
        this.storeSessionSummaryDetailJasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
    }

    private void doCloseDialog() {
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(AppProperties.getAppName());
    }

    private void doPrintReport() {
        try {
            PosPrintService.printReportByJasperPrint(this.jasperPrint);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + ex.getMessage());
            PosLog.error(this.getClass(), ex);
        }
    }

    public void refreshReport() throws Exception {
        this.reportViewPanel.removeAll();
        StoreSessionSummaryReportService reportService = new StoreSessionSummaryReportService(this.storeSession);
        this.reportData = reportService.populateStoreSessionSummaryReport();
        this.jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(this.reportData);
        TicketReceiptView receiptView = new TicketReceiptView(this.jasperPrint);
        receiptView.setZoom(1.25f);
        this.reportViewPanel.add(receiptView.getReportPanel());
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }
}

