/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.DefaultCustomerListView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TransactionCompletionDialog
extends POSDialog {
    private double tenderedAmount;
    private double totalAmount;
    private double paidAmount;
    private double dueAmount;
    private double gratuityAmount;
    private double changeAmount;
    private JLabel lblTenderedAmount;
    private JLabel lblTotalAmount;
    private JLabel lblPaidAmount;
    private JLabel lblDueAmount;
    private JLabel lblChangeDue;
    private JLabel lblGratuityAmount;
    private PosTransaction completedTransaction;
    private List<PosTransaction> completedTransactions;
    private boolean isCard;
    private List<Ticket> tickets;
    private Customer customer;
    private PosButton btnEmail;
    private PosButton btnClose;
    private PosButton btnPrintStoreCopy;

    public TransactionCompletionDialog(PosTransaction transaction) {
        this.completedTransaction = transaction;
        this.isCard = this.completedTransaction.isCard();
        this.initializeComponents();
    }

    public TransactionCompletionDialog(List<PosTransaction> transaction) {
        this.completedTransactions = transaction;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setTitle(POSConstants.TRANSACTION_COMPLETED);
        this.setLayout((LayoutManager)new MigLayout("align 50% 0%, ins 20", "[]20[]", ""));
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.3") + ":", 2), "grow");
        this.lblTotalAmount = this.createLabel("0.0", 4);
        this.add((Component)this.lblTotalAmount, "span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.8") + ":", 2), "newline,grow");
        this.lblTenderedAmount = this.createLabel("0.0", 4);
        this.add((Component)this.lblTenderedAmount, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.14") + ":", 2), "newline,grow");
        this.lblPaidAmount = this.createLabel("0.0", 4);
        this.add((Component)this.lblPaidAmount, "span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.19") + ":", 2), "newline,grow");
        this.lblDueAmount = this.createLabel("0.0", 4);
        this.add((Component)this.lblDueAmount, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.25") + ":", 2), "newline,grow");
        this.lblGratuityAmount = this.createLabel("0.0", 4);
        this.add((Component)this.lblGratuityAmount, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.31") + ":", 2), "grow");
        this.lblChangeDue = this.createLabel("0.0", 4);
        this.add((Component)this.lblChangeDue, "span, grow");
        this.add((Component)new JSeparator(), "sg mygroup,newline,span,grow");
        this.btnEmail = new PosButton("EMAIL");
        this.btnEmail.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return TransactionCompletionDialog.this.completedTransaction.getTicket();
            }
        });
        this.btnClose = new PosButton(Messages.getString("TransactionCompletionDialog.37"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionCompletionDialog.this.dispose();
            }
        });
        this.btnPrintStoreCopy = new PosButton(Messages.getString("TransactionCompletionDialog.38"));
        this.btnPrintStoreCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (TransactionCompletionDialog.this.tickets != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.tickets) {
                            ReceiptPrintService.printTicket(ticket);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.completedTransaction, false);
                    }
                }
                catch (Exception ee) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.39"), ee);
                }
            }
        });
        PosButton btnPrintAllCopy = new PosButton(Messages.getString("TransactionCompletionDialog.40"));
        btnPrintAllCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (TransactionCompletionDialog.this.tickets != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.tickets) {
                            ReceiptPrintService.printTicket(ticket);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.completedTransaction, true);
                    }
                }
                catch (Exception ee) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.41"), ee);
                }
            }
        });
        JPanel p = new JPanel();
        p.add(this.btnEmail);
        if (this.isCard) {
            p.add((Component)btnPrintAllCopy, "newline,skip, h 50");
            p.add((Component)this.btnPrintStoreCopy, "skip, h 50");
            p.add((Component)this.btnClose, "skip, h 50");
        } else {
            this.btnPrintStoreCopy.setText(Messages.getString("TransactionCompletionDialog.0"));
            p.add((Component)this.btnPrintStoreCopy, "skip, h 50");
            p.add((Component)this.btnClose, "skip, h 50");
        }
        this.add((Component)p, "newline, span 2, grow, gaptop 15px");
    }

    private void doSendEmail() {
        try {
            Ticket ticket = this.completedTransaction.getTicket();
            if (ticket == null) {
                return;
            }
            String customerId = ticket.getCustomerId();
            String email = null;
            if (customerId == null) {
                int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "No customer is set for the order. Do you want to set customer?", "Customer selection");
                if (option != 0) {
                    return;
                }
                CustomerSelectorDialog dialog = new CustomerSelectorDialog(new DefaultCustomerListView());
                dialog.setCreateNewTicket(false);
                dialog.updateView(true);
                dialog.openUndecoratedFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                this.customer = dialog.getSelectedCustomer();
                email = this.customer.getEmail().trim();
            } else {
                this.customer = CustomerDAO.getInstance().get(customerId);
                email = this.customer.getEmail();
            }
            if (StringUtils.isEmpty((String)email)) {
                email = PosOptionPane.showInputDialog("Enter Email Address", "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", "Invalid email! Please enter valid email.", true);
                if (StringUtils.isEmpty((String)email)) {
                    POSMessageDialog.showError("Cannot send email without customer email address");
                    return;
                }
                Customer existedCustomer = CustomerDAO.getInstance().findByPhoneOrEmail(null, email);
                if (existedCustomer != null) {
                    POSMessageDialog.showError("Email already exists with different customer, please choose a different one.");
                    return;
                }
                this.customer.setEmail(email.trim());
                CustomerDAO.getInstance().saveOrUpdate(this.customer);
            }
            ticket.setCustomer(this.customer);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.completedTransaction.setTicket(ticket);
            Terminal terminal = Application.getInstance().refreshAndGetTerminal();
            String smtpHost = terminal.getSmtpHost();
            String senderEmail = terminal.getSmtpSender();
            String encryptedPassword = terminal.getSmtpPassword();
            String password = null;
            if (!StringUtils.isEmpty((String)encryptedPassword)) {
                password = AESencrp.decrypt(encryptedPassword);
            }
            if (StringUtils.isEmpty((String)smtpHost)) {
                POSMessageDialog.showError("SMTP Host not found! Please set configuration!");
                return;
            }
            if (StringUtils.isEmpty((String)senderEmail)) {
                POSMessageDialog.showError("Sender email not found! Please set configuration!");
                return;
            }
            if (StringUtils.isEmpty((String)password)) {
                POSMessageDialog.showError("Password not found! Please set configuration!");
                return;
            }
            byte[] bytes = ReceiptPrintService.createPDFStream(ticket);
            ByteArrayDataSource bads = new ByteArrayDataSource(bytes, "application/pdf");
            MailService.sendMail(email, "Ticket Receipt", "Ticket Receipt", "TICKET_RECEIPT_" + ticket.getId() + ".pdf", bads);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Order payment receipt successfully sent to \"" + email + "\"");
        }
        catch (Exception e) {
            PosLog.error(TransactionCompletionDialog.class, e);
        }
    }

    protected JLabel createLabel(String text, int alignment) {
        JLabel label = new JLabel(text);
        label.setFont(new Font("Tahoma", 1, 24));
        label.setHorizontalAlignment(alignment);
        label.setText(text);
        return label;
    }

    public double getTenderedAmount() {
        return this.tenderedAmount;
    }

    public void setTenderedAmount(double amountTendered) {
        this.tenderedAmount = amountTendered;
    }

    public void updateView() {
        this.lblTotalAmount.setText(NumberUtil.formatNumber(this.totalAmount));
        this.lblTenderedAmount.setText(NumberUtil.formatNumber(this.tenderedAmount));
        this.lblPaidAmount.setText(NumberUtil.formatNumber(this.paidAmount));
        this.lblDueAmount.setText(NumberUtil.formatNumber(this.dueAmount));
        this.lblGratuityAmount.setText(NumberUtil.formatNumber(this.gratuityAmount));
        this.lblChangeDue.setText(NumberUtil.formatNumber(this.changeAmount));
    }

    public double getDueAmount() {
        return this.dueAmount;
    }

    public void setDueAmount(double dueAmount) {
        this.dueAmount = dueAmount;
    }

    public double getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(double paidAmount) {
        this.paidAmount = paidAmount;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getGratuityAmount() {
        return this.gratuityAmount;
    }

    public void setGratuityAmount(double gratuityAmount) {
        this.gratuityAmount = gratuityAmount;
    }

    public double getChangeAmount() {
        return this.changeAmount;
    }

    public void setChangeAmount(double changeAmount) {
        this.changeAmount = changeAmount;
    }

    public void setCompletedTransaction(PosTransaction completedTransaction) {
        this.completedTransaction = completedTransaction;
    }

    public boolean isCard() {
        return this.isCard;
    }

    public void setCard(boolean isCard) {
        this.isCard = isCard;
    }

    public void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
    }

    public List<PosTransaction> getCompletedTransactions() {
        return this.completedTransactions;
    }
}

