/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.StaleObjectStateException;

public class CustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField tfFirstName;
    private FixedLengthTextField tfLastName;
    private FixedLengthTextField tfDoB;
    private FixedLengthTextField tfMobile;
    private FixedLengthTextField tfPersonalEmail;
    private JTextArea tfAddress;
    private FixedLengthTextField tfCity;
    private FixedLengthTextField tfState;
    private FixedLengthTextField tfZip;
    private FixedLengthTextField tfCountry;
    private FixedLengthTextField tfLoyaltyNo;
    private IntegerTextField tfLoyaltyPoint;
    private DoubleTextField tfCreditLimit;
    private DoubleTextField tfBalance;
    private JCheckBox cbVip;
    private JCheckBox cbTaxExempt;
    private JLabel lblPicture;
    private PosSmallButton btnSelectImage;
    private PosSmallButton btnClearImage;
    private JComboBox cbSalutation;
    private QwertyKeyPad qwertyKeyPad;
    public boolean isKeypad;
    private ImageResource imageResource;
    private MyOwnFocusTraversalPolicy newPolicy;
    private Image image;
    private FixedLengthTextField tfBusinessEmail;

    public CustomerForm() {
        this.createCustomerForm();
    }

    public CustomerForm(boolean enable) {
        this.isKeypad = enable;
        this.createCustomerForm();
    }

    private void createCustomerForm() {
        this.setOpaque(true);
        this.setLayout((LayoutManager)new MigLayout("fill", "[][][]", ""));
        this.add((Component)this.createPicturePanel(), "top 0");
        this.add((Component)this.createCenterPanel(), "grow");
        this.add((Component)this.createRightPanel(), "grow, wrap");
        this.qwertyKeyPad = new QwertyKeyPad();
        if (this.isKeypad) {
            this.add((Component)((Object)this.qwertyKeyPad), "span, grow");
        }
        this.btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerForm.this.doSelectImageFile();
            }
        });
        this.btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerForm.this.doClearImage();
            }
        });
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    private JPanel createPicturePanel() {
        JPanel picturePanel = new JPanel((LayoutManager)new MigLayout());
        this.lblPicture = new JLabel("");
        this.image = IconFactory.getIcon("/images/", "generic-profile-pic-v2.png").getImage();
        this.lblPicture = new JLabel("");
        this.lblPicture.setPreferredSize(new Dimension(200, 200));
        this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
        this.lblPicture.setIconTextGap(0);
        this.lblPicture.setHorizontalAlignment(0);
        picturePanel.setBorder(new TitledBorder(null, Messages.getString("CustomerForm.10"), 4, 2, null, null));
        picturePanel.add((Component)this.lblPicture, "grow,wrap,center");
        this.btnSelectImage = new PosSmallButton();
        this.btnSelectImage.setText(Messages.getString("CustomerForm.44"));
        picturePanel.add((Component)this.btnSelectImage, "split 2,center");
        this.btnClearImage = new PosSmallButton();
        this.btnClearImage.setText(Messages.getString("CustomerForm.45"));
        picturePanel.add(this.btnClearImage);
        return picturePanel;
    }

    private JPanel createCenterPanel() {
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JLabel lblSalutation = new JLabel(Messages.getString("CustomerForm.0"));
        this.cbSalutation = new JComboBox();
        this.cbSalutation.addItem(Messages.getString("CustomerForm.2"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.4"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.5"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.6"));
        this.cbSalutation.setPreferredSize(new Dimension(100, 0));
        JLabel lblFirstName = new JLabel(Messages.getString("CustomerForm.3"));
        this.tfFirstName = new FixedLengthTextField(30);
        JLabel lblLastName = new JLabel(Messages.getString("CustomerForm.11"));
        this.tfLastName = new FixedLengthTextField();
        JLabel lblDob = new JLabel("DoB (MM-DD-YYYY)");
        this.tfDoB = new FixedLengthTextField();
        JLabel lblMobile = new JLabel(Messages.getString("CustomerForm.16"));
        this.tfMobile = new FixedLengthTextField(30);
        JLabel lblPersonalEmail = new JLabel(Messages.getString("CustomerForm.17"));
        this.tfPersonalEmail = new FixedLengthTextField();
        JLabel lblBusinessEmail = new JLabel(Messages.getString("CustomerForm.8"));
        this.tfBusinessEmail = new FixedLengthTextField();
        JLabel lblLoyaltyNo = new JLabel(Messages.getString("CustomerForm.19"));
        this.tfLoyaltyNo = new FixedLengthTextField();
        JLabel lblLoyaltyPoint = new JLabel(Messages.getString("CustomerForm.20"));
        this.tfLoyaltyPoint = new IntegerTextField();
        this.tfLoyaltyPoint.setEditable(false);
        JLabel lblCreditLimit = new JLabel(Messages.getString("CustomerForm.23"));
        this.tfCreditLimit = new DoubleTextField();
        this.tfCreditLimit.setText("500.00");
        JLabel lblBalance = new JLabel(Messages.getString("CustomerForm.25"));
        this.tfBalance = new DoubleTextField();
        centerPanel.add((Component)lblSalutation, "right");
        centerPanel.add((Component)this.cbSalutation, "wrap,grow");
        centerPanel.add((Component)lblFirstName, "right");
        centerPanel.add((Component)this.tfFirstName, "wrap,grow");
        centerPanel.add((Component)lblLastName, "right");
        centerPanel.add((Component)this.tfLastName, "wrap,grow");
        centerPanel.add((Component)lblDob, "right");
        centerPanel.add((Component)this.tfDoB, "wrap,grow");
        centerPanel.add((Component)lblMobile, "right");
        centerPanel.add((Component)this.tfMobile, "wrap,grow");
        centerPanel.add((Component)lblPersonalEmail, "right");
        centerPanel.add((Component)this.tfPersonalEmail, "wrap,grow");
        centerPanel.add((Component)lblBusinessEmail, "right");
        centerPanel.add((Component)this.tfBusinessEmail, "wrap,grow");
        centerPanel.add((Component)lblLoyaltyNo, "right");
        centerPanel.add((Component)this.tfLoyaltyNo, "wrap,grow");
        centerPanel.add((Component)lblLoyaltyPoint, "right");
        centerPanel.add((Component)this.tfLoyaltyPoint, "wrap,grow");
        centerPanel.add((Component)lblCreditLimit, "right");
        centerPanel.add((Component)this.tfCreditLimit, "wrap,grow");
        centerPanel.add((Component)lblBalance, "right");
        centerPanel.add((Component)this.tfBalance, "grow");
        return centerPanel;
    }

    private JPanel createRightPanel() {
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]"));
        JLabel lblAddress = new JLabel(Messages.getString("CustomerForm.51"));
        this.tfAddress = new JTextArea();
        this.tfAddress.setRows(3);
        this.tfAddress.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.tfAddress);
        JLabel lblCity = new JLabel(Messages.getString("CustomerForm.52"));
        this.tfCity = new FixedLengthTextField();
        JLabel lblState = new JLabel(Messages.getString("CustomerForm.53"));
        this.tfState = new FixedLengthTextField();
        JLabel lblZip = new JLabel(Messages.getString("CustomerForm.55"));
        this.tfZip = new FixedLengthTextField();
        JLabel lblCountry = new JLabel(Messages.getString("CustomerForm.56"));
        this.tfCountry = new FixedLengthTextField();
        this.tfCountry.setText(Messages.getString("CustomerForm.57"));
        this.cbVip = new JCheckBox(Messages.getString("CustomerForm.58"));
        this.cbVip.setFocusable(false);
        this.cbTaxExempt = new JCheckBox(Messages.getString("CustomerForm.59"));
        rightPanel.add((Component)lblAddress, "right");
        rightPanel.add((Component)jScrollPane, "wrap, span 0 1, grow");
        rightPanel.add((Component)lblCity, "right");
        rightPanel.add((Component)this.tfCity, "wrap");
        rightPanel.add((Component)lblState, "right");
        rightPanel.add((Component)this.tfState, "wrap");
        rightPanel.add((Component)lblZip, "right");
        rightPanel.add((Component)this.tfZip, "wrap");
        rightPanel.add((Component)lblCountry, "right");
        rightPanel.add((Component)this.tfCountry, "wrap");
        rightPanel.add((Component)this.cbVip, "skip 1,wrap");
        rightPanel.add((Component)this.cbTaxExempt, "skip 1");
        return rightPanel;
    }

    public void callOrderController() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.tfFirstName);
        order.add(this.tfLastName);
        order.add(this.tfDoB);
        order.add(this.tfMobile);
        order.add(this.tfPersonalEmail);
        order.add(this.tfBusinessEmail);
        order.add(this.tfLoyaltyNo);
        order.add(this.tfLoyaltyPoint);
        order.add(this.tfCreditLimit);
        order.add(this.tfBalance);
        order.add(this.tfAddress);
        order.add(this.tfCity);
        order.add(this.tfState);
        order.add(this.tfZip);
        order.add(this.tfCountry);
        this.newPolicy = new MyOwnFocusTraversalPolicy(order);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.newPolicy);
    }

    public void enableCustomerFields(boolean enable) {
        this.cbSalutation.setEnabled(enable);
        this.tfLastName.setEnabled(enable);
        this.tfFirstName.setEnabled(enable);
        this.tfDoB.setEnabled(enable);
        this.tfMobile.setEnabled(enable);
        this.tfPersonalEmail.setEnabled(enable);
        this.tfBusinessEmail.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfState.setEditable(enable);
        this.tfZip.setEnabled(enable);
        this.tfCountry.setEnabled(enable);
        this.tfLoyaltyNo.setEnabled(enable);
        this.tfLoyaltyPoint.setEnabled(enable);
        this.tfCreditLimit.setEnabled(enable);
        this.tfBalance.setEnabled(enable);
        this.cbVip.setEnabled(enable);
        this.cbTaxExempt.setEnabled(enable);
        this.btnClearImage.setEnabled(enable);
        this.btnSelectImage.setEnabled(enable);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.cbSalutation.setEnabled(enable);
        this.tfFirstName.setEnabled(enable);
        this.tfLastName.setEnabled(enable);
        this.tfPersonalEmail.setEnabled(enable);
        this.tfBusinessEmail.setEnabled(enable);
        this.tfLoyaltyNo.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfCreditLimit.setEnabled(enable);
        this.tfZip.setEnabled(enable);
        this.tfCountry.setEnabled(enable);
        this.cbVip.setEnabled(enable);
        this.cbTaxExempt.setEnabled(enable);
        this.tfDoB.setEnabled(enable);
        this.tfBalance.setEnabled(enable);
        this.btnClearImage.setEnabled(enable);
        this.btnSelectImage.setEnabled(enable);
        this.tfLoyaltyPoint.setEnabled(enable);
        this.tfMobile.setEnabled(enable);
    }

    public void setFieldsEditable(boolean editable) {
        this.cbSalutation.setEditable(editable);
        this.tfFirstName.setEditable(editable);
        this.tfLastName.setEditable(editable);
        this.tfPersonalEmail.setEditable(editable);
        this.tfBusinessEmail.setEditable(editable);
        this.tfLoyaltyNo.setEditable(editable);
        this.tfAddress.setEditable(editable);
        this.tfCity.setEditable(editable);
        this.tfCreditLimit.setEditable(editable);
        this.tfZip.setEditable(editable);
        this.tfCountry.setEditable(editable);
        this.cbVip.setEnabled(editable);
        this.cbTaxExempt.setEnabled(editable);
        this.tfDoB.setEditable(editable);
        this.tfBalance.setEditable(editable);
        this.btnClearImage.setEnabled(editable);
        this.btnSelectImage.setEnabled(editable);
        this.tfLoyaltyPoint.setEditable(editable);
        this.tfMobile.setEditable(editable);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.tfFirstName.setText("");
        this.tfLastName.setText("");
        this.cbSalutation.setSelectedIndex(0);
        this.tfDoB.setText("");
        this.tfAddress.setText("");
        this.tfCity.setText("");
        this.tfCountry.setText("");
        this.tfCreditLimit.setText("");
        this.tfPersonalEmail.setText("");
        this.tfBusinessEmail.setText("");
        this.tfLoyaltyNo.setText("");
        this.tfLoyaltyPoint.setText("");
        this.tfBalance.setText("");
        this.tfZip.setText("");
        this.cbVip.setSelected(false);
        this.cbTaxExempt.setSelected(false);
        this.tfMobile.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException customer) {
        }
        catch (StaleObjectStateException e) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.cbSalutation.setSelectedItem(customer.getSalutation());
        this.tfFirstName.setText(customer.getFirstName());
        this.tfLastName.setText(customer.getLastName());
        this.tfDoB.setText(customer.getDob());
        this.tfAddress.setText(customer.getAddress());
        this.tfCity.setText(customer.getCity());
        this.tfCountry.setText(customer.getCountry());
        this.tfCreditLimit.setText(String.valueOf(customer.getCreditLimit()));
        this.tfPersonalEmail.setText(customer.getEmail());
        this.tfBusinessEmail.setText(customer.getEmail2());
        this.tfLoyaltyNo.setText(customer.getLoyaltyNo());
        this.tfLoyaltyPoint.setText(customer.getLoyaltyPoint().toString());
        this.tfBalance.setText(String.valueOf(customer.getBalance()));
        this.tfState.setText(customer.getState());
        this.tfZip.setText(customer.getZipCode());
        this.cbVip.setSelected(customer.isVip());
        this.cbTaxExempt.setSelected(customer.isTaxExempt());
        this.tfMobile.setText(customer.getMobileNo());
        if (customer.getSsn() != null) {
            // empty if block
        }
        this.imageResource = ImageResourceDAO.getInstance().findById(customer.getImageId());
        if (this.imageResource != null) {
            this.lblPicture.setIcon(new ImageIcon(this.imageResource.getImage().getScaledInstance(200, 200, 1)));
        } else {
            this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle("Image Gallery");
        dialog.setSelectBtnVisible(true);
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblPicture.setIcon(new ImageIcon(this.imageResource.getImage().getScaledInstance(200, 200, 1)));
        }
    }

    protected void doClearImage() {
        this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object selectedItem;
        String fname = this.tfFirstName.getText();
        String personalEmail = this.tfPersonalEmail.getText();
        String businessEmail = this.tfBusinessEmail.getText();
        if (StringUtils.isEmpty((String)fname)) {
            POSMessageDialog.showError(null, Messages.getString("CustomerForm.60"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)personalEmail) && !this.doCheckValidEmail(personalEmail)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)businessEmail) && !this.doCheckValidEmail(businessEmail)) {
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        if ((selectedItem = this.cbSalutation.getSelectedItem()) != null) {
            customer.setSalutation(selectedItem.toString());
        }
        customer.setFirstName(this.tfFirstName.getText());
        customer.setLastName(this.tfLastName.getText());
        customer.setDob(this.tfDoB.getText());
        customer.setAddress(this.tfAddress.getText());
        customer.setCity(this.tfCity.getText());
        customer.setCountry(this.tfCountry.getText());
        customer.setState(this.tfState.getText());
        customer.setCreditLimit(PosGuiUtil.parseDouble(this.tfCreditLimit));
        customer.setEmail(personalEmail);
        customer.setEmail2(this.tfBusinessEmail.getText());
        customer.setLoyaltyNo(this.tfLoyaltyNo.getText());
        customer.setLoyaltyPoint(this.tfLoyaltyPoint.getInteger());
        customer.setZipCode(this.tfZip.getText());
        customer.setVip(this.cbVip.isSelected());
        customer.setTaxExempt(this.cbTaxExempt.isSelected());
        customer.setMobileNo(this.tfMobile.getText());
        customer.setBalance(PosGuiUtil.parseDouble(this.tfBalance));
        if (this.imageResource != null) {
            customer.setImageId(this.imageResource.getId());
        }
        return true;
    }

    private boolean doCheckValidEmail(String personalEmail) {
        boolean valid = EmailValidator.getInstance().isValid(personalEmail);
        if (!valid) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return valid;
    }

    @Override
    public boolean delete() {
        try {
            Customer bean2 = (Customer)this.getBean();
            if (bean2 == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (option != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(bean2);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.getBean() == null) {
            return Messages.getString("CustomerForm.54");
        }
        return Messages.getString("CustomerForm.12");
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyOwnFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

