/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.ZipCodeUtil;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class QuickCustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField tfAddress;
    private FixedLengthTextField tfCity;
    private FixedLengthTextField tfZip;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfState;
    private FixedLengthTextField tfPhone;
    private QwertyKeyPad qwertyKeyPad;
    public boolean isKeypad;
    private FixedLengthTextField tfPersonalEmail;
    private FixedLengthTextField tfBusinessEmail;

    public QuickCustomerForm() {
        this.createCustomerForm();
    }

    public QuickCustomerForm(Customer customer) {
        this.isKeypad = true;
        this.createCustomerForm();
        this.setBean(customer);
    }

    public QuickCustomerForm(boolean showKeyPad) {
        this.isKeypad = showKeyPad;
        this.createCustomerForm();
    }

    private void createCustomerForm() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(true);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout((LayoutManager)new MigLayout("insets 10 10 10 10, fill", "[][fill,grow]", ""));
        inputPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("QuickCustomerForm.2")));
        JLabel lblAddress = new JLabel(Messages.getString("CustomerForm.18"));
        this.tfAddress = new FixedLengthTextField(220);
        this.tfAddress.setColumns(60);
        JLabel lblZip = new JLabel(Messages.getString("CustomerForm.21"));
        this.tfZip = new FixedLengthTextField(30);
        JLabel lblCitytown = new JLabel(Messages.getString("QuickCustomerForm.3"));
        this.tfCity = new FixedLengthTextField();
        JLabel lblState = new JLabel(Messages.getString("QuickCustomerForm.0"));
        this.tfState = new FixedLengthTextField(30);
        JLabel lblPhone = new JLabel(Messages.getString("QuickCustomerForm.4"));
        this.tfPhone = new FixedLengthTextField(30);
        JLabel lblPersonalEmail = new JLabel(Messages.getString("QuickCustomerForm.5"));
        this.tfPersonalEmail = new FixedLengthTextField(30);
        JLabel lblBusinessEmail = new JLabel(Messages.getString("QuickCustomerForm.6"));
        this.tfBusinessEmail = new FixedLengthTextField(30);
        JLabel lblName = new JLabel("Name");
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(120);
        inputPanel.add((Component)lblPhone, "alignx right");
        inputPanel.add((Component)this.tfPhone, "wrap");
        inputPanel.add((Component)lblName, "alignx right");
        inputPanel.add((Component)this.tfName, "wrap");
        inputPanel.add((Component)lblPersonalEmail, "right");
        inputPanel.add((Component)this.tfPersonalEmail, "wrap");
        inputPanel.add((Component)lblBusinessEmail, "right");
        inputPanel.add((Component)this.tfBusinessEmail, "wrap");
        inputPanel.add((Component)lblAddress, "right");
        inputPanel.add((Component)this.tfAddress, "wrap");
        inputPanel.add((Component)lblZip, "right");
        inputPanel.add((Component)this.tfZip, "wrap");
        inputPanel.add((Component)lblCitytown, "right");
        inputPanel.add((Component)this.tfCity, "wrap");
        inputPanel.add((Component)lblState, "right");
        inputPanel.add((Component)this.tfState, "wrap");
        this.qwertyKeyPad = new QwertyKeyPad();
        this.add((Component)inputPanel, "Center");
        if (this.isKeypad) {
            this.add((Component)((Object)this.qwertyKeyPad), "South");
        }
        this.tfZip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickCustomerForm.this.getStateAndCityByZipCode();
            }
        });
        this.tfZip.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                QuickCustomerForm.this.getStateAndCityByZipCode();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    public void callOrderController() {
        Vector<FixedLengthTextField> order = new Vector<FixedLengthTextField>();
        order.add(this.tfPhone);
        order.add(this.tfName);
        order.add(this.tfPersonalEmail);
        order.add(this.tfBusinessEmail);
        order.add(this.tfZip);
        order.add(this.tfCity);
        order.add(this.tfState);
        order.add(this.tfAddress);
    }

    public void enableCustomerFields(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfPersonalEmail.setEnabled(enable);
        this.tfBusinessEmail.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfZip.setEnabled(enable);
        this.tfPhone.setEnabled(enable);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfPersonalEmail.setEnabled(enable);
        this.tfBusinessEmail.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfZip.setEnabled(enable);
        this.tfPhone.setEnabled(enable);
    }

    public void setFieldsEditable(boolean editable) {
        this.tfName.setEditable(editable);
        this.tfPersonalEmail.setEditable(editable);
        this.tfBusinessEmail.setEditable(editable);
        this.tfAddress.setEditable(editable);
        this.tfCity.setEditable(editable);
        this.tfZip.setEditable(editable);
        this.tfPhone.setEditable(editable);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.tfName.setText("");
        this.tfPersonalEmail.setText("");
        this.tfBusinessEmail.setText("");
        this.tfAddress.setText("");
        this.tfCity.setText("");
        this.tfZip.setText("");
        this.tfPhone.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (Exception e) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
            return false;
        }
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.tfName.setText(customer.getName());
        this.tfPersonalEmail.setText(customer.getEmail());
        this.tfBusinessEmail.setText(customer.getEmail2());
        this.tfCity.setText(customer.getCity());
        this.tfZip.setText(customer.getZipCode());
        this.tfPhone.setText(customer.getMobileNo());
        this.tfState.setText(customer.getState());
        this.tfZip.setText(customer.getZipCode());
        this.tfAddress.setText(customer.getAddress());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String phone = this.tfPhone.getText();
        String name = this.tfName.getText();
        String[] fullName = name.split(" ");
        String fname = fullName[0];
        String lastName = name.substring(fname.length(), name.length());
        String personalEmail = this.tfPersonalEmail.getText();
        String businessEmail = this.tfBusinessEmail.getText();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showError(null, Messages.getString("QuickCustomerForm.1"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)personalEmail) && !this.doCheckValidEmail(personalEmail)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)businessEmail) && !this.doCheckValidEmail(businessEmail)) {
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        customer.setName(name);
        customer.setFirstName(fname);
        customer.setLastName(lastName);
        customer.setEmail(personalEmail);
        customer.setEmail2(businessEmail);
        customer.setAddress(this.tfAddress.getText());
        customer.setCity(this.tfCity.getText());
        customer.setState(this.tfState.getText());
        customer.setZipCode(this.tfZip.getText());
        customer.setMobileNo(phone);
        return true;
    }

    private boolean doCheckValidEmail(String personalEmail) {
        boolean valid = EmailValidator.getInstance().isValid(personalEmail);
        if (!valid) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("QuickCustomerForm.8"));
            return false;
        }
        return valid;
    }

    @Override
    public boolean delete() {
        try {
            Customer bean2 = (Customer)this.getBean();
            if (bean2 == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (option != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(bean2);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("CustomerForm.54");
    }

    private void getStateAndCityByZipCode() {
        String zipCode = this.tfZip.getText();
        if (zipCode == null || zipCode.isEmpty()) {
            return;
        }
        String city = ZipCodeUtil.getCity(zipCode);
        String state = ZipCodeUtil.getState(zipCode);
        if (StringUtils.isNotEmpty((String)state)) {
            this.tfState.setText(state);
        }
        if (StringUtils.isNotEmpty((String)city)) {
            this.tfCity.setText(city);
        }
    }

    public void setPhoneNo(String phoneNo) {
        this.tfPhone.setText(phoneNo);
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyOwnFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

