/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class UserTypeForm
extends BeanEditor {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private CheckBoxList<UserPermission> listPermissions;
    private JTextField tfTypeName;
    private JPanel headerPanel;
    private JPanel centerPanel;

    public UserTypeForm() {
        this(new UserType());
    }

    public UserTypeForm(UserType type) {
        this.initComponents();
        this.listPermissions.setModel((UserPermission[])UserPermission.permissions);
        this.setBean(type);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfTypeName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listPermissions = new CheckBoxList();
        this.listPermissions.setTableHeaderHide(true);
        this.headerPanel = new JPanel(new BorderLayout(5, 5));
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.centerPanel = new JPanel(new BorderLayout(5, 5));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jLabel1.setText(POSConstants.TYPE_NAME + ":");
        this.jLabel2.setText(POSConstants.PERMISSIONS + ":");
        this.jScrollPane1.setViewportView(this.listPermissions);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.headerPanel.add((Component)this.jLabel1, "West");
        this.headerPanel.add(this.tfTypeName);
        this.centerPanel.add((Component)this.jLabel2, "West");
        this.centerPanel.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.centerPanel, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
        UserTypeDAO dao = new UserTypeDAO();
        dao.saveOrUpdate(this.getUserType());
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String name;
        UserType userType = this.getUserType();
        if (userType == null) {
            userType = new UserType();
        }
        if (StringUtils.isEmpty((String)(name = this.tfTypeName.getText()))) {
            throw new IllegalModelStateException(POSConstants.TYPE_NAME_CANNOT_BE_EMPTY);
        }
        userType.setName(name);
        userType.clearPermissions();
        List<UserPermission> checkedValues = this.listPermissions.getCheckedValues();
        for (int i = 0; i < checkedValues.size(); ++i) {
            userType.addTopermissions(checkedValues.get(i));
        }
        this.setBean(userType);
        return true;
    }

    @Override
    protected void updateView() {
        UserType userType = this.getUserType();
        if (userType.getId() == null) {
            this.listPermissions.clearSelection();
            return;
        }
        this.tfTypeName.setText(userType.getName());
        Set<UserPermission> permissions = userType.getPermissions();
        if (permissions == null) {
            this.listPermissions.clearSelection();
            return;
        }
        CheckBoxListModel model = (CheckBoxListModel)this.listPermissions.getModel();
        for (UserPermission permission : permissions) {
            for (int i = 0; i < model.getItems().size(); ++i) {
                CheckBoxList.Entry entry = model.getItems().get(i);
                if (!entry.getValue().equals(permission)) continue;
                entry.setChecked(true);
            }
        }
        model.fireTableDataChanged();
    }

    public UserType getUserType() {
        return (UserType)this.getBean();
    }

    @Override
    public String getDisplayText() {
        UserType userType = (UserType)this.getBean();
        if (userType == null || userType.getId() == null) {
            return Messages.getString("UserTypeForm.0");
        }
        return Messages.getString("UserTypeForm.1");
    }
}

