/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.base.BaseInventoryLocation;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TreeDisplayDialog;
import com.floreantpos.ui.inv.InventoryItemEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class InventoryStockInForm
extends BeanEditor<InventoryTransaction> {
    private JButton btnParentLoc;
    private POSTextField tfLocation;
    private JLabel lblLoc;
    private DefaultMutableTreeNode path;
    private JLabel lblVendor;
    private JComboBox<InventoryVendor> cbVendor;
    private POSTextField tfPONumber;
    private JLabel lblPONumber;
    private InventoryLocation location;
    private TitledBorder titleBorder;
    private JXTable table;
    private BeanTableModel<InventoryTransaction> tableModel;
    private DoubleTextField tfSubTotalAmount;
    private JButton btnAddItem;
    private JButton btnDeleteItem;
    private InventoryTransaction inventoryTransaction;
    private JComboBox<String> cbInventoryReasons;
    private List<InventoryTransaction> inventoryTransactions;

    public InventoryStockInForm() {
        this((InventoryTransaction)null);
    }

    public InventoryStockInForm(InventoryTransaction inventoryTransaction) {
        this.inventoryTransaction = inventoryTransaction;
        this.initComponents();
        this.initData();
        this.setBean(inventoryTransaction);
    }

    private void initData() {
        if (this.inventoryTransaction.getMenuItem() != null) {
            this.tableModel.addRow(this.inventoryTransaction);
        }
        ArrayList<String> inventoryReasons = new ArrayList<String>();
        for (int i = 0; i < InventoryTransaction.REASON_IN.length; ++i) {
            inventoryReasons.add(InventoryTransaction.REASON_IN[i]);
        }
        this.cbInventoryReasons.setModel(new ComboBoxModel(inventoryReasons));
        InventoryVendorDAO inventoryVendorDao = new InventoryVendorDAO();
        List<InventoryVendor> inventoryVendors = inventoryVendorDao.findAll();
        this.cbVendor.setModel(new ComboBoxModel(inventoryVendors));
        this.tfLocation.setEditable(false);
        this.btnParentLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryStockInForm.this.path = InventoryStockInForm.this.getLocationModelPath();
                if (InventoryStockInForm.this.path == null) {
                    return;
                }
                InventoryStockInForm.this.location = (InventoryLocation)InventoryStockInForm.this.path.getUserObject();
                InventoryStockInForm.this.tfLocation.setText(InventoryStockInForm.this.location.getName());
            }
        });
        List<InventoryLocation> inventoryLocationList = InventoryLocationDAO.getInstance().findAll();
        BaseInventoryLocation defaultInLocation = null;
        if (inventoryLocationList != null) {
            for (InventoryLocation inventoryLocation : inventoryLocationList) {
                if (!inventoryLocation.isDefaultInLocation().booleanValue()) continue;
                defaultInLocation = inventoryLocation;
            }
            if (defaultInLocation != null) {
                this.location = defaultInLocation;
                this.tfLocation.setText(defaultInLocation.getName());
            }
        }
        this.updatePrice();
    }

    private DefaultMutableTreeNode getLocationModelPath() {
        List<InventoryLocation> rootLocations = InventoryLocationDAO.getInstance().getRootLocations();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (InventoryLocation inventoryLocation : rootLocations) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(inventoryLocation);
            root.add(node);
            this.buildTree(node);
        }
        JTree tree = new JTree(root);
        for (int i = 1; i < tree.getRowCount() * 2; ++i) {
            tree.expandRow(i);
        }
        tree.setRootVisible(false);
        TreeDisplayDialog treeDisplayDialog = new TreeDisplayDialog(tree);
        treeDisplayDialog.setPreferredSize(PosUIManager.getSize(500, 600));
        treeDisplayDialog.open();
        if (treeDisplayDialog.isCanceled()) {
            return null;
        }
        return treeDisplayDialog.getPath();
    }

    private void updatePrice() {
        double subtotalAmount = 0.0;
        List<InventoryTransaction> transactions = this.tableModel.getRows();
        if (transactions == null) {
            return;
        }
        for (InventoryTransaction item : transactions) {
            subtotalAmount += item.getQuantity() * item.getUnitCost();
        }
        this.tfSubTotalAmount.setText(NumberUtil.formatNumber(subtotalAmount));
        this.table.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[][grow][]", ""));
        this.titleBorder = new TitledBorder("");
        itemInfoPanel.setBorder(this.titleBorder);
        this.add((Component)itemInfoPanel, "North");
        this.lblPONumber = new JLabel("P.O. No");
        itemInfoPanel.add((Component)this.lblPONumber, "alignx trailing");
        this.tfPONumber = new POSTextField();
        itemInfoPanel.add((Component)this.tfPONumber, "growx, wrap");
        this.lblVendor = new JLabel("Vendor");
        itemInfoPanel.add((Component)this.lblVendor, "alignx trailing");
        this.cbVendor = new JComboBox();
        this.cbVendor.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add(this.cbVendor, "wrap");
        JLabel lblInventoryTransactionType = new JLabel("Reason Type");
        itemInfoPanel.add((Component)lblInventoryTransactionType, "alignx trailing");
        this.cbInventoryReasons = new JComboBox();
        this.cbInventoryReasons.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add(this.cbInventoryReasons, "wrap");
        this.lblLoc = new JLabel("To Location");
        itemInfoPanel.add((Component)this.lblLoc, "alignx trailing");
        this.tfLocation = new POSTextField();
        itemInfoPanel.add((Component)this.tfLocation, "split 3,growx");
        this.tfLocation.setEditable(false);
        this.btnParentLoc = new JButton("Select");
        itemInfoPanel.add(this.btnParentLoc);
        JButton btnClearLoc = new JButton("Clear");
        itemInfoPanel.add(btnClearLoc);
        btnClearLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryStockInForm.this.tfLocation.setText("");
            }
        });
        this.tableModel = new BeanTableModel(InventoryTransaction.class);
        this.tableModel.addColumn("SKU", "sku");
        this.tableModel.addColumn("ITEM", "itemName");
        this.tableModel.addColumn("QTY", "quantity", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.tableModel.addColumn("COST", "unitCost", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("UNIT", "unit");
        this.tableModel.addColumn("TOTAL", "total", 11, BeanTableModel.DataType.MONEY);
        this.table = new PosTable(this.tableModel){

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                InventoryTransaction inventoryTransaction = (InventoryTransaction)InventoryStockInForm.this.tableModel.getRow(rowIndex);
                String receiveStr = value.toString();
                if (receiveStr.isEmpty()) {
                    return;
                }
                double quantity = Double.parseDouble(receiveStr);
                if (columnIndex == 2) {
                    inventoryTransaction.setQuantity(quantity);
                    inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * inventoryTransaction.getUnitCost());
                    InventoryStockInForm.this.updatePrice();
                }
                if (columnIndex == 3) {
                    inventoryTransaction.setUnitCost(quantity);
                    inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * inventoryTransaction.getUnitCost());
                    InventoryStockInForm.this.updatePrice();
                }
            }
        };
        this.add(new JScrollPane((Component)this.table));
        JPanel southActionPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.btnAddItem = new JButton("Add Item");
        JButton btnEditItem = new JButton("Edit");
        this.btnDeleteItem = new JButton("Delete");
        this.btnAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransaction inventoryTransaction = new InventoryTransaction();
                inventoryTransaction.setTransactionType(((InventoryTransaction)InventoryStockInForm.this.getBean()).getTransactionType());
                InventoryItemEntryDialog dialog = new InventoryItemEntryDialog(inventoryTransaction);
                dialog.setSize(500, 400);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                InventoryStockInForm.this.tableModel.addRow(dialog.getInventoryTransaction());
                InventoryStockInForm.this.updatePrice();
            }
        });
        btnEditItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = InventoryStockInForm.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                int index = InventoryStockInForm.this.table.convertRowIndexToModel(row);
                InventoryTransaction inventoryTransaction = (InventoryTransaction)InventoryStockInForm.this.tableModel.getRow(index);
                if (inventoryTransaction == null) {
                    return;
                }
                InventoryItemEntryDialog dialog = new InventoryItemEntryDialog(inventoryTransaction);
                dialog.setSize(500, 400);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                InventoryStockInForm.this.table.repaint();
                InventoryStockInForm.this.updatePrice();
            }
        });
        this.btnDeleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = InventoryStockInForm.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                int index = InventoryStockInForm.this.table.convertRowIndexToModel(row);
                InventoryTransaction item = (InventoryTransaction)InventoryStockInForm.this.tableModel.getRow(index);
                if (item == null) {
                    return;
                }
                InventoryStockInForm.this.tableModel.removeRow(index);
            }
        });
        southActionPanel.add((Component)this.btnAddItem, "split 3,left");
        southActionPanel.add(btnEditItem);
        southActionPanel.add(this.btnDeleteItem);
        this.tfSubTotalAmount = new DoubleTextField(10);
        this.tfSubTotalAmount.setHorizontalAlignment(4);
        this.tfSubTotalAmount.setEditable(false);
        southActionPanel.add((Component)new JLabel("Sub-total Amount: (" + CurrencyUtil.getCurrencySymbol() + ")"), "split 2,right");
        southActionPanel.add((Component)this.tfSubTotalAmount, "");
        this.add((Component)southActionPanel, "South");
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(2, PosUIManager.getSize(80));
        this.setColumnWidth(3, PosUIManager.getSize(100));
        this.setColumnWidth(4, PosUIManager.getSize(80));
        this.setColumnWidth(5, PosUIManager.getSize(120));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void buildTree(DefaultMutableTreeNode node) {
        InventoryLocation location = (InventoryLocation)node.getUserObject();
        List<InventoryLocation> children = null;
        if (location != null) {
            children = location.getChildren();
        }
        if (children == null) {
            return;
        }
        for (InventoryLocation inventoryLocation : children) {
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(inventoryLocation);
            node.add(newChild);
            this.buildTree(newChild);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryTransactionDAO.getInstance().saveInventoryTransactionList(this.inventoryTransactions);
            return true;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        InventoryTransaction inventoryTransaction = (InventoryTransaction)this.getBean();
        if (inventoryTransaction == null) {
            return;
        }
        if (inventoryTransaction.getReason() != null) {
            this.cbInventoryReasons.setSelectedItem(inventoryTransaction.getReason());
        }
        this.updatePrice();
    }

    @Override
    public boolean updateModel() {
        this.inventoryTransactions = this.tableModel.getRows();
        if (this.inventoryTransactions == null || this.inventoryTransactions.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please add item.");
            return false;
        }
        if (this.location == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select location.");
            return false;
        }
        for (InventoryTransaction inventoryTransaction : this.inventoryTransactions) {
            inventoryTransaction.setToInventoryLocation(this.location);
            if (inventoryTransaction.getQuantity() <= 0.0) {
                POSMessageDialog.showMessage(this.getParent(), "Please enter quantity.");
                return false;
            }
            if (inventoryTransaction.getUnit().isEmpty()) {
                POSMessageDialog.showMessage(this.getParent(), "Please enter unit.");
                return false;
            }
            inventoryTransaction.setTransactionDate(new Date());
            String reasonType = (String)this.cbInventoryReasons.getSelectedItem();
            if (StringUtils.isEmpty((String)reasonType)) {
                POSMessageDialog.showMessage(this.getParent(), "Please enter reason type.");
                return false;
            }
            inventoryTransaction.setReason(reasonType);
            inventoryTransaction.setVendor((InventoryVendor)this.cbVendor.getSelectedItem());
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return "Stock In";
    }
}

