/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class TransactionStockTable
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<InventoryStock> tableModel;
    private MenuItem menuItem;

    public TransactionStockTable(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.tableModel = new BeanTableModel(InventoryStock.class);
        this.tableModel.addColumn("LOCATION", "inventoryLocation");
        this.tableModel.addColumn("QUANTITY", "quantityInHand");
        this.tableModel.addColumn("UNIT", "unit");
        this.tableModel.addRows(InventoryStockDAO.getInstance().getInventoryStocks(menuItem));
        this.table = new JXTable(this.tableModel);
        this.table.setRowHeight(40);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
    }

    public InventoryStock getSelectedItem() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return null;
        }
        index = this.table.convertRowIndexToModel(index);
        return this.tableModel.getRow(index);
    }
}

