/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.kitchendisplay.KichenButtonColumn;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.kitchendisplay.KitchenTicketActionListener;
import com.floreantpos.ui.kitchendisplay.KitchenTicketStatusSelector;
import com.floreantpos.ui.kitchendisplay.TimerWatch;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class KitchenTicketView
extends JPanel
implements ChangeListener {
    private static Border normalBorder;
    private static Border selectedBorder;
    private ImageIcon checkMark = IconFactory.getIcon("/ui_icons/", "check_mark.png");
    private TimerWatch timerWatch;
    private JScrollPane scrollPane;
    private JPanel headerPanel;
    private JLabel ticketInfo;
    private JLabel tableInfo;
    private JLabel serverInfo;
    private BumpButton btnDone;
    private KitchenTicketStatusSelector statusSelector;
    private KitchenTicketActionListener kitchenTicketContainerView;
    private JTable table;
    private KitchenTicketTableModel tableModel;
    private KitchenTicket ticket;
    private boolean showItemBump;
    private Color cellDefaultBackgroundColor = Color.black;
    private Color cellDefaultTextColor = Color.white;

    public KitchenTicketView(KitchenTicket ticket, KitchenTicketActionListener kitchenTicketContainerView) {
        this.ticket = ticket;
        this.kitchenTicketContainerView = kitchenTicketContainerView;
        this.cellDefaultBackgroundColor = TerminalConfig.getColor("kds.background", Color.black);
        this.cellDefaultTextColor = TerminalConfig.getColor("kds.textcolor", Color.white);
        boolean showBorder = AppConfig.getBoolean("kds.border", false);
        normalBorder = BorderFactory.createLineBorder(showBorder ? Color.GRAY : KitchenDisplayView.getInstance().getBackground());
        this.setLayout(new BorderLayout(1, 1));
        this.setOpaque(false);
        String dispatchText = Messages.getString("KitchenTicketView.DISPATCH");
        String bumpText = Messages.getString("KitchenTicketView.11");
        this.btnDone = new BumpButton(kitchenTicketContainerView.isDispatchMode() ? dispatchText : bumpText);
        this.createHeader(ticket);
        this.createTable(ticket);
        this.createButtonPanel();
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.statusSelector = new KitchenTicketStatusSelector((Frame)SwingUtilities.getWindowAncestor(this), ticket);
        this.setPreferredSize(PosUIManager.getSize(350, 240));
        this.timerWatch.start();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                KitchenTicketView.this.timerWatch.stop();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        this.setSelectedBorder(false);
    }

    public void stopTimer() {
        this.timerWatch.stop();
    }

    private void createHeader(KitchenTicket kitchenTicket) {
        String printerName = kitchenTicket.getPrinterName();
        if (StringUtils.isEmpty((String)printerName)) {
            printerName = kitchenTicket.getPrinters().toString();
        }
        this.ticketInfo = new JLabel(POSConstants.TOKEN + " " + kitchenTicket.getTokenNo() + " (" + kitchenTicket.getSequenceNumber() + ") ");
        this.tableInfo = new JLabel();
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            String tableNumbers = kitchenTicket.getTableNumbers().toString();
            tableNumbers = tableNumbers.replace("[", "").replace("]", "");
            this.tableInfo.setText(POSConstants.TABLE + " " + tableNumbers);
        }
        this.serverInfo = new JLabel();
        if (kitchenTicket.getServerName() != null) {
            this.serverInfo.setText(POSConstants.RECEIPT_REPORT_SERVER_LABEL + " " + kitchenTicket.getServerName());
        }
        Font font = new Font("Tahoma", 1, PosUIManager.getDefaultFontSize() + 2);
        this.ticketInfo.setFont(font);
        this.tableInfo.setFont(font);
        this.serverInfo.setFont(font);
        this.headerPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0", "sg, fill", ""));
        this.timerWatch = new TimerWatch(this.ticket.getCreateDate(), this);
        this.headerPanel.setBackground(Color.black);
        this.headerPanel.add((Component)this.ticketInfo, "split 2");
        this.headerPanel.add((Component)this.timerWatch, "right,wrap, span");
        this.headerPanel.add((Component)this.tableInfo, "split 2, grow");
        this.headerPanel.add((Component)this.serverInfo, "right,span");
        if (AppConfig.getBoolean("kds.sep", true)) {
            JSeparator sep = new JSeparator();
            sep.setBackground(Color.gray);
            this.headerPanel.add((Component)sep, "newline,h 1!,span");
        }
        this.add((Component)this.headerPanel, "North");
        this.updateHeaderView();
    }

    private void createTable(KitchenTicket kitchenTicket) {
        this.tableModel = new KitchenTicketTableModel(kitchenTicket.getTicketItems());
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setCellSelectionEnabled(false);
        this.table.setTableHeader(null);
        this.table.setOpaque(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setShowGrid(false);
        this.table.setFocusable(false);
        this.table.setFont(new Font("Arial", 1, PosUIManager.getDefaultFontSize() + 4));
        this.table.setBackground(Color.BLACK);
        this.table.setForeground(Color.white);
        this.table.setDefaultRenderer(Object.class, new KitchenTicketTableCellRenderer());
        this.resizeTableColumns();
        boolean bl = this.showItemBump = !AppConfig.getBoolean("kds.hide_item_bump", false);
        if (this.showItemBump) {
            new BumpColumnRenderer(this.table, new BumpAction(), 1);
        }
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setOpaque(false);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(KitchenDisplayView.getInstance().getBackground()));
        this.add(this.scrollPane);
    }

    private void updateHeaderView() {
        if (this.timerWatch.applicableColorComponentIndex == 0) {
            this.timerWatch.setBackgroundColor(this.timerWatch.backColor);
            this.timerWatch.setForegroundColor(this.timerWatch.textColor);
        } else {
            this.headerPanel.setBackground(this.timerWatch.backColor);
        }
        this.ticketInfo.setForeground(this.timerWatch.textColor);
        this.tableInfo.setForeground(this.timerWatch.textColor);
        this.serverInfo.setForeground(this.timerWatch.textColor);
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout(0, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        buttonPanel.setOpaque(false);
        this.btnDone.setFont(this.btnDone.getFont().deriveFont(1, PosUIManager.getDefaultFontSize() + 3));
        this.btnDone.setPreferredSize(PosUIManager.getSize(100, 40));
        if (AppConfig.getBoolean("kds.sep", true)) {
            JSeparator sep = new JSeparator();
            sep.setBackground(Color.gray);
            sep.setPreferredSize(new Dimension(0, 1));
            buttonPanel.add((Component)sep, "North");
        }
        buttonPanel.add(this.btnDone);
        this.add((Component)buttonPanel, "South");
    }

    protected String getKey() {
        return String.valueOf(this.getClientProperty("key"));
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(80));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public boolean keySelected(int key) {
        String keyString = KeyEvent.getKeyText(key);
        if (keyString.contains("NumPad-")) {
            keyString = keyString.split("-")[1];
        }
        Object kitchenKey = this.getClientProperty("key");
        String keyValue = String.valueOf(kitchenKey);
        boolean keySelected = keyValue.equals(keyString);
        this.btnDone.setKeySelected(keySelected);
        return keySelected;
    }

    public void setSelected(boolean b) {
        this.btnDone.setKeySelected(b);
    }

    public boolean isKeySelected() {
        return this.btnDone.isKeySelected();
    }

    public void fireBumpSelected() {
        this.btnDone.actionPerformed(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.timerWatch == null) {
            return;
        }
        this.updateHeaderView();
    }

    public KitchenTicket getTicket() {
        return this.ticket;
    }

    public void setTicket(KitchenTicket ticket) {
        this.ticket = ticket;
    }

    public void bump() {
        this.timerWatch.stop();
        this.kitchenTicketContainerView.bump(this);
    }

    private void setSelectedBorder(Boolean keySelected) {
        this.setBorder(keySelected == false ? normalBorder : selectedBorder);
    }

    static {
        selectedBorder = BorderFactory.createLineBorder(Color.green, 2);
    }

    private class BumpButton
    extends PosButton
    implements ActionListener {
        private Boolean keySelected;

        public BumpButton(String string) {
            super(string);
            this.keySelected = false;
            this.setOpaque(false);
            this.addActionListener(this);
            this.setForeground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color color1;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Color color2 = color1 = KitchenTicketView.this.timerWatch != null ? new Color(45, 45, 45) : this.getBackground();
            int buttonX = 0;
            int buttonY = 0;
            int width = this.getWidth();
            int height = this.getHeight();
            GradientPaint gp = new GradientPaint(buttonX, buttonY, color2, width - 2, height - 2, color1, true);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gp);
            g2.fillRect(buttonX, buttonY, width, height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.keySelected.booleanValue()) {
                g2.setColor(new Color(0, 160, 0));
            } else {
                g2.setColor(Color.black);
            }
            int h = this.getHeight() - 10;
            g2.fillOval(10, 4, h, h);
            g2.setColor(Color.WHITE);
            g2.setFont(new Font(this.getFont().getName(), 1, PosUIManager.getDefaultFontSize() + 8));
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(KitchenTicketView.this.getKey(), g2);
            int x = (h + 10 - (int)r.getWidth() + 10) / 2;
            int y = (h - (int)r.getHeight()) / 2 + fm.getAscent();
            g2.drawString(KitchenTicketView.this.getKey(), x, y + 2);
            g2.setFont(this.getFont());
            g2.setBackground(color1);
            super.paintComponent(g2);
        }

        public Boolean isKeySelected() {
            return this.keySelected;
        }

        public void setKeySelected(Boolean keySelected) {
            this.keySelected = keySelected;
            KitchenTicketView.this.setSelectedBorder(keySelected);
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KitchenTicketView.this.kitchenTicketContainerView.isDispatchMode()) {
                KitchenTicketView.this.kitchenTicketContainerView.dispatch(KitchenTicketView.this);
            } else {
                KitchenTicketView.this.kitchenTicketContainerView.bump(KitchenTicketView.this);
            }
        }
    }

    class KitchenTicketTableModel
    extends ListTableModel<KitchenTicketItem> {
        KitchenTicketTableModel(List<KitchenTicketItem> list) {
            super(new String[]{"", ""}, list);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && KitchenTicketView.this.showItemBump;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            KitchenTicketItem ticketItem = (KitchenTicketItem)this.getRowData(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (ticketItem.isModifierItem().booleanValue()) {
                        return "      " + ticketItem.getMenuItemNameDisplay();
                    }
                    return ticketItem.getMenuItemNameDisplay();
                }
                case 1: {
                    return ticketItem.isVoided() != false || !KitchenTicketView.this.showItemBump ? "" : POSConstants.BUMP;
                }
            }
            return null;
        }
    }

    private class KitchenTicketTableCellRenderer
    extends DefaultTableCellRenderer {
        MultiLineTableCellRenderer multiLineTableCellRenderer = new MultiLineTableCellRenderer();

        KitchenTicketTableCellRenderer() {
            int verticalGap = PosUIManager.getSize(5);
            int horizontalGap = PosUIManager.getSize(2);
            this.multiLineTableCellRenderer.setBorder(new EmptyBorder(verticalGap, horizontalGap, verticalGap, horizontalGap));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            KitchenTicketItem ticketItem = (KitchenTicketItem)KitchenTicketView.this.tableModel.getRowData(row);
            Component rendererComponent = null;
            rendererComponent = column == 0 ? this.multiLineTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setBackground(KitchenTicketView.this.cellDefaultBackgroundColor);
            rendererComponent.setForeground(KitchenTicketView.this.cellDefaultTextColor);
            if (ticketItem.isVoided().booleanValue()) {
                JComponent label = (JComponent)rendererComponent;
                if (column == 0) {
                    ((MultiLineTableCellRenderer)label).setText("*** Void *** " + NumberUtil.trimDecilamIfNotNeeded(ticketItem.getQuantity(), true) + "x " + ticketItem.getMenuItemName() + "");
                }
                label.setBackground(Color.red);
                label.setForeground(Color.white);
                return label;
            }
            if (ticketItem != null && ticketItem.getStatus() != null) {
                if (ticketItem.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                    rendererComponent.setBackground(Color.green);
                    rendererComponent.setForeground(Color.black);
                } else {
                    if (ticketItem.isVoided().booleanValue() || ticketItem.getStatus().equalsIgnoreCase(KitchenStatus.VOID.name())) {
                        JLabel label = (JLabel)rendererComponent;
                        if (column == 0) {
                            label.setText("<html><strike>" + ticketItem.getMenuItemName() + "</strike></html>");
                        }
                        label.setBackground(new Color(128, 0, 128));
                        label.setForeground(Color.white);
                        return label;
                    }
                    rendererComponent.setBackground(KitchenTicketView.this.cellDefaultBackgroundColor);
                    rendererComponent.setForeground(KitchenTicketView.this.cellDefaultTextColor);
                }
            }
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(false);
            if (column == 1 && (ticketItem.isModifierItem().booleanValue() || ticketItem.isCookingInstruction().booleanValue() || ticketItem.isVoided().booleanValue() || KitchenStatus.BUMP.name().equals(ticketItem.getStatus()))) {
                jLabel.setText("");
                return jLabel;
            }
            return rendererComponent;
        }
    }

    private class BumpAction
    extends AbstractAction {
        private BumpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = Integer.parseInt(e.getActionCommand());
            KitchenTicketItem ticketItem = (KitchenTicketItem)KitchenTicketView.this.tableModel.getRowData(row);
            if (ticketItem.isInformationOnly() || ticketItem.isVoided().booleanValue() || ticketItem.getStatus().equals(KitchenStatus.BUMP.name())) {
                return;
            }
            KitchenTicketView.this.statusSelector.setTicketItem(ticketItem);
            KitchenTicketView.this.statusSelector.setSize(PosUIManager.getSize(350, 150));
            KitchenTicketView.this.statusSelector.setLocationRelativeTo(KitchenTicketView.this);
            KitchenTicketView.this.statusSelector.setVisible(true);
            KitchenTicketView.this.tableModel.fireTableRowsUpdated(row, row);
        }
    }

    private class BumpColumnRenderer
    extends KichenButtonColumn {
        JLabel label;
        Font font;

        private BumpColumnRenderer(JTable table, Action action, int column) {
            super(table, action, column);
            this.label = new JLabel();
            this.font = this.getFont().deriveFont(1, PosUIManager.getDefaultFontSize() + 3);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            KitchenTicketItem ticketItem = (KitchenTicketItem)KitchenTicketView.this.tableModel.getRowData(row);
            if (ticketItem.isModifierItem().booleanValue() || ticketItem.isInformationOnly() || ticketItem.isVoided().booleanValue()) {
                this.label.setText("X");
                this.label.setBackground(Color.black);
                return this.label;
            }
            if (KitchenStatus.BUMP.name().equals(ticketItem.getStatus())) {
                this.label.setText("");
                this.label.setBackground(Color.green);
                this.label.setIcon(KitchenTicketView.this.checkMark);
                return this.label;
            }
            if (ticketItem.getQuantity() <= 0.0) {
                this.label.setText("X");
                this.label.setBackground(Color.black);
                this.label.setIcon(null);
                return this.label;
            }
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setFont(this.font);
            return rendererComponent;
        }
    }
}

