/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ImageComponent;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class LineDisplayWindow
extends JFrame
implements TicketEditListener,
WindowListener {
    private static final String POSY = "bwy";
    private static final String POSX = "bwx";
    private static final String WINDOW_HEIGHT = "bwheight";
    private static final String WINDOW_WIDTH = "bwwidth";
    public static final String VIEW_NAME = "KD";
    private ImageComponent lblTicketImage;
    private JLabel lblTitle;
    private JLabel lblTicketPrice;
    private JLabel lblTicketPriceValue;
    private JLabel lblTotalTicketPrice;
    private JLabel lblTotalTicketPriceValue;
    private static LineDisplayWindow instance;
    private JPanel rightTicketInfoPanel;
    private JLabel lblQuantity;
    private JLabel lblQuantityValue;
    private JLabel lblDot;
    private JLabel lblUnitPrice;
    private JLabel lblUnitPriceValue;
    private JPanel rightPanel;
    private TicketViewerTable ticketViewerTable = new TicketViewerTable(null, 0, 2);
    private Store store;
    private boolean isShowItemImage;
    private boolean isShowSlideShow;
    private boolean isShowItemImageWithSlideShow;
    private Timer slideShowTimer;
    private JLabel lblDate;
    private JPanel topTitlePanel;
    private JPanel bottomTicketInfoPanel;
    private JLabel lblTotalAmnt;
    private JLabel lblGratuityAmnt;
    private JLabel lblDiscountAmnt;
    private JLabel lblTaxAmnt;
    private JLabel lblSubTotalAmnt;
    private PosScrollPane ticketScrollPane;
    private PaginatedTableModel imageGalleryModel;
    private JLabel lblToken;
    private JSeparator separator1;
    private JSeparator separator2;

    public LineDisplayWindow() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.ticketViewerTable.setModel(new TicketViewerTableModel(this.ticketViewerTable));
        this.ticketViewerTable.setShowGrid(false);
        this.ticketViewerTable.setFont(this.ticketViewerTable.getFont().deriveFont((float)PosUIManager.getFontSize(18)));
        TableColumnModel columnModel = this.ticketViewerTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(PosUIManager.getSize(250));
        this.initComponents();
        this.positionWindow();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setTitle(Application.getTitle() + "- " + Messages.getString("LineDisplayWindow.1"));
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        OrderView.getInstance().getOrderController().addTicketUpdateListener(this);
        this.initData();
        this.updateView();
    }

    private void initData() {
        this.imageGalleryModel = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        };
        this.imageGalleryModel.setRows(new ArrayList());
        this.imageGalleryModel.setPageSize(1);
        this.imageGalleryModel.setNumRows(SlideShowImageDAO.getInstance().rowCount());
    }

    private void updateView() {
        this.store = DataProvider.get().getStore();
        int displayOption = this.store.getCustomerMonitorDisplayOption();
        switch (displayOption) {
            case 0: {
                this.isShowItemImage = true;
                break;
            }
            case 1: {
                this.isShowSlideShow = true;
                break;
            }
            case 2: {
                this.isShowItemImageWithSlideShow = true;
                break;
            }
        }
        this.doShowSlideShow();
        this.lblDate.setText(DateUtil.getOnlyFormattedDate(new Date()));
        this.lblTitle.setText(this.store.getName());
    }

    private void doShowSlideShow() {
        if (!this.isShowSlideShow && !this.isShowItemImageWithSlideShow) {
            return;
        }
        int slideShowDuration = this.store.getCustomerMonitorDisplaySlideDuration();
        this.slideShowTimer = new Timer(slideShowDuration * 1000, new ImageUpdateTask());
        this.slideShowTimer.setInitialDelay(0);
        this.slideShowTimer.start();
    }

    public static LineDisplayWindow getInstance() {
        if (instance == null) {
            instance = new LineDisplayWindow();
        }
        return instance;
    }

    private void initComponents() {
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setOpaque(true);
        centerPanel.setBackground(Color.WHITE);
        this.getContentPane().add(centerPanel);
        JPanel leftImagePanel = new JPanel(new BorderLayout(5, 5));
        leftImagePanel.setOpaque(true);
        leftImagePanel.setBackground(Color.WHITE);
        leftImagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder(Color.BLACK, 5, true)));
        this.lblTicketImage = new ImageComponent();
        leftImagePanel.add((Component)this.lblTicketImage, "Center");
        centerPanel.add((Component)leftImagePanel, "Center");
        this.rightPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.rightPanel.setOpaque(true);
        this.rightPanel.setBackground(Color.WHITE);
        this.rightTicketInfoPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.rightTicketInfoPanel.setOpaque(false);
        this.rightTicketInfoPanel.setPreferredSize(PosUIManager.getSize(500, 750));
        this.topTitlePanel = new JPanel((LayoutManager)new MigLayout("fillx, center"));
        this.bottomTicketInfoPanel = new JPanel((LayoutManager)new MigLayout("fillx, center, ins 10 10 10 10", "[][right]", ""));
        this.bottomTicketInfoPanel.setOpaque(true);
        this.bottomTicketInfoPanel.setBackground(Color.WHITE);
        JLabel lblSubTotalTxt = new JLabel("SubTotal");
        this.lblSubTotalAmnt = new JLabel();
        JLabel lblTaxTxt = new JLabel("Tax");
        this.lblTaxAmnt = new JLabel();
        JLabel lblDiscountTxt = new JLabel("Discount");
        this.lblDiscountAmnt = new JLabel();
        JLabel lblGratuityTxt = new JLabel("Gratuity");
        this.lblGratuityAmnt = new JLabel();
        JLabel lblTotalTxt = new JLabel("Total");
        this.lblTotalAmnt = new JLabel();
        this.bottomTicketInfoPanel.add(lblSubTotalTxt);
        this.bottomTicketInfoPanel.add((Component)this.lblSubTotalAmnt, "wrap");
        this.bottomTicketInfoPanel.add(lblTaxTxt);
        this.bottomTicketInfoPanel.add((Component)this.lblTaxAmnt, "wrap");
        this.bottomTicketInfoPanel.add(lblDiscountTxt);
        this.bottomTicketInfoPanel.add((Component)this.lblDiscountAmnt, "wrap");
        this.bottomTicketInfoPanel.add(lblGratuityTxt);
        this.bottomTicketInfoPanel.add((Component)this.lblGratuityAmnt, "wrap");
        this.bottomTicketInfoPanel.add(lblTotalTxt);
        this.bottomTicketInfoPanel.add((Component)this.lblTotalAmnt, "wrap");
        this.separator1 = new JSeparator(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                for (int x = 0; x < 640; x += 15) {
                    g.drawLine(x, 0, x + 10, 0);
                }
            }
        };
        this.separator2 = new JSeparator(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                for (int x = 0; x < 640; x += 15) {
                    g.drawLine(x, 0, x + 10, 0);
                }
            }
        };
        this.rightPanel.add((Component)this.topTitlePanel, "grow, wrap");
        this.rightPanel.add((Component)this.separator1, "center, grow, wrap");
        this.rightPanel.add((Component)this.rightTicketInfoPanel, "growx, wrap");
        this.rightPanel.add((Component)this.separator2, "center, grow, wrap");
        this.rightPanel.add((Component)this.bottomTicketInfoPanel, "grow");
        int titleFontSizeToUse = 48;
        int otherFontSizeToUse = 20;
        int totalFontSizeToUse = 32;
        this.lblTitle = new JLabel();
        Font fontTicketNameValue = this.lblTitle.getFont();
        this.lblTitle.setFont(new Font(fontTicketNameValue.getName(), 1, titleFontSizeToUse));
        this.lblToken = new JLabel();
        this.lblTicketPrice = new JLabel(Messages.getString("LineDisplayWindow.6"));
        Font fontTicketPrice = this.lblTicketPrice.getFont();
        this.lblTicketPrice.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblUnitPrice = new JLabel(Messages.getString("LineDisplayWindow.7"));
        this.lblUnitPrice.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblUnitPriceValue = new JLabel();
        this.lblUnitPriceValue.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblTicketPriceValue = new JLabel();
        this.lblTicketPriceValue.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblQuantity = new JLabel(Messages.getString("LineDisplayWindow.8"));
        this.lblQuantity.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblQuantityValue = new JLabel();
        this.lblQuantityValue.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblDot = new JLabel();
        this.lblDot.setFont(new Font(fontTicketPrice.getName(), 1, otherFontSizeToUse));
        this.lblDot.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.BLACK));
        this.lblTotalTicketPrice = new JLabel(Messages.getString("LineDisplayWindow.10"));
        this.lblTotalTicketPrice.setFont(new Font(fontTicketPrice.getName(), 1, totalFontSizeToUse));
        this.lblTotalTicketPriceValue = new JLabel();
        this.lblTotalTicketPriceValue.setFont(new Font(fontTicketPrice.getName(), 1, totalFontSizeToUse));
        this.ticketViewerTable.setOpaque(true);
        this.ticketViewerTable.setBackground(Color.WHITE);
        this.ticketViewerTable.setTableHeader(null);
        this.ticketViewerTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ticketViewerTable.setRowSelectionAllowed(false);
        this.ticketViewerTable.setRowHeight(30);
        this.ticketScrollPane = new PosScrollPane(this.ticketViewerTable);
        this.ticketScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ticketScrollPane.getViewport().setBorder(null);
        this.ticketScrollPane.setOpaque(true);
        this.ticketScrollPane.getViewport().setOpaque(true);
        this.ticketScrollPane.getViewport().setBackground(Color.WHITE);
        this.ticketScrollPane.setBackground(Color.WHITE);
        this.ticketScrollPane.setHorizontalScrollBarPolicy(31);
        this.ticketScrollPane.setVerticalScrollBarPolicy(20);
        this.ticketScrollPane.setPreferredSize(PosUIManager.getSize(180, 200));
        this.rightTicketInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rightTicketInfoPanel.add((Component)this.ticketScrollPane, "grow");
        this.lblDate = new JLabel();
        this.topTitlePanel.setOpaque(true);
        this.topTitlePanel.setBackground(Color.WHITE);
        this.topTitlePanel.add((Component)this.lblDate, "center, wrap");
        this.topTitlePanel.add((Component)this.lblTitle, "center, wrap");
        this.topTitlePanel.add((Component)this.lblToken, "center, wrap");
        centerPanel.add((Component)this.rightPanel, "East");
        this.lblDate.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        lblSubTotalTxt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblSubTotalAmnt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        lblTaxTxt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblTaxAmnt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        lblDiscountTxt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblDiscountAmnt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        lblGratuityTxt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblGratuityAmnt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        lblTotalTxt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblTotalAmnt.setFont(new Font(fontTicketPrice.getName(), 0, otherFontSizeToUse));
        this.lblToken.setFont(new Font(fontTicketPrice.getName(), 1, totalFontSizeToUse));
        this.lblToken.setForeground(Color.RED);
        lblSubTotalTxt.setForeground(Color.RED);
        this.lblSubTotalAmnt.setForeground(Color.RED);
        lblTaxTxt.setForeground(Color.RED);
        this.lblTaxAmnt.setForeground(Color.RED);
        lblDiscountTxt.setForeground(Color.RED);
        this.lblDiscountAmnt.setForeground(Color.RED);
        lblGratuityTxt.setForeground(Color.RED);
        this.lblGratuityAmnt.setForeground(Color.RED);
        lblTotalTxt.setForeground(Color.RED);
        this.lblTotalAmnt.setForeground(Color.RED);
    }

    private void saveSizeAndLocation() {
        AppConfig.putInt(WINDOW_WIDTH, this.getWidth());
        AppConfig.putInt(WINDOW_HEIGHT, this.getHeight());
        AppConfig.putInt(POSX, this.getX());
        AppConfig.putInt(POSY, this.getY());
    }

    private void positionWindow() {
        int width = AppConfig.getInt(WINDOW_WIDTH, 900);
        int height = AppConfig.getInt(WINDOW_HEIGHT, 650);
        this.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width - width >> 1;
        int y = screenSize.height - height >> 1;
        x = AppConfig.getInt(POSX, x);
        y = AppConfig.getInt(POSY, y);
        this.setLocation(x, y);
    }

    @Override
    public void itemAdded(final Ticket ticket, final TicketItem item) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MenuItem menuItem = item.getMenuItem();
                ImageIcon icon = menuItem.getImage();
                LineDisplayWindow.this.ticketViewerTable.setTicket(ticket);
                LineDisplayWindow.this.ticketViewerTable.scrollLast();
                if (LineDisplayWindow.this.isShowItemImage || LineDisplayWindow.this.isShowItemImageWithSlideShow) {
                    if (icon == null) {
                        LineDisplayWindow.this.setImage(null);
                    } else {
                        String imageId = menuItem.getImageId();
                        ImageResource imageResource = ImageResourceDAO.getInstance().get(imageId);
                        Image image = imageResource.getImage();
                        LineDisplayWindow.this.setImage(image);
                    }
                }
                LineDisplayWindow.this.lblSubTotalAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getSubtotalAmount()));
                LineDisplayWindow.this.lblTaxAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getTaxAmount()));
                LineDisplayWindow.this.lblDiscountAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getDiscountAmount()));
                LineDisplayWindow.this.lblGratuityAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getGratuityAmount()));
                LineDisplayWindow.this.lblTotalAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getTotalAmount()));
            }
        }).start();
    }

    @Override
    public void ticketEditingStart(final Ticket ticket) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (LineDisplayWindow.this.isShowItemImage || LineDisplayWindow.this.isShowItemImageWithSlideShow) {
                    LineDisplayWindow.this.slideShowTimer.stop();
                }
                if (ticket.getId() == null) {
                    LineDisplayWindow.this.lblToken.setText("New Ticket");
                } else {
                    LineDisplayWindow.this.lblToken.setText("Token# " + ticket.getTokenNo());
                }
                LineDisplayWindow.this.ticketViewerTable.setTicket(ticket);
                LineDisplayWindow.this.ticketViewerTable.setVisible(true);
                LineDisplayWindow.this.lblSubTotalAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getSubtotalAmount()));
                LineDisplayWindow.this.lblTaxAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getTaxAmount()));
                LineDisplayWindow.this.lblDiscountAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getDiscountAmount()));
                LineDisplayWindow.this.lblGratuityAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getGratuityAmount()));
                LineDisplayWindow.this.lblTotalAmnt.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(ticket.getTotalAmount()));
            }
        }).start();
    }

    @Override
    public void itemRemoved(TicketItem item) {
    }

    @Override
    public void ticketEditingFinish(Ticket ticket) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!LineDisplayWindow.this.slideShowTimer.isRunning()) {
                    LineDisplayWindow.this.slideShowTimer.restart();
                }
                LineDisplayWindow.this.lblToken.setText("");
                LineDisplayWindow.this.ticketViewerTable.setVisible(false);
                LineDisplayWindow.this.lblSubTotalAmnt.setText("");
                LineDisplayWindow.this.lblTaxAmnt.setText("");
                LineDisplayWindow.this.lblDiscountAmnt.setText("");
                LineDisplayWindow.this.lblGratuityAmnt.setText("");
                LineDisplayWindow.this.lblTotalAmnt.setText("");
            }
        }).start();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        OrderView.getInstance().getOrderController().removeTicketUpdateListener(this);
        this.saveSizeAndLocation();
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.setVisible(false);
        this.slideShowTimer.stop();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void openFullScreen() {
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        this.setResizable(true);
        this.setVisible(true);
    }

    private void setImage(Image image) {
        if (image == null) {
            this.lblTicketImage.setImage(image);
            return;
        }
        int width = image.getWidth(null) > this.getWidth() ? this.getWidth() : image.getWidth(null);
        int height = image.getHeight(null) > this.getHeight() ? this.getHeight() : image.getHeight(null);
        this.lblTicketImage.setImage(image, width, height);
        this.lblTicketImage.revalidate();
        this.lblTicketImage.repaint();
    }

    class LineDisplayTableModel
    extends TicketViewerTableModel {
        public LineDisplayTableModel(TicketViewerTable table) {
            super(table);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        protected void calculateRows() {
            if (this.ticket == null) {
                return;
            }
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            if (ticketItems != null) {
                int row = 0;
                this.tableRows.clear();
                for (int i = ticketItems.size() - 1; i >= 0; --i) {
                    this.tableRows.put(String.valueOf(row++), ticketItems.get(i));
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ITicketItem ticketItem = (ITicketItem)this.tableRows.get(String.valueOf(rowIndex));
            if (ticketItem == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ticketItem.getNameDisplay();
                }
                case 1: {
                    return NumberUtil.getCurrencyFormat(ticketItem.getSubTotalAmountDisplay());
                }
            }
            return null;
        }
    }

    private class ImageUpdateTask
    implements ActionListener {
        private ImageUpdateTask() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.imageGalleryModel);
                if (LineDisplayWindow.this.imageGalleryModel.getRows() == null) {
                    LineDisplayWindow.this.slideShowTimer.stop();
                    return;
                }
                if (LineDisplayWindow.this.imageGalleryModel.getRows().isEmpty()) {
                    LineDisplayWindow.this.imageGalleryModel.setCurrentRowIndex(0);
                    SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.imageGalleryModel);
                }
                ImageResource imageResource = (ImageResource)LineDisplayWindow.this.imageGalleryModel.getRowData(0);
                LineDisplayWindow.this.setImage(imageResource.getImage());
                if (!LineDisplayWindow.this.imageGalleryModel.hasNext()) {
                    LineDisplayWindow.this.imageGalleryModel.setCurrentRowIndex(0);
                } else {
                    LineDisplayWindow.this.imageGalleryModel.setCurrentRowIndex(LineDisplayWindow.this.imageGalleryModel.getCurrentRowIndex() + 1);
                }
                LineDisplayWindow.this.slideShowTimer.start();
            }
            catch (Exception e2) {
                PosLog.error(this.getClass(), e2);
            }
        }
    }
}

