/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem;

import com.floreantpos.Messages;
import com.floreantpos.model.ImageResource;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import net.miginfocom.swing.MigLayout;

public class ButtonStylePanel
extends TransparentPanel {
    private JCheckBox cbShowTextWithImage;
    private JButton btnButtonColor;
    private JButton btnTextColor;
    private JLabel lblImagePreview;
    private ImageResource imageResource;
    private JLabel lblSortOrder;
    private IntegerTextField tfSortOrder;

    public ButtonStylePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3, insets 10", "[][]100[][][][]", "[][][center][][][]"));
        this.cbShowTextWithImage = new JCheckBox(Messages.getString("MenuItemForm.40"));
        JLabel lblImage = new JLabel(Messages.getString("MenuItemForm.28"));
        this.lblImagePreview = new JLabel("");
        JButton btnClearImage = new JButton(Messages.getString("MenuItemForm.34"));
        JButton btnSelectImage = new JButton("...");
        this.btnButtonColor = new JButton();
        JLabel lblTextColor = new JLabel(Messages.getString("MenuItemForm.lblTextColor.text"));
        this.btnTextColor = new JButton(Messages.getString("MenuItemForm.SAMPLE_TEXT"));
        JLabel lblButtonColor = new JLabel();
        lblImage.setHorizontalAlignment(11);
        this.cbShowTextWithImage.setActionCommand(Messages.getString("MenuItemForm.41"));
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(new EtchedBorder(1, null, null));
        this.lblImagePreview.setPreferredSize(PosUIManager.getSize(200, 200));
        this.btnButtonColor.setPreferredSize(new Dimension(228, 40));
        this.lblSortOrder = new JLabel("Sort Order");
        this.tfSortOrder = new IntegerTextField();
        this.add((Component)this.lblSortOrder, "cell 0 0,right");
        this.add((Component)this.tfSortOrder, "cell 1 0,grow, w 220!");
        this.add((Component)lblImage, "cell 0 1,right");
        this.add((Component)this.lblImagePreview, "cell 1 1, grow");
        this.add((Component)btnClearImage, "cell  1 1");
        this.add((Component)btnSelectImage, "cell 1 1");
        this.add((Component)lblButtonColor, "cell 0 2,right");
        this.add((Component)this.btnButtonColor, "cell 1 2");
        this.add((Component)lblTextColor, "cell 0 3,right");
        this.add((Component)this.btnTextColor, "cell 1 3");
        this.add((Component)this.cbShowTextWithImage, "cell 1 4");
        this.btnTextColor.setPreferredSize(new Dimension(228, 50));
        btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonStylePanel.this.doSelectImageFile();
            }
        });
        btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonStylePanel.this.doClearImage();
            }
        });
        this.btnButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemForm.42"), ButtonStylePanel.this.btnButtonColor.getBackground());
                ButtonStylePanel.this.btnButtonColor.setBackground(color);
                ButtonStylePanel.this.btnTextColor.setBackground(color);
            }
        });
        this.btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemForm.43"), ButtonStylePanel.this.btnTextColor.getForeground());
                ButtonStylePanel.this.btnTextColor.setForeground(color);
            }
        });
        this.lblSortOrder.setVisible(true);
        this.tfSortOrder.setVisible(true);
    }

    public void setSortOrderVisibility(boolean updateSortOrder) {
        this.lblSortOrder.setVisible(updateSortOrder);
        this.tfSortOrder.setVisible(updateSortOrder);
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle("Image Gallery");
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(true);
        dialog.setSelectBtnVisible(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(200, 200));
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    public boolean isShowTextWithImage() {
        return this.cbShowTextWithImage.isSelected();
    }

    public void setShowTextWithImage(boolean isSelected) {
        this.cbShowTextWithImage.setSelected(isSelected);
    }

    public Color getButtonColor() {
        return this.btnButtonColor.getBackground();
    }

    public int getButtonColorCode() {
        return this.btnButtonColor.getBackground().getRGB();
    }

    public Color getTextColor() {
        return this.btnTextColor.getForeground();
    }

    public int getTextColorCode() {
        return this.btnTextColor.getForeground().getRGB();
    }

    public void setButtonColor(Color color) {
        this.btnButtonColor.setBackground(color);
    }

    public void setTextColor(Color color) {
        this.btnTextColor.setBackground(color);
    }

    public void setTextForegroundColor(Color color) {
        this.btnTextColor.setForeground(color);
    }

    public String getImageResourceId() {
        if (this.imageResource != null) {
            return this.imageResource.getId();
        }
        return "";
    }

    public ImageResource getImageResource() {
        return this.imageResource;
    }

    public void setImageResource(ImageResource imageResource) {
        this.imageResource = imageResource;
        if (imageResource != null) {
            this.lblImagePreview.setIcon(imageResource.getAsIcon());
        }
    }

    public Integer getSortOrder() {
        return this.tfSortOrder.getInteger();
    }

    public void setSortOrder(int sortOrder) {
        this.tfSortOrder.setText(String.valueOf(sortOrder));
    }
}

