/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem.variant;

import com.floreantpos.POSConstants;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.menuitem.InventoryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class VariantForm
extends BeanEditor<MenuItem> {
    private ButtonStylePanel buttonStylePanel;
    private InventoryPanel inventoryPanel;

    public VariantForm(MenuItem menuItem) {
        this.initComponents();
        this.setBean(menuItem);
        this.inventoryPanel.setMenuItem(menuItem);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JTabbedPane tab = new JTabbedPane();
        this.buttonStylePanel = new ButtonStylePanel();
        this.buttonStylePanel.setSortOrderVisibility(true);
        this.inventoryPanel = new InventoryPanel((MenuItem)this.getBean());
        tab.addTab("Button Style", this.buttonStylePanel);
        tab.addTab("Inventory", this.inventoryPanel);
        this.add((Component)tab, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            if (menuItem.getId() == null) {
                menuItemDAO.save(menuItem);
            } else {
                menuItemDAO.saveOrUpdate(menuItem);
            }
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color buttonColor;
        MenuItem menuItem = (MenuItem)this.getBean();
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.buttonStylePanel.setImageResource(imageResource);
        }
        if ((buttonColor = menuItem.getButtonColor()) != null) {
            this.buttonStylePanel.setButtonColor(buttonColor);
            this.buttonStylePanel.setTextColor(buttonColor);
        }
        if (menuItem.getTextColor() != null) {
            this.buttonStylePanel.setTextForegroundColor(menuItem.getTextColor());
        }
        this.buttonStylePanel.setSortOrder(menuItem.getSortOrder());
        this.inventoryPanel.setSku(menuItem.getSku());
        this.inventoryPanel.setReOrderLevel(menuItem.getReorderLevel());
        this.inventoryPanel.setReplenishLevel(menuItem.getReplenishLevel());
        this.inventoryPanel.setCbDisableStockCount(menuItem.isDisableWhenStockAmountIsZero());
    }

    @Override
    public boolean updateModel() {
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setReorderLevel(this.inventoryPanel.getReOrderLevel());
        menuItem.setReplenishLevel(this.inventoryPanel.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.inventoryPanel.isCbDisableStockCount());
        menuItem.setShowImageOnly(this.buttonStylePanel.isShowTextWithImage());
        menuItem.setButtonColor(this.buttonStylePanel.getButtonColor());
        menuItem.setButtonColorCode(this.buttonStylePanel.getButtonColorCode());
        menuItem.setTextColor(this.buttonStylePanel.getTextColor());
        menuItem.setTextColorCode(this.buttonStylePanel.getTextColorCode());
        menuItem.setImageId(this.buttonStylePanel.getImageResourceId());
        menuItem.setSortOrder(this.buttonStylePanel.getSortOrder());
        menuItem.setSku(this.inventoryPanel.getSku());
        return true;
    }

    @Override
    public String getDisplayText() {
        return "Variant Edit Form";
    }
}

