/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ComboGroupItemSelectionDialog
extends POSDialog
implements ActionListener {
    private MenuItemSelectionView menuSelectorPanel;
    private IntegerTextField tfMaxQuantity = new IntegerTextField(10);
    private JLabel lblMinQuantity = new JLabel("Min Quantity");
    private JLabel lblMaxQuantity = new JLabel("Max Quantity");
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private FixedLengthTextField tfComboGroupName = new FixedLengthTextField();
    private ComboGroup comboGroup;
    private MenuItem menuItem;
    private boolean editMode;

    public ComboGroupItemSelectionDialog(MenuItem menuItem, ComboGroup comboGroup) {
        this(menuItem, comboGroup, false);
    }

    public ComboGroupItemSelectionDialog(MenuItem menuItem, ComboGroup comboGroup, boolean editMode) {
        super(POSUtil.getFocusedWindow(), "");
        this.comboGroup = comboGroup;
        this.menuItem = menuItem;
        this.editMode = editMode;
        this.init();
        this.tfComboGroupName.setText(comboGroup.getName());
        this.tfMaxQuantity.setText(String.valueOf(comboGroup.getMaxQuantity()));
        this.tfMinQuantity.setText(String.valueOf(comboGroup.getMinQuantity()));
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setIconImage(Application.getPosWindow().getIconImage());
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Select item");
        this.add((Component)titlePanel, "North");
        this.menuSelectorPanel = new MenuItemSelectionView(this.comboGroup.getItems(), false);
        this.menuSelectorPanel.setParentMenuItem(this.menuItem, this.editMode);
        this.menuSelectorPanel.setEnableSearch(false);
        contentPane.add(new JLabel("Group Name"));
        contentPane.add((Component)this.tfComboGroupName, "grow,wrap");
        contentPane.add(this.lblMinQuantity);
        contentPane.add((Component)this.tfMinQuantity, "grow,wrap");
        contentPane.add(this.lblMaxQuantity);
        contentPane.add((Component)this.tfMaxQuantity, "grow,wrap");
        contentPane.add((Component)this.menuSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton(POSConstants.OK);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
        this.pack();
    }

    public void setQuantity(Integer quantity) {
        this.tfMaxQuantity.setText(String.valueOf(quantity));
    }

    private void doOk() {
        int maxQuantity;
        List<MenuItem> menuItems = this.menuSelectorPanel.getSelectedMenuItemList();
        if (menuItems == null || menuItems.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu item");
            return;
        }
        String groupName = this.tfComboGroupName.getText();
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter group name.");
            return;
        }
        int minQuantity = this.tfMinQuantity.getInteger();
        if (minQuantity > (maxQuantity = this.tfMaxQuantity.getInteger())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Min quantity cannot be greater than max.");
            return;
        }
        if (maxQuantity == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Max quantity cannot be zero!");
            return;
        }
        if (this.menuItem.getComboGroups() != null) {
            for (ComboGroup comboGroup : this.menuItem.getComboGroups()) {
                if (comboGroup.getName().equals(groupName) || !comboGroup.getName().equals(groupName)) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Group name already exists.");
                return;
            }
        }
        this.comboGroup.setName(groupName);
        this.comboGroup.setMinQuantity(minQuantity);
        this.comboGroup.setMaxQuantity(maxQuantity);
        this.comboGroup.setItems(menuItems);
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }
}

