/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class CouponForm
extends BeanEditor
implements ItemListener {
    private JPanel contentPane;
    private JPanel itemPanel;
    private FixedLengthTextField tfCouponName;
    private FixedLengthTextField tfBarcode;
    private JComboBox cbQualificationType;
    private JComboBox cbCouponType;
    private DoubleTextField tfCouponValue;
    private JCheckBox chkEnabled;
    private JCheckBox chkModifiable;
    private JCheckBox chkAutoApply;
    private JCheckBox chkNeverExpire;
    private JXDatePicker dpExperation;
    private JLabel lblMinimum;
    private DoubleTextField tfMinimumQua;
    private DoubleTextField tfMaxUnit = new DoubleTextField();
    private JScrollPane itemScrollPane;
    private List<MenuItem> addedItems = new ArrayList<MenuItem>();
    private JTextField tfSearch;
    private JPanel itemSearchPanel;
    private BeanTableModel itemModel;

    public CouponForm() {
        this(new Discount());
    }

    public CouponForm(Discount coupon) {
        this.initializeComponent();
        this.cbCouponType.setModel(new DefaultComboBoxModel<String>(Discount.COUPON_TYPE_NAMES));
        this.cbCouponType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CouponForm.this.cbCouponType.getSelectedItem() == Discount.COUPON_TYPE_NAMES[2]) {
                    CouponForm.this.cbQualificationType.setEnabled(false);
                    CouponForm.this.tfMinimumQua.setEnabled(false);
                    CouponForm.this.tfMaxUnit.setEnabled(false);
                } else {
                    CouponForm.this.cbQualificationType.setEnabled(true);
                    CouponForm.this.tfMinimumQua.setEnabled(true);
                    CouponForm.this.tfMaxUnit.setEnabled(true);
                }
            }
        });
        this.cbQualificationType.setModel(new DefaultComboBoxModel<String>(Discount.COUPON_QUALIFICATION_NAMES));
        this.cbQualificationType.addItemListener(this);
        this.cbCouponType.addItemListener(this);
        this.setBean(coupon);
    }

    private void initializeComponent() {
        this.setLayout(new BorderLayout(10, 10));
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new MigLayout());
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null));
        this.contentPane.setPreferredSize(new Dimension(400, 0));
        JLabel label1 = new JLabel(Messages.getString("CouponForm.0") + ":");
        JLabel label2 = new JLabel(Messages.getString("CouponForm.9") + ":");
        JLabel label3 = new JLabel(Messages.getString("CouponForm.11") + ":");
        JLabel label4 = new JLabel(Messages.getString("CouponForm.13") + ":");
        JLabel label6 = new JLabel(Messages.getString("CouponForm.12"));
        JLabel label5 = new JLabel(Messages.getString("CouponForm.7"));
        this.lblMinimum = new JLabel(Messages.getString("CouponForm.5"));
        this.tfCouponName = new FixedLengthTextField(120);
        this.tfBarcode = new FixedLengthTextField(120);
        this.cbCouponType = new JComboBox();
        this.cbQualificationType = new JComboBox();
        this.dpExperation = new JXDatePicker();
        this.tfCouponValue = new DoubleTextField();
        this.tfMinimumQua = new DoubleTextField();
        this.chkEnabled = new JCheckBox(POSConstants.ENABLED);
        this.chkModifiable = new JCheckBox("Modifiable Amount");
        this.chkAutoApply = new JCheckBox(Messages.getString("CouponForm.6"));
        this.chkNeverExpire = new JCheckBox(Messages.getString("CouponForm.16"));
        this.contentPane.add(label1);
        this.contentPane.add((Component)this.tfCouponName, "grow, wrap");
        this.contentPane.add(label2);
        this.contentPane.add((Component)this.dpExperation, "grow, wrap");
        this.contentPane.add(label6);
        this.contentPane.add((Component)this.tfBarcode, "grow, wrap");
        this.contentPane.add(label5);
        this.contentPane.add((Component)this.cbQualificationType, "grow, wrap");
        this.contentPane.add(this.lblMinimum);
        this.contentPane.add((Component)this.tfMinimumQua, "grow, wrap");
        this.contentPane.add(new JLabel("Maximum Unit:"));
        this.contentPane.add((Component)this.tfMaxUnit, "grow, wrap");
        this.contentPane.add(label3);
        this.contentPane.add((Component)this.cbCouponType, "grow, wrap");
        this.contentPane.add(label4);
        this.contentPane.add((Component)this.tfCouponValue, "grow, wrap");
        this.contentPane.add(new JLabel(""));
        this.contentPane.add((Component)this.chkEnabled, "wrap");
        this.contentPane.add(new JLabel(""));
        this.contentPane.add((Component)this.chkAutoApply, "wrap");
        this.contentPane.add(new JLabel(""));
        this.contentPane.add((Component)this.chkNeverExpire, "wrap");
        this.contentPane.add(new JLabel(""));
        this.contentPane.add((Component)this.chkModifiable, "wrap");
        this.createItemSearchPanel();
        this.itemPanel = new JPanel(new BorderLayout(10, 10));
        this.itemPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Discounted items");
        this.itemPanel.add((Component)titlePanel, "North");
        this.tfSearch = new JTextField();
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CouponForm.this.doSearchItem();
            }
        });
        JButton btnSearch = new JButton("Search");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CouponForm.this.doSearchItem();
            }
        });
        JTable itemTable = new JTable();
        this.itemModel = new BeanTableModel(MenuItem.class, 2);
        this.itemModel.addColumn("Item name", MenuItem.PROP_NAME);
        this.itemModel.addColumn("Item price", MenuItem.PROP_PRICE);
        itemTable.setModel(this.itemModel);
        itemTable.setRowHeight(30);
        this.itemPanel.add((Component)this.itemSearchPanel, "South");
        this.itemScrollPane = new JScrollPane(itemTable);
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0"));
        centerPanel.add((Component)new JLabel("Search by name"), "split 3");
        centerPanel.add((Component)this.tfSearch, "grow");
        centerPanel.add((Component)btnSearch, "wrap");
        centerPanel.add((Component)this.itemScrollPane, "grow");
        this.itemPanel.add((Component)centerPanel, "Center");
        this.add((Component)this.contentPane, "West");
        this.add((Component)this.itemPanel, "Center");
        this.setPreferredSize(new Dimension(700, 350));
    }

    private void createItemSearchPanel() {
        this.itemSearchPanel = new JPanel();
        this.itemSearchPanel.setLayout((LayoutManager)new MigLayout("ins 0, center"));
        JButton btnAdd = new JButton("ADD/EDIT ITEMS");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CouponForm.this.doOpenItemSelectionDialog();
            }
        });
        this.itemSearchPanel.add(btnAdd);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItem() == Discount.COUPON_QUALIFICATION_NAMES[0]) {
            this.itemPanel.setVisible(true);
        } else if (event.getItem() == Discount.COUPON_TYPE_NAMES[0]) {
            this.chkModifiable.setVisible(true);
        } else if (event.getItem() == Discount.COUPON_TYPE_NAMES[1]) {
            this.chkModifiable.setVisible(false);
        } else {
            this.itemPanel.setVisible(false);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Discount coupon = (Discount)this.getBean();
            DiscountDAO.getInstance().saveOrUpdate(coupon);
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Discount coupon = (Discount)this.getBean();
        if (coupon.getId() == null) {
            this.chkEnabled.setSelected(true);
            this.tfMinimumQua.setText("0");
            this.tfMaxUnit.setText("0");
            this.cbCouponType.setSelectedIndex(1);
            return;
        }
        this.tfCouponName.setText(coupon.getName());
        this.tfMinimumQua.setText(coupon.getMinimumBuy().toString());
        this.tfMaxUnit.setText(coupon.getMaximumOff().toString());
        this.tfCouponValue.setText(String.valueOf(coupon.getValue()));
        this.cbCouponType.setSelectedIndex(coupon.getType());
        this.cbQualificationType.setSelectedIndex(coupon.getQualificationType());
        this.dpExperation.setDate(coupon.getExpiryDate());
        this.tfBarcode.setText(coupon.getBarcode());
        this.chkEnabled.setSelected(coupon.isEnabled());
        this.chkModifiable.setSelected(coupon.isModifiable());
        this.chkAutoApply.setSelected(coupon.isAutoApply());
        this.chkNeverExpire.setSelected(coupon.isNeverExpire());
        if (coupon.getQualificationType() == 0 && coupon.getMenuItems() != null) {
            this.itemModel.setRows(coupon.getMenuItems());
            this.addedItems.addAll(this.itemModel.getRows());
        }
    }

    @Override
    protected boolean updateModel() {
        String name = this.tfCouponName.getText();
        String barcode = this.tfBarcode.getText();
        double couponValue = 0.0;
        couponValue = this.tfCouponValue.getDoubleOrZero();
        double couponMinimumQua = this.tfMinimumQua.getDoubleOrZero();
        double couponMaximunUnit = this.tfMaxUnit.getDoubleOrZero();
        int couponType = this.cbCouponType.getSelectedIndex();
        Date expiryDate = this.dpExperation.getDate();
        boolean enabled = this.chkEnabled.isSelected();
        boolean modifiable = this.chkModifiable.isSelected();
        boolean autoApply = this.chkAutoApply.isSelected();
        boolean neverExpire = this.chkNeverExpire.isSelected();
        int qualificationType = this.cbQualificationType.getSelectedIndex();
        if (name == null || name.trim().equals("")) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.1"));
            return false;
        }
        if (couponValue <= 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.2"));
            return false;
        }
        if (qualificationType == 0 && this.couponValueOverflow()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.10"));
            return false;
        }
        Discount coupon = (Discount)this.getBean();
        coupon.setName(name);
        coupon.setMinimumBuy(couponMinimumQua);
        coupon.setMaximumOff(couponMaximunUnit);
        coupon.setValue(couponValue);
        coupon.setExpiryDate(expiryDate);
        coupon.setBarcode(barcode);
        coupon.setType(couponType);
        coupon.setQualificationType(qualificationType);
        coupon.setEnabled(enabled);
        coupon.setModifiable(modifiable);
        coupon.setAutoApply(autoApply);
        coupon.setNeverExpire(neverExpire);
        if (qualificationType == 0) {
            this.tfSearch.setText("");
            this.doSearchItem();
            if (this.itemModel.getRows() != null && this.itemModel.getRows().size() > 0) {
                coupon.setMenuItems(this.itemModel.getRows());
                coupon.setApplyToAll(false);
            } else {
                coupon.setMenuItems(null);
                coupon.setApplyToAll(true);
            }
        }
        return true;
    }

    private boolean couponValueOverflow() {
        double minimumQua;
        List menuItems = this.itemModel.getRows();
        double couponValue = this.tfCouponValue.getDoubleOrZero();
        if (this.cbCouponType.getSelectedIndex() == 1) {
            couponValue /= 100.0;
        }
        if ((minimumQua = this.tfMinimumQua.getDouble()) > 0.0) {
            for (MenuItem menuItem : menuItems) {
                if (!(couponValue > menuItem.getPrice() * minimumQua)) continue;
                return true;
            }
        } else {
            for (MenuItem menuItem : menuItems) {
                if (!(couponValue > menuItem.getPrice())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDisplayText() {
        Discount coupon = (Discount)this.getBean();
        if (coupon.getId() == null) {
            return Messages.getString("CouponForm.3");
        }
        return Messages.getString("CouponForm.4");
    }

    private void doSearchItem() {
        try {
            String searchTxt = this.tfSearch.getText();
            if (StringUtils.isEmpty((String)searchTxt)) {
                this.itemModel.setRows(this.addedItems);
                return;
            }
            ArrayList<MenuItem> searchItems = new ArrayList<MenuItem>();
            for (MenuItem entry : this.addedItems) {
                String itemName = entry.getName();
                if (!itemName.contains(searchTxt) && !itemName.toLowerCase().contains(searchTxt) && !itemName.toLowerCase().contains(searchTxt.toLowerCase())) continue;
                searchItems.add(entry);
            }
            this.itemModel.setRows(searchItems);
            this.itemModel.fireTableDataChanged();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doOpenItemSelectionDialog() {
        try {
            this.tfSearch.setText("");
            this.doSearchItem();
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(this.itemModel.getRows());
            dialog.setSelectionMode(1);
            dialog.setSize(PosUIManager.getSize(750, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuItem> menuItemList = dialog.getSelectedItems();
            this.itemModel.setRows(menuItemList);
            this.addedItems.clear();
            this.addedItems.addAll(menuItemList);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }
}

