/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CurrencyForm
extends BeanEditor {
    private FixedLengthTextField tfCode;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfSymbol;
    private DoubleTextField tfExchangeRate;
    private DoubleTextField tfTolerance;
    private JCheckBox chkMain;
    private AutoCompletionComboBox cbCurrency;

    public CurrencyForm() {
        this(new Currency());
    }

    public CurrencyForm(Currency currency) {
        this.initComponents();
        this.initData();
        this.setBean(currency);
    }

    private void initData() {
        ComboBoxModel currencyModel = new ComboBoxModel();
        currencyModel.addElement((Object)null);
        currencyModel.setDataList(CurrencyForm.getAllCurrencies());
        this.cbCurrency.setModel(currencyModel);
    }

    public static List<Currency> getAllCurrencies() {
        Set currencies = com.ibm.icu.util.Currency.getAvailableCurrencies();
        ArrayList<Currency> currencyList = new ArrayList<Currency>();
        for (com.ibm.icu.util.Currency ibmCurrency : currencies) {
            Currency currency = new Currency();
            currency.setName(ibmCurrency.getDisplayName());
            currency.setCode(ibmCurrency.getCurrencyCode());
            String symbol = ibmCurrency.getSymbol();
            currency.setSymbol(symbol);
            currencyList.add(currency);
        }
        Collections.sort(currencyList, new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return currencyList;
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JLabel lblCode = new JLabel(Messages.getString("CurrencyForm.1"));
        this.tfCode = new FixedLengthTextField(10);
        JLabel lblName = new JLabel(POSConstants.NAME + ":");
        this.tfName = new FixedLengthTextField();
        JLabel lblExchangeRate = new JLabel(Messages.getString("CurrencyForm.3"));
        this.tfExchangeRate = new DoubleTextField();
        JLabel lblTolerance = new JLabel(Messages.getString("CurrencyForm.4"));
        this.tfTolerance = new DoubleTextField();
        JLabel lblSymbol = new JLabel(Messages.getString("CurrencyForm.5"));
        this.tfSymbol = new FixedLengthTextField(8);
        this.chkMain = new JCheckBox(Messages.getString("CurrencyForm.6"));
        this.cbCurrency = new AutoCompletionComboBox();
        this.cbCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cbCurrency = (JComboBox)e.getSource();
                Currency selectedCurrency = (Currency)cbCurrency.getSelectedItem();
                CurrencyForm.this.tfName.setText(selectedCurrency.getName());
                CurrencyForm.this.tfSymbol.setText(selectedCurrency.getSymbol());
                CurrencyForm.this.tfCode.setText(selectedCurrency.getCode());
                CurrencyForm.this.tfExchangeRate.setText("" + selectedCurrency.getExchangeRate());
                CurrencyForm.this.tfTolerance.setText("" + selectedCurrency.getTolerance());
            }
        });
        contentPanel.add((Component)new JLabel("Currency"), "");
        contentPanel.add((Component)this.cbCurrency, "grow, wrap");
        contentPanel.add((Component)lblName, "");
        contentPanel.add((Component)this.tfName, "grow, wrap");
        contentPanel.add((Component)lblCode, "");
        contentPanel.add((Component)this.tfCode, "grow, wrap");
        contentPanel.add((Component)lblSymbol, "");
        contentPanel.add((Component)this.tfSymbol, "grow, wrap");
        contentPanel.add((Component)lblExchangeRate, "");
        contentPanel.add((Component)this.tfExchangeRate, "grow, wrap");
        contentPanel.add((Component)lblTolerance, "");
        contentPanel.add((Component)this.tfTolerance, "grow, wrap");
        contentPanel.add((Component)this.chkMain, "");
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Currency currency = (Currency)this.getBean();
            CurrencyDAO dao = new CurrencyDAO();
            dao.saveOrUpdate(currency);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Currency currency = (Currency)this.getBean();
        if (currency == null || StringUtils.isEmpty((String)currency.getId())) {
            return;
        }
        ComboBoxModel model = (ComboBoxModel)this.cbCurrency.getModel();
        List dataList = model.getDataList();
        for (Currency currencyOfList : dataList) {
            if (!currencyOfList.getCode().equals(currency.getCode())) continue;
            this.cbCurrency.setSelectedItem((Object)currencyOfList);
        }
        this.tfCode.setText(currency.getCode());
        this.tfName.setText(currency.getName());
        this.tfSymbol.setText(currency.getSymbol());
        this.tfExchangeRate.setText("" + currency.getExchangeRate());
        this.tfTolerance.setText("" + currency.getTolerance());
        this.chkMain.setSelected(currency.isMain());
    }

    @Override
    protected boolean updateModel() {
        Currency currency = (Currency)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.64"));
            return false;
        }
        String code = this.tfCode.getText();
        if (POSUtil.isBlankOrNull(code)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.0"));
            return false;
        }
        String symbol = this.tfSymbol.getText();
        if (POSUtil.isBlankOrNull(symbol)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.65"));
            return false;
        }
        double exchangeRate = this.tfExchangeRate.getDoubleOrZero();
        if (this.chkMain.isSelected() && exchangeRate != 1.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.2"));
            return false;
        }
        currency.setCode(code);
        currency.setName(name);
        currency.setSymbol(symbol);
        currency.setMain(this.chkMain.isSelected());
        if (exchangeRate == 0.0) {
            currency.setExchangeRate(1.0);
        } else {
            currency.setExchangeRate(exchangeRate);
        }
        currency.setTolerance(this.tfTolerance.getDoubleOrZero());
        return true;
    }

    @Override
    public String getDisplayText() {
        Currency currency = (Currency)this.getBean();
        if (currency.getId() == null) {
            return Messages.getString("CurrencyForm.20");
        }
        return Messages.getString("CurrencyForm.21");
    }
}

