/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;

public class MenuItemModifierSpecForm
extends BeanEditor {
    private JLabel lblName;
    private JLabel lblMin;
    private JLabel lblMax;
    private JLabel lblSortOrder;
    private IntegerTextField tfSortOrder = new IntegerTextField();
    private FixedLengthTextField tfName = new FixedLengthTextField(60);
    private JTextArea taInstruction = new JTextArea(new FixedLengthDocument(220));
    private IntegerTextField tfMaxQuantity = new IntegerTextField();
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private JCheckBox chkVisible;
    private JComboBox cbMenuModifierGroup;
    private JCheckBox chkAutoShow;
    private JCheckBox chkJumbToNextGroup;
    private PosButton btnSaveAndAutoBuild;
    private boolean autoBuildSelected;
    private MenuItem menuItem;
    private MenuItemModifierSpec modifierSpec;
    private boolean editMode;

    public MenuItemModifierSpecForm(MenuItemModifierSpec modifierSpec, MenuItem menuItem, boolean editMode) {
        this.menuItem = menuItem;
        this.modifierSpec = modifierSpec;
        this.editMode = editMode;
        this.initComponents();
        this.initList();
        this.setBean(modifierSpec);
    }

    private void initList() {
        List<ModifierGroup> modifierGroups = null;
        modifierGroups = this.menuItem.isPizzaType() != false ? ModifierGroupDAO.getInstance().findPizzaModifierGroups() : ModifierGroupDAO.getInstance().findNormalModifierGroups();
        ComboBoxModel model = new ComboBoxModel(modifierGroups);
        this.cbMenuModifierGroup.setModel(model);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fillx,inset 5 15 5 15", "[][grow]", ""));
        this.lblName = new JLabel(Messages.getString("MenuItemModifierGroupForm.4"));
        this.lblMin = new JLabel(Messages.getString("MenuItemModifierGroupForm.6"));
        this.lblMax = new JLabel(Messages.getString("MenuItemModifierGroupForm.7"));
        this.lblSortOrder = new JLabel("Sort Order");
        this.chkVisible = new JCheckBox("Visible");
        this.chkAutoShow = new JCheckBox("Auto show");
        this.chkJumbToNextGroup = new JCheckBox("Jump to next group");
        this.cbMenuModifierGroup = new JComboBox();
        this.tfName.setColumns(20);
        this.tfMinQuantity.setColumns(10);
        this.tfMaxQuantity.setColumns(10);
        this.tfSortOrder.setColumns(10);
        this.taInstruction.setLineWrap(true);
        this.taInstruction.setRows(4);
        this.tfMinQuantity.setText("1");
        this.tfMaxQuantity.setText("1");
        this.chkVisible.setSelected(true);
        this.btnSaveAndAutoBuild = new PosButton("SAVE and AUTO BUILD PAGES");
        this.btnSaveAndAutoBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MenuItemModifierSpecForm.this.save()) {
                    return;
                }
                MenuItemModifierSpecForm.this.autoBuildSelected = true;
                MenuItemModifierSpecForm.this.editorDialog.dispose();
            }
        });
        JButton btnAddNewGroup = new JButton("...");
        btnAddNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemModifierSpecForm.this.doAddNewModifierGroup();
            }
        });
        contentPanel.add(new JLabel("Group"));
        contentPanel.add((Component)this.cbMenuModifierGroup, "grow");
        contentPanel.add((Component)new JLabel("Instruction"), "newline,aligny top");
        contentPanel.add((Component)new JScrollPane(this.taInstruction), "grow");
        contentPanel.add((Component)this.lblMin, "newline");
        contentPanel.add(this.tfMinQuantity);
        contentPanel.add((Component)this.lblMax, "newline");
        contentPanel.add(this.tfMaxQuantity);
        contentPanel.add((Component)this.lblSortOrder, "newline");
        contentPanel.add(this.tfSortOrder);
        contentPanel.add((Component)this.chkJumbToNextGroup, "skip 1,newline");
        contentPanel.add((Component)this.chkAutoShow, "skip 1,newline");
        contentPanel.add((Component)this.chkVisible, "skip 1,newline");
        this.add(contentPanel);
    }

    private void doAddNewModifierGroup() {
        try {
            ModifierGroupForm form = new ModifierGroupForm(new ModifierGroup());
            BeanEditorDialog dialog = new BeanEditorDialog(form);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ComboBoxModel model = (ComboBoxModel)this.cbMenuModifierGroup.getModel();
            Object modifierGroup = form.getBean();
            model.addElement(modifierGroup);
            this.cbMenuModifierGroup.setSelectedItem(modifierGroup);
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    public PosButton getAutoBuildButton() {
        return this.btnSaveAndAutoBuild;
    }

    @Override
    public boolean save() {
        return this.updateModel();
    }

    @Override
    protected void updateView() {
        MenuItemModifierSpec menuItemModifierGroup = this.getBean();
        if (menuItemModifierGroup == null || menuItemModifierGroup.getId() == null) {
            return;
        }
        this.tfName.setText(menuItemModifierGroup.getName());
        this.tfMinQuantity.setText(String.valueOf(menuItemModifierGroup.getMinQuantity()));
        this.tfMaxQuantity.setText(String.valueOf(menuItemModifierGroup.getMaxQuantity()));
        this.tfSortOrder.setText(String.valueOf(menuItemModifierGroup.getSortOrder()));
        this.chkVisible.setSelected(menuItemModifierGroup.isEnable());
        this.cbMenuModifierGroup.setSelectedItem(menuItemModifierGroup.getModifierGroup());
        this.taInstruction.setText(menuItemModifierGroup.getInstruction());
        this.chkJumbToNextGroup.setSelected(menuItemModifierGroup.isJumpGroup());
        this.chkAutoShow.setSelected(menuItemModifierGroup.isAutoShow());
    }

    @Override
    protected boolean updateModel() {
        MenuItemModifierSpec modifierGroup = this.getBean();
        ModifierGroup selectedGroup = (ModifierGroup)this.cbMenuModifierGroup.getSelectedItem();
        if (selectedGroup == null) {
            return false;
        }
        if (this.hasSimilerGroupSpec(selectedGroup)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Selected group already exists.");
            return false;
        }
        modifierGroup.setModifierGroup(selectedGroup);
        modifierGroup.setName(selectedGroup.getName());
        int minQuantity = this.tfMinQuantity.getInteger();
        int maxQuantity = this.tfMaxQuantity.getInteger();
        int sortOrder = this.tfSortOrder.getInteger();
        boolean selected = this.chkVisible.isSelected();
        modifierGroup.setMinQuantity(minQuantity);
        modifierGroup.setMaxQuantity(maxQuantity);
        modifierGroup.setSortOrder(sortOrder);
        modifierGroup.setEnable(selected);
        modifierGroup.setInstruction(this.taInstruction.getText());
        modifierGroup.setJumpGroup(this.chkJumbToNextGroup.isSelected());
        modifierGroup.setAutoShow(this.chkAutoShow.isSelected());
        return true;
    }

    private boolean hasSimilerGroupSpec(ModifierGroup selectedGroup) {
        if (this.editMode && selectedGroup.getName().equals(this.modifierSpec.getName())) {
            return false;
        }
        List<MenuItemModifierSpec> menuItemModiferSpecs = this.menuItem.getMenuItemModiferSpecs();
        if (menuItemModiferSpecs == null || menuItemModiferSpecs.isEmpty()) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : menuItemModiferSpecs) {
            if (!menuItemModifierSpec.getModifierGroup().getName().equals(selectedGroup.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayText() {
        MenuItemModifierSpec modifierGroup = this.getBean();
        if (modifierGroup.getId() == null) {
            return "New modifier group";
        }
        return "Edit modifier group";
    }

    public MenuItemModifierSpec getBean() {
        MenuItemModifierSpec modifierGroup = (MenuItemModifierSpec)super.getBean();
        if (modifierGroup == null) {
            modifierGroup = new MenuItemModifierSpec();
            this.setBean(modifierGroup);
        }
        return modifierGroup;
    }

    public boolean isAutoBuildSelected() {
        return this.autoBuildSelected;
    }
}

