/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;

public class MenuModifierForm
extends BeanEditor {
    private MenuModifier modifier;
    private JCheckBox chkPrintToKitchen;
    private JComboBox cbTaxGroup;
    private JFormattedTextField tfName;
    private FixedLengthTextField tfTranslatedName;
    private DoubleTextField tfNormalPrice;
    private DoubleTextField tfExtraPrice;
    private IntegerTextField tfSortOrder;
    private JButton btnButtonColor;
    private JButton btnTextColor;
    private JTable priceTable;
    private JTabbedPane jTabbedPane1;
    private Map<String, MultiplierPricePanel> itemMap = new HashMap<String, MultiplierPricePanel>();
    private JCheckBox chkUseFixedPrice;
    private JCheckBox chkComboModifier;

    public MenuModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public MenuModifierForm(MenuModifier modifier) throws Exception {
        this.modifier = modifier;
        this.checkRegularMultiplier();
        this.initComponents();
        this.initData();
        this.add(this.jTabbedPane1);
        this.setBean(modifier);
    }

    private void initData() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : taxGroups) {
            comboBoxModel.addElement(taxGroup);
        }
        this.cbTaxGroup.setModel(comboBoxModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.jTabbedPane1 = new JTabbedPane();
        this.tfName = new JFormattedTextField();
        this.tfTranslatedName = new FixedLengthTextField();
        this.tfNormalPrice = new DoubleTextField();
        this.tfExtraPrice = new DoubleTextField();
        this.tfSortOrder = new IntegerTextField();
        this.cbTaxGroup = new JComboBox();
        JButton btnNewTax = new JButton();
        this.chkPrintToKitchen = new JCheckBox();
        this.chkUseFixedPrice = new JCheckBox("Use fixed price");
        JPanel tabPrice = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.priceTable = new JTable();
        JLabel lblName = new JLabel(POSConstants.NAME + ":");
        JLabel lblTranslatedName = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel lblSortOrder = new JLabel(Messages.getString("MenuModifierForm.15"));
        JLabel lblTaxRate = new JLabel("Tax Group:");
        JLabel lblPercentage = new JLabel();
        this.tfExtraPrice.setText("0");
        lblPercentage.setText("");
        this.tfNormalPrice.setText("0");
        btnNewTax.setText("...");
        btnNewTax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuModifierForm.this.btnNewTaxActionPerformed(evt);
            }
        });
        this.chkPrintToKitchen.setText(POSConstants.PRINT_TO_KITCHEN);
        this.chkPrintToKitchen.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkPrintToKitchen.setMargin(new Insets(0, 0, 0, 0));
        JPanel generalTabPanel = new JPanel(new BorderLayout());
        this.jTabbedPane1.addTab(POSConstants.GENERAL, generalTabPanel);
        TransparentPanel lelfInputPanel = new TransparentPanel();
        lelfInputPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        lelfInputPanel.add((Component)lblName, "alignx left,aligny center");
        lelfInputPanel.add((Component)this.tfName, "growx,aligny top");
        lelfInputPanel.add((Component)lblTranslatedName, "alignx left,aligny center");
        lelfInputPanel.add((Component)this.tfTranslatedName, "growx");
        JPanel rightInputPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[86px][grow]"));
        rightInputPanel.add((Component)lblTaxRate, "alignx left,aligny center,split 2");
        rightInputPanel.add((Component)lblPercentage, "alignx left,aligny center");
        rightInputPanel.add((Component)this.cbTaxGroup, "growx,aligny top,split 2");
        rightInputPanel.add((Component)btnNewTax, "alignx left,aligny top");
        rightInputPanel.add((Component)lblSortOrder, "alignx left,aligny center");
        rightInputPanel.add((Component)this.tfSortOrder, "growx,aligny top");
        rightInputPanel.add((Component)this.chkPrintToKitchen, "skip 1,alignx left,aligny top");
        this.chkComboModifier = new JCheckBox("Combo Modifier");
        rightInputPanel.add((Component)this.chkComboModifier, "skip 1,alignx left,aligny top");
        generalTabPanel.add(lelfInputPanel);
        generalTabPanel.add((Component)rightInputPanel, "East");
        JLabel lblButtonColor = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.btnButtonColor = new JButton("");
        this.btnButtonColor.setPreferredSize(new Dimension(140, 40));
        JLabel lblTextColor = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.btnTextColor = new JButton(Messages.getString("MenuModifierForm.29"));
        this.btnTextColor.setPreferredSize(new Dimension(140, 40));
        JPanel tabButtonStyle = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        tabButtonStyle.add(lblButtonColor);
        tabButtonStyle.add(this.btnButtonColor);
        tabButtonStyle.add(lblTextColor);
        tabButtonStyle.add(this.btnTextColor);
        this.jTabbedPane1.addTab("Button Style", tabButtonStyle);
        this.btnButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.39"), MenuModifierForm.this.btnButtonColor.getBackground());
                MenuModifierForm.this.btnButtonColor.setBackground(color);
                MenuModifierForm.this.btnTextColor.setBackground(color);
            }
        });
        this.btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.40"), MenuModifierForm.this.btnTextColor.getForeground());
                MenuModifierForm.this.btnTextColor.setForeground(color);
            }
        });
        this.priceTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane3.setViewportView(this.priceTable);
        tabPrice.setLayout(new BorderLayout());
        tabPrice.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabPrice.add((Component)jScrollPane3, "Center");
        JPanel buttonPanel = new JPanel();
        JPanel multiplierPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 1"));
        List<Multiplier> multipliers = MultiplierDAO.getInstance().findAll();
        if (multipliers != null) {
            for (Multiplier multiplier : multipliers) {
                MultiplierPricePanel multiplierPricePanel = new MultiplierPricePanel(multiplier);
                multiplierPanel.add((Component)multiplierPricePanel, "grow");
                this.itemMap.put(multiplier.getId(), multiplierPricePanel);
            }
        }
        JScrollPane scrollPane = new JScrollPane(multiplierPanel);
        scrollPane.setBorder(new TitledBorder("Multiplier price"));
        lelfInputPanel.add((Component)scrollPane, "newline,skip 1,grow");
        tabPrice.add((Component)buttonPanel, "South");
        if (TerminalConfig.isMultipleOrderSupported()) {
            // empty if block
        }
    }

    private void checkRegularMultiplier() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void btnNewTaxActionPerformed(ActionEvent evt) {
        try {
            TaxForm editor = new TaxForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ComboBoxModel model = (ComboBoxModel)this.cbTaxGroup.getModel();
            model.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier modifier = (MenuModifier)this.getBean();
            ModifierDAO dao = new ModifierDAO();
            dao.saveMenuModifierFormData(modifier);
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        List<ModifierMultiplierPrice> multiplierPriceList;
        Color color;
        MenuModifier modifier = (MenuModifier)this.getBean();
        if (modifier == null) {
            this.tfName.setText("");
            this.tfNormalPrice.setText("0");
            this.tfExtraPrice.setText("0");
            return;
        }
        MenuModifierDAO.getInstance().initialize(modifier);
        this.tfName.setText(modifier.getName());
        this.tfTranslatedName.setText(modifier.getTranslatedName());
        this.tfNormalPrice.setText(String.valueOf(modifier.getPrice()));
        this.tfExtraPrice.setText(String.valueOf(modifier.getExtraPrice()));
        this.chkPrintToKitchen.setSelected(modifier.isShouldPrintToKitchen());
        this.chkComboModifier.setSelected(modifier.isComboModifier());
        this.chkUseFixedPrice.setSelected(modifier.isFixedPrice());
        if (modifier.getSortOrder() != null) {
            this.tfSortOrder.setText(modifier.getSortOrder().toString());
        }
        if (modifier.getButtonColor() != null) {
            color = new Color(modifier.getButtonColor());
            this.btnButtonColor.setBackground(color);
            this.btnTextColor.setBackground(color);
        }
        if (modifier.getTextColor() != null) {
            color = new Color(modifier.getTextColor());
            this.btnTextColor.setForeground(color);
        }
        if (modifier.getTaxGroup() != null) {
            this.cbTaxGroup.setSelectedItem(modifier.getTaxGroup());
        }
        if ((multiplierPriceList = modifier.getMultiplierPriceList()) != null) {
            for (ModifierMultiplierPrice multiplierPrice : multiplierPriceList) {
                MultiplierPricePanel pricePanel = this.itemMap.get(multiplierPrice.getMultiplier().getId());
                if (pricePanel == null) continue;
                pricePanel.setModifierMultiplierPrice(multiplierPrice);
            }
        }
        this.itemMap.get((Object)"Regular").tfAditionalPrice.setText(String.valueOf(modifier.getPrice()));
    }

    @Override
    protected boolean updateModel() {
        MenuModifier modifier = (MenuModifier)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name)) {
            MessageDialog.showError(Messages.getString("MenuModifierForm.44"));
            return false;
        }
        modifier.setName(name);
        modifier.setExtraPrice(this.tfExtraPrice.getDouble());
        modifier.setTaxGroup((TaxGroup)this.cbTaxGroup.getSelectedItem());
        modifier.setShouldPrintToKitchen(this.chkPrintToKitchen.isSelected());
        modifier.setComboModifier(this.chkComboModifier.isSelected());
        modifier.setTranslatedName(this.tfTranslatedName.getText());
        modifier.setButtonColor(this.btnButtonColor.getBackground().getRGB());
        modifier.setTextColor(this.btnTextColor.getForeground().getRGB());
        modifier.setSortOrder(this.tfSortOrder.getInteger());
        modifier.setFixedPrice(this.chkUseFixedPrice.isSelected());
        ArrayList<ModifierMultiplierPrice> mulplierPriceList = new ArrayList<ModifierMultiplierPrice>();
        for (MultiplierPricePanel panel : this.itemMap.values()) {
            if (!panel.isSelected()) continue;
            ModifierMultiplierPrice multiplierPrice = panel.getMultiplierPrice();
            if (multiplierPrice == null) {
                multiplierPrice = new ModifierMultiplierPrice();
                multiplierPrice.setMultiplier(panel.getMultiplier());
                multiplierPrice.setModifierId(modifier.getId());
            }
            multiplierPrice.setPrice(panel.getPrice());
            mulplierPriceList.add(multiplierPrice);
        }
        modifier.setPrice(this.itemMap.get("Regular").getPrice());
        modifier.setMultiplierPriceList(mulplierPriceList);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuModifier modifier = (MenuModifier)this.getBean();
        if (modifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }

    protected void doCalculateMultiplierPrice() {
        MultiplierPricePanel regularPricePanel = this.itemMap.get("Regular");
        if (regularPricePanel == null) {
            return;
        }
        for (MultiplierPricePanel panel : this.itemMap.values()) {
            panel.calculatePrice(this.getDoubleOrZero(regularPricePanel.tfAditionalPrice.getText()));
        }
    }

    public double getDouble(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public double getDoubleOrZero(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private class MultiplierPricePanel
    extends JPanel {
        ModifierMultiplierPrice multiplierPrice;
        Multiplier multiplier;
        JTextField tfAditionalPrice;

        public MultiplierPricePanel(Multiplier multiplier) {
            this.multiplier = multiplier;
            this.setLayout((LayoutManager)new MigLayout("inset 0,fillx", "[100px][grow][100px]", ""));
            this.tfAditionalPrice = new JTextField(multiplier.isMain() != false ? 6 : 9);
            this.tfAditionalPrice.setHorizontalAlignment(4);
            JLabel lblName = new JLabel(multiplier.getId());
            if (multiplier.isMain().booleanValue()) {
                lblName.setFont(new Font(null, 1, MenuModifierForm.this.tfName.getFont().getSize()));
            }
            this.add(lblName);
            this.add((Component)new JLabel(multiplier.isMain() != false ? "Price" : "Additional price", 11), "grow, gapright 10px");
            this.add((Component)this.tfAditionalPrice, "split 2,grow");
            if (multiplier.isMain().booleanValue()) {
                JButton btnCalculateMultilierPrice = new JButton("Calc");
                btnCalculateMultilierPrice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MenuModifierForm.this.doCalculateMultiplierPrice();
                    }
                });
                this.add(btnCalculateMultilierPrice);
            }
        }

        public void calculatePrice(double regPrice) {
            if (this.multiplier.isMain().booleanValue()) {
                return;
            }
            this.tfAditionalPrice.setText(String.valueOf(regPrice * this.multiplier.getRate() / 100.0));
        }

        public Double getPrice() {
            return MenuModifierForm.this.getDoubleOrZero(this.tfAditionalPrice.getText());
        }

        public Multiplier getMultiplier() {
            return this.multiplier;
        }

        public boolean isSelected() {
            Double value = MenuModifierForm.this.getDouble(this.tfAditionalPrice.getText());
            return !value.isNaN();
        }

        private void update() {
            if (this.multiplierPrice == null) {
                return;
            }
            this.tfAditionalPrice.setText(String.valueOf(this.multiplierPrice.getPrice()));
        }

        public void setModifierMultiplierPrice(ModifierMultiplierPrice price) {
            this.multiplierPrice = price;
            this.update();
        }

        public ModifierMultiplierPrice getMultiplierPrice() {
            return this.multiplierPrice;
        }
    }
}

