/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuPage;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuPageForm
extends BeanEditor {
    private FixedLengthTextField tfName;
    private IntegerTextField tfSortOrder;
    private IntegerTextField tfNumberOfColumns;
    private IntegerTextField tfNumberOfRows;
    private IntegerTextField tfButtonWidth;
    private IntegerTextField tfButtonHeight;
    private JCheckBox cbFlexibleButtonSize;
    private boolean isInfo;

    public MenuPageForm() {
        this(new MenuPage(), false);
    }

    public MenuPageForm(MenuPage menuPage, boolean isInfo) {
        this.isInfo = isInfo;
        this.initComponents();
        this.setBean(menuPage);
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout());
        this.tfName = new FixedLengthTextField();
        this.tfSortOrder = new IntegerTextField(10);
        this.tfNumberOfColumns = new IntegerTextField(10);
        this.tfNumberOfRows = new IntegerTextField(10);
        this.tfButtonWidth = new IntegerTextField(6);
        this.tfButtonHeight = new IntegerTextField(6);
        this.tfNumberOfColumns.setText("4");
        this.tfNumberOfRows.setText("4");
        JLabel lblName = new JLabel(POSConstants.NAME);
        contentPanel.add(lblName);
        contentPanel.add((Component)this.tfName, "wrap");
        JLabel lblSortOrder = new JLabel(POSConstants.SORT_ORDER);
        contentPanel.add(lblSortOrder);
        contentPanel.add((Component)this.tfSortOrder, "grow,wrap");
        contentPanel.add(new JLabel("Number of columns"));
        contentPanel.add((Component)this.tfNumberOfColumns, "grow,wrap");
        contentPanel.add(new JLabel("Number of rows"));
        contentPanel.add((Component)this.tfNumberOfRows, "grow");
        contentPanel.add((Component)new JLabel("Button width"), "newline");
        contentPanel.add((Component)this.tfButtonWidth, "grow");
        contentPanel.add((Component)new JLabel("Button height"), "newline");
        contentPanel.add((Component)this.tfButtonHeight, "grow");
        this.cbFlexibleButtonSize = new JCheckBox("Flexible button size");
        contentPanel.add((Component)this.cbFlexibleButtonSize, "skip 1,newline,grow");
        if (this.isInfo) {
            contentPanel.remove(lblName);
            contentPanel.remove(this.tfName);
            contentPanel.remove(lblSortOrder);
            contentPanel.remove(this.tfSortOrder);
            this.tfButtonHeight.setText("100");
            this.tfButtonWidth.setText("100");
        }
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            return this.updateModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected void updateView() {
        MenuPage menuPage = (MenuPage)this.getBean();
        if (menuPage.getId() == null) {
            return;
        }
        this.tfName.setText(menuPage.getName());
        this.tfSortOrder.setText(String.valueOf(menuPage.getSortOrder()));
        this.tfNumberOfColumns.setText(String.valueOf(menuPage.getCols()));
        this.tfNumberOfRows.setText(String.valueOf(menuPage.getRows()));
        this.cbFlexibleButtonSize.setSelected(menuPage.isFlixibleButtonSize());
        this.tfButtonWidth.setText(String.valueOf(menuPage.getButtonWidth()));
        this.tfButtonHeight.setText(String.valueOf(menuPage.getButtonHeight()));
    }

    @Override
    protected boolean updateModel() {
        MenuPage menuPage = (MenuPage)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name) && !this.isInfo) {
            POSMessageDialog.showError(this, POSConstants.NAME_REQUIRED);
            return false;
        }
        int buttonWidth = this.tfButtonWidth.getInteger();
        if (buttonWidth < 30) {
            POSMessageDialog.showError(this, "Button width must be greater than or equal to 30");
            return false;
        }
        int buttonHeight = this.tfButtonHeight.getInteger();
        if (buttonHeight < 30) {
            POSMessageDialog.showError(this, "Button height must be greater than or equal to 30");
            return false;
        }
        if (!this.isInfo) {
            menuPage.setName(name);
            menuPage.setSortOrder(this.tfSortOrder.getInteger());
        } else {
            menuPage.setName("auto");
        }
        menuPage.setCols(this.tfNumberOfColumns.getInteger());
        menuPage.setRows(this.tfNumberOfRows.getInteger());
        menuPage.setFlixibleButtonSize(this.cbFlexibleButtonSize.isSelected());
        menuPage.setButtonWidth(buttonWidth);
        menuPage.setButtonHeight(buttonHeight);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuPage menuPage = (MenuPage)this.getBean();
        if (menuPage.getId() == null) {
            return "New menu page";
        }
        return "Edit menu gage";
    }
}

