/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MultipleModifierSelectionView
extends JPanel {
    private JComboBox cbGroup;
    private JXTable table;
    private BeanTableModel<MenuModifier> tableModel;
    private JTextField tfName;
    private MenuModifier parentMenuModifier;
    private PosButton btnNext;
    private PosButton btnPrev;
    private ModifierGroup selectedGroup;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton searchBttn;
    private JPanel searchPanel;
    private Map<String, MenuModifier> addedMenuModifierMap = new HashMap<String, MenuModifier>();
    private JCheckBox chkShowSelected;
    private JCheckBox chkSelectAll;
    private boolean pizzaModifierGroup;
    private boolean singleSelectionEnable;
    private JLabel lblGroupName;

    public MultipleModifierSelectionView(List<MenuModifier> addedMenuModifiers, boolean pizzaModifierGroup) {
        this.pizzaModifierGroup = pizzaModifierGroup;
        this.init();
        this.tableModel.setCurrentRowIndex(0);
        this.cbGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MultipleModifierSelectionView.this.chkSelectAll.setEnabled(true);
                MultipleModifierSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleModifierSelectionView.this.setSelectedModifierGroup(MultipleModifierSelectionView.this.cbGroup.getSelectedItem());
            }
        });
        this.setMenuModifiers(addedMenuModifiers);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuModifier.class);
        this.tableModel.addColumn("", "enable");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.tableModel.setPageSize(10);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MultipleModifierSelectionView.this.doAddSelectedRowOnDoubleCLick();
                } else {
                    MultipleModifierSelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox("Show selected");
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultipleModifierSelectionView.this.chkShowSelected.isSelected()) {
                    MultipleModifierSelectionView.this.tableModel.setRows(new ArrayList(MultipleModifierSelectionView.this.addedMenuModifierMap.values()));
                    MultipleModifierSelectionView.this.updateMenuModifierSelection();
                    MultipleModifierSelectionView.this.chkShowSelected.setText("Show Selected (" + MultipleModifierSelectionView.this.addedMenuModifierMap.values().size() + ")");
                    MultipleModifierSelectionView.this.lblNumberOfItem.setText("");
                    MultipleModifierSelectionView.this.btnPrev.setEnabled(false);
                    MultipleModifierSelectionView.this.btnNext.setEnabled(false);
                    MultipleModifierSelectionView.this.chkSelectAll.setEnabled(false);
                    MultipleModifierSelectionView.this.cbGroup.setEnabled(false);
                    MultipleModifierSelectionView.this.table.repaint();
                } else {
                    if (MultipleModifierSelectionView.this.cbGroup.getSelectedItem() != null) {
                        MultipleModifierSelectionView.this.searchItem();
                    }
                    MultipleModifierSelectionView.this.cbGroup.setEnabled(true);
                }
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == MultipleModifierSelectionView.this.btnPrev) {
                        MultipleModifierSelectionView.this.scrollUp();
                    } else if (source == MultipleModifierSelectionView.this.btnNext) {
                        MultipleModifierSelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void doAddSelectedRowOnDoubleCLick() {
        try {
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            if (windowAncestor instanceof POSDialog) {
                ((POSDialog)windowAncestor).setCanceled(false);
            }
            windowAncestor.dispose();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage(), x);
        }
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[][]"));
        this.lblName = new JLabel(POSConstants.NAME);
        this.tfName = new JTextField();
        this.searchBttn = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "grow");
        JButton btnSearch = new JButton("Search");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleModifierSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleModifierSelectionView.this.searchItem();
            }
        });
        this.searchPanel.add(btnSearch);
        this.chkSelectAll = new JCheckBox("Select All");
        this.chkSelectAll.setEnabled(false);
        this.chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleModifierSelectionView.this.selectGroupItems();
            }
        });
        this.cbGroup = new JComboBox();
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add("<All>");
        List<ModifierGroup> menuModifierGroupList = null;
        menuModifierGroupList = this.pizzaModifierGroup ? ModifierGroupDAO.getInstance().findPizzaModifierGroups() : ModifierGroupDAO.getInstance().findNormalModifierGroups();
        if (menuModifierGroupList != null) {
            groups.addAll(menuModifierGroupList);
        }
        ComboBoxModel model = new ComboBoxModel(groups);
        this.cbGroup.setModel(model);
        this.cbGroup.setSelectedItem("<All>");
        this.lblGroupName = new JLabel("Group");
        this.searchPanel.add(this.lblGroupName);
        this.searchPanel.add((Component)this.cbGroup, "wrap");
        this.searchPanel.add((Component)this.chkSelectAll, "left");
        this.searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleModifierSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleModifierSelectionView.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleModifierSelectionView.this.tableModel.setCurrentRowIndex(0);
                MultipleModifierSelectionView.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    private void searchItem() {
        Object selectedGroupObject = this.cbGroup.getSelectedItem();
        if (selectedGroupObject instanceof ModifierGroup) {
            ModifierGroup group = (ModifierGroup)selectedGroupObject;
            ModifierGroupDAO.getInstance().refresh(group);
            List<MenuModifier> modifierList = group.getModifiers();
            if (modifierList == null) {
                modifierList = new ArrayList<MenuModifier>();
            }
            this.tableModel.setCurrentRowIndex(0);
            this.tableModel.setNumRows(modifierList.size());
            this.tableModel.setRows(modifierList);
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.lblNumberOfItem.setText("");
        } else {
            this.tableModel.setNumRows(MenuModifierDAO.getInstance().getRowCount(this.tfName.getText(), this.pizzaModifierGroup));
            MenuModifierDAO.getInstance().loadItems(this.tfName.getText(), true, this.pizzaModifierGroup, this.tableModel);
        }
        this.doSetEnableCheckAll();
        this.updateButton();
        this.updateMenuModifierSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void selectGroupItems() {
        Object selectedGroup = this.cbGroup.getSelectedItem();
        if (selectedGroup instanceof ModifierGroup) {
            List<MenuModifier> menuItems = this.tableModel.getRows();
            if (menuItems != null && menuItems.size() > 0) {
                for (MenuModifier item : menuItems) {
                    if (this.parentMenuModifier != null && this.parentMenuModifier.getId() != null && this.parentMenuModifier.getId().equals(item.getId())) continue;
                    item.setEnable(this.chkSelectAll.isSelected());
                    if (item.isEnable().booleanValue()) {
                        this.addedMenuModifierMap.put(item.getId(), item);
                        continue;
                    }
                    this.addedMenuModifierMap.remove(item.getId());
                }
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items found!");
                this.chkSelectAll.setSelected(false);
            }
        }
        this.table.repaint();
    }

    private void updateMenuModifierSelection() {
        List<MenuModifier> menuItems = this.tableModel.getRows();
        if (menuItems == null) {
            return;
        }
        Iterator<MenuModifier> iterator = menuItems.iterator();
        while (iterator.hasNext()) {
            MenuModifier menuItem;
            MenuModifier item = this.addedMenuModifierMap.get((menuItem = iterator.next()).getId());
            menuItem.setEnable(item != null);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.chkShowSelected.setText("Show Selected (" + this.addedMenuModifierMap.values().size() + ")");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleModifierSelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuModifier menuItem = new MenuModifier();
                    MenuModifierForm editor = new MenuModifierForm(menuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier foodItem = (MenuModifier)editor.getBean();
                    MultipleModifierSelectionView.this.tableModel.addRow(foodItem);
                    MultipleModifierSelectionView.this.tableModel.setNumRows(MultipleModifierSelectionView.this.tableModel.getNumRows() + 1);
                    MultipleModifierSelectionView.this.updateButton();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(70);
        columnWidth.add(250);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuModifier menuItem = this.tableModel.getRow(index);
            this.tableModel.setRow(index, menuItem);
            MenuModifierForm editor = new MenuModifierForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuModifier> getSelectedMenuModifierList() {
        return new ArrayList<MenuModifier>(this.addedMenuModifierMap.values());
    }

    public void setMenuModifiers(List<MenuModifier> menuItems) {
        if (menuItems != null) {
            for (MenuModifier item : menuItems) {
                this.addedMenuModifierMap.put(item.getId(), item);
            }
        }
        this.searchItem();
    }

    public void setParentMenuModifier(MenuModifier selectedMenuModifier) {
        this.parentMenuModifier = selectedMenuModifier;
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        this.searchItem();
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        this.searchItem();
    }

    public void setSelectedModifierGroup(Object selectedItem) {
        this.selectedGroup = selectedItem instanceof ModifierGroup ? (ModifierGroup)selectedItem : null;
        this.searchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        if (this.singleSelectionEnable) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        MenuModifier item = this.tableModel.getRow(selectedRow);
        if (this.parentMenuModifier != null && this.parentMenuModifier.getId() != null && this.parentMenuModifier.getId().equals(item.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Parent item cannot be selected");
            return;
        }
        item.setEnable(item.isEnable() == false);
        if (item.isEnable().booleanValue()) {
            this.addedMenuModifierMap.put(item.getId(), item);
        } else {
            this.addedMenuModifierMap.remove(item.getId());
        }
        this.chkShowSelected.setText("Show Selected (" + this.addedMenuModifierMap.values().size() + ")");
        this.table.repaint();
    }

    private void doSetEnableCheckAll() {
        ArrayList<Boolean> checkVisibilities = new ArrayList<Boolean>();
        List<MenuModifier> menuItems = this.tableModel.getRows();
        for (MenuModifier menuItem : menuItems) {
            if (!this.addedMenuModifierMap.containsKey(menuItem.getId())) continue;
            checkVisibilities.add(menuItem.isEnable());
        }
        if (checkVisibilities.size() != 0 && !checkVisibilities.contains(false)) {
            this.chkSelectAll.setSelected(true);
        } else {
            this.chkSelectAll.setSelected(false);
        }
        this.chkSelectAll.setEnabled(this.cbGroup.getSelectedItem() instanceof ModifierGroup);
    }

    public BeanTableModel<MenuModifier> getModel() {
        return this.tableModel;
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSingleSelectionEnable(boolean enable) {
        this.singleSelectionEnable = enable;
        if (enable) {
            this.chkShowSelected.setVisible(false);
            this.cbGroup.setVisible(false);
            this.lblGroupName.setVisible(false);
            this.chkSelectAll.setVisible(false);
            this.lblNumberOfItem.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnPrev.setVisible(false);
            TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
            columnModel.getColumnExt(0).setVisible(false);
            this.searchItem();
        }
    }

    public void setSelectedGroup(ModifierGroup modifierGroup) {
        if (this.selectedGroup != null && this.selectedGroup.getId().equals(modifierGroup.getId())) {
            return;
        }
        this.selectedGroup = modifierGroup;
        this.cbGroup.setSelectedItem(modifierGroup);
        this.searchItem();
    }

    public void setModifiers(List<MenuModifier> modifiers) {
        this.searchPanel.setVisible(false);
        this.tableModel.setPageSize(modifiers.size());
        this.tableModel.setNumRows(modifiers.size());
        this.tableModel.setRows(modifiers);
        this.doSetEnableCheckAll();
        this.updateButton();
        this.updateMenuModifierSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }
}

