/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class UserRoleForm
extends BeanEditor {
    private JComboBox cbUserType;
    private DoubleTextField tfCostPerHour;
    private JCheckBox chkAllowReceiveTips;
    private JCheckBox chkUserInDriver;
    private JCheckBox chkStaffBank;
    private JCheckBox chkAutoStartStaffBank;
    private JCheckBox chkBlindAccountableAmount;
    private JCheckBox chkActive;

    public UserRoleForm(User user) {
        this.initComponents();
        UserTypeDAO dao = new UserTypeDAO();
        List<UserType> userTypes = dao.findAll();
        this.cbUserType.setModel(new DefaultComboBoxModel<Object>(userTypes.toArray()));
        this.setBean(user);
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout());
        this.tfCostPerHour = new DoubleTextField(10);
        this.cbUserType = new JComboBox();
        contentPanel.add(new JLabel("User Role"));
        contentPanel.add((Component)this.cbUserType, "wrap,grow");
        this.cbUserType.setSelectedItem(null);
        contentPanel.add(new JLabel("Cost per hour"));
        contentPanel.add((Component)this.tfCostPerHour, "wrap");
        this.chkAllowReceiveTips = new JCheckBox("Can receive tips");
        contentPanel.add((Component)this.chkAllowReceiveTips, "skip 1,newline,grow");
        this.chkUserInDriver = new JCheckBox("User is driver");
        contentPanel.add((Component)this.chkUserInDriver, "skip 1,newline,grow");
        this.chkStaffBank = new JCheckBox("Staff Bank");
        contentPanel.add((Component)this.chkStaffBank, "skip 1,newline,grow");
        this.chkAutoStartStaffBank = new JCheckBox("Auto start staff bank");
        contentPanel.add((Component)this.chkAutoStartStaffBank, "skip 1,newline,grow");
        this.chkBlindAccountableAmount = new JCheckBox("Blind Accountable Amount");
        contentPanel.add((Component)this.chkBlindAccountableAmount, "skip 1,newline,grow");
        this.chkActive = new JCheckBox("Active");
        contentPanel.add((Component)this.chkActive, "skip 1,newline,grow");
        this.chkStaffBank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRoleForm.this.chkAutoStartStaffBank.setEnabled(UserRoleForm.this.chkStaffBank.isSelected());
                UserRoleForm.this.chkBlindAccountableAmount.setEnabled(UserRoleForm.this.chkStaffBank.isSelected());
            }
        });
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            User user = (User)this.getBean();
            UserDAO dao = new UserDAO();
            dao.saveOrUpdate(user);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected void updateView() {
        User user = (User)this.getBean();
        this.tfCostPerHour.setText(String.valueOf(user.getCostPerHour()));
        this.chkAllowReceiveTips.setSelected(user.isAllowReceiveTips());
        this.cbUserType.setSelectedItem(user.getType());
        this.chkStaffBank.setSelected(user.isStaffBank());
        this.chkAutoStartStaffBank.setSelected(user.isAutoStartStaffBank());
        this.chkBlindAccountableAmount.setSelected(user.isBlindAccountableAmount());
        this.chkUserInDriver.setSelected(user.isDriver());
        this.chkAutoStartStaffBank.setEnabled(this.chkStaffBank.isSelected());
        this.chkBlindAccountableAmount.setEnabled(this.chkStaffBank.isSelected());
        this.chkActive.setSelected(user.isActive());
    }

    @Override
    protected boolean updateModel() {
        User user = (User)this.getBean();
        UserType selectedRole = (UserType)this.cbUserType.getSelectedItem();
        if (selectedRole == null) {
            return false;
        }
        double costPerHour = this.tfCostPerHour.getDouble();
        if (user.getId() == null) {
            user.setId(GlobalIdGenerator.generateGlobalId().toString());
        }
        user.setCostPerHour(costPerHour);
        user.setAllowReceiveTips(this.chkAllowReceiveTips.isSelected());
        user.setType(selectedRole);
        user.setStaffBank(this.chkStaffBank.isSelected());
        user.setActive(this.chkActive.isSelected());
        if (this.chkStaffBank.isSelected()) {
            user.setAutoStartStaffBank(this.chkAutoStartStaffBank.isSelected());
            user.setBlindAccountableAmount(this.chkBlindAccountableAmount.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        user.setDriver(this.chkUserInDriver.isSelected());
        User parentUser = user.getParentUser();
        user.setFirstName(parentUser.getFirstName());
        user.setLastName(parentUser.getLastName());
        user.setActive(parentUser.isActive());
        user.setPhoneNo(parentUser.getPhoneNo());
        user.setAvailableForDelivery(parentUser.isAvailableForDelivery());
        user.setImageId(parentUser.getImageId());
        user.setSsn(parentUser.getSsn());
        user.setPassword(null);
        user.setLinkedUser(null);
        user.setRoot(false);
        List<User> linkedUserList = parentUser.getLinkedUser();
        if (linkedUserList != null) {
            for (User linkedUser : linkedUserList) {
                if (user.getId() != null || !linkedUser.getType().getName().equals(selectedRole.getName())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This role already exists.");
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return "User role";
    }
}

