/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.DataUpdateInfo;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.DataUpdateInfoDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.OrderFilterPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.TicketListTableModel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TicketListView
extends JPanel
implements DataChangeListener,
ITicketList {
    private JXTable ticketListTable;
    private TicketListTableModel ticketListTableModel;
    private OrderFilterPanel orderFiltersPanel;
    private PosBlinkButton btnRefresh;
    private PosButton btnPrevious;
    private PosButton btnNext;
    private TableColumnModelExt columnModel;
    private ArrayList<TicketListUpdateListener> ticketUpdateListenerList = new ArrayList();
    private boolean isCustomerHistoryOpen;
    private Date lastUpdateTime;
    private Timer lastUpateCheckTimer = new Timer(5000, new TaskLastUpdateCheck());
    private String customerId;
    private POSToggleButton btnOrderFilters;

    public TicketListView() {
        this.setLayout(new BorderLayout());
        this.orderFiltersPanel = new OrderFilterPanel(this);
        this.add((Component)((Object)this.orderFiltersPanel), "North");
        this.createTicketTable();
        this.updateTicketList();
    }

    public TicketListView(String customerId, boolean customerHistory) {
        this.isCustomerHistoryOpen = customerHistory;
        this.setLayout(new BorderLayout());
        this.createTicketTable();
        this.updateTicketList();
    }

    private void createTicketTable() {
        this.ticketListTable = new JXTable();
        this.ticketListTable.setSortable(true);
        this.ticketListTable.setSelectionMode(0);
        this.ticketListTable.setColumnControlVisible(true);
        this.ticketListTableModel = new TicketListTableModel();
        this.ticketListTable.setModel((TableModel)this.ticketListTableModel);
        this.ticketListTableModel.setPageSize(TerminalConfig.getOrderViewPageSize());
        this.ticketListTable.setRowHeight(PosUIManager.getSize(60));
        this.ticketListTable.setAutoResizeMode(3);
        this.ticketListTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.ticketListTable.setGridColor(Color.LIGHT_GRAY);
        this.ticketListTable.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.columnModel = (TableColumnModelExt)this.ticketListTable.getColumnModel();
        this.columnModel.getColumn(0).setPreferredWidth(65);
        this.columnModel.getColumn(1).setPreferredWidth(30);
        this.columnModel.getColumn(2).setPreferredWidth(20);
        this.columnModel.getColumn(3).setPreferredWidth(100);
        this.columnModel.getColumn(4).setPreferredWidth(100);
        if (this.isCustomerHistoryOpen) {
            this.columnModel.getColumnExt(1).setVisible(false);
            this.columnModel.getColumnExt(1).setVisible(false);
            this.columnModel.getColumnExt(6).setVisible(false);
            this.columnModel.getColumnExt(8).setVisible(false);
            this.createScrollPane();
            return;
        }
        this.restoreTableColumnsVisibility();
        this.addTableColumnListener();
        this.createScrollPane();
    }

    private void addTableColumnListener() {
        this.columnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                TicketListView.this.saveHiddenColumns();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TicketListView.this.saveHiddenColumns();
            }
        });
    }

    private void restoreTableColumnsVisibility() {
        String recordedSelectedColumns = TerminalConfig.getTicketListViewHiddenColumns();
        TableColumnModelExt columnModel = (TableColumnModelExt)this.ticketListTable.getColumnModel();
        if (recordedSelectedColumns.isEmpty()) {
            return;
        }
        String[] str = recordedSelectedColumns.split("\\*");
        for (int i = 0; i < str.length; ++i) {
            Integer columnIndex = Integer.parseInt(str[i]);
            columnModel.getColumnExt(columnIndex - i).setVisible(false);
        }
    }

    private void saveHiddenColumns() {
        List columns = this.columnModel.getColumns(true);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (TableColumn tableColumn : columns) {
            TableColumnExt c = (TableColumnExt)tableColumn;
            if (c.isVisible()) continue;
            indices.add(c.getModelIndex());
        }
        this.saveTableColumnsVisibility(indices);
    }

    private void createScrollPane() {
        if (!this.isCustomerHistoryOpen) {
            this.btnOrderFilters = new POSToggleButton();
            this.btnOrderFilters.setIcon(IconFactory.getIcon("/ui_icons/", "filter-16.png"));
            this.updateOrderFilterPanel(TerminalConfig.isOrderFilterPanelVisible());
        }
        this.btnRefresh = new PosBlinkButton(IconFactory.getIcon("/ui_icons/", "refresh-16.png"));
        this.btnPrevious = new PosButton(IconFactory.getIcon("/ui_icons/", "previous-24.png"));
        this.btnNext = new PosButton(IconFactory.getIcon("/ui_icons/", "next-24.png"));
        this.createActionHandlers();
        PosScrollPane scrollPane = new PosScrollPane((Component)this.ticketListTable, 20, 31);
        scrollPane.getVerticalScrollBar().setUI(new CustomScrollbarUI());
        int height = PosUIManager.getSize(40);
        JPanel topButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        ColumnControlButton controlButton = new ColumnControlButton(this.ticketListTable);
        if (!this.isCustomerHistoryOpen) {
            topButtonPanel.add((Component)controlButton, "h " + height + "!, grow, wrap");
        }
        topButtonPanel.add((Component)this.btnRefresh, "h " + height + "!, grow, wrap");
        topButtonPanel.add((Component)this.btnPrevious, "h " + height + "!, grow, wrap");
        JPanel downButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        downButtonPanel.add((Component)this.btnNext, "h " + height + "!, grow,gaptop 5, wrap");
        if (!this.isCustomerHistoryOpen) {
            downButtonPanel.add((Component)this.btnOrderFilters, "h " + height + "!,grow, wrap");
        }
        JPanel tableButtonPanel = new JPanel(new BorderLayout());
        tableButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        tableButtonPanel.setPreferredSize(PosUIManager.getSize(52, 0));
        tableButtonPanel.add((Component)topButtonPanel, "North");
        tableButtonPanel.add((Component)downButtonPanel, "South");
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        tableButtonPanel.add(verticalScrollBar);
        this.add(scrollPane);
        this.add((Component)tableButtonPanel, "East");
    }

    public void createActionHandlers() {
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketListView.this.ticketListTableModel.hasPrevious()) {
                    TicketListView.this.ticketListTableModel.setCurrentRowIndex(TicketListView.this.ticketListTableModel.getPreviousRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.ticketListTableModel);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketListView.this.ticketListTableModel.hasNext()) {
                    TicketListView.this.ticketListTableModel.setCurrentRowIndex(TicketListView.this.ticketListTableModel.getNextRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.ticketListTableModel);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketListView.this.getTableModel().setCurrentRowIndex(0);
                if (TicketListView.this.customerId != null) {
                    TicketListView.this.updateCustomerTicketList(TicketListView.this.customerId);
                } else {
                    TicketListView.this.updateTicketList();
                }
            }
        });
        if (!this.isCustomerHistoryOpen) {
            this.btnOrderFilters.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TicketListView.this.orderFiltersPanel.setCollapsed(!TicketListView.this.orderFiltersPanel.isCollapsed());
                    TerminalConfig.setOrderFilterPanelVisible(TicketListView.this.btnOrderFilters.isSelected());
                }
            });
        }
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.ticketListTableModel.hasNext());
        this.btnPrevious.setEnabled(this.ticketListTableModel.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        this.lastUpateCheckTimer.stop();
        try {
            this.ticketListTableModel.setCurrentRowIndex(0);
            this.ticketListTableModel.setNumRows(TicketDAO.getInstance().getNumTickets());
            TicketDAO.getInstance().loadTickets(this.ticketListTableModel);
            this.btnRefresh.setBlinking(false);
            this.updateButtonStatus();
            for (int i = 0; i < this.ticketUpdateListenerList.size(); ++i) {
                TicketListUpdateListener listener = this.ticketUpdateListenerList.get(i);
                listener.ticketListUpdated();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), e);
        }
        try {
            DataUpdateInfo lastUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo();
            if (lastUpdateInfo != null) {
                this.lastUpdateTime = new Date(lastUpdateInfo.getLastUpdateTime().getTime());
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.20"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCustomerTicketList(String memberId) {
        this.lastUpateCheckTimer.stop();
        this.customerId = memberId;
        try {
            Application.getPosWindow().setGlassPaneVisible(true);
            TicketListTableModel ticketListTableModel = this.getTableModel();
            List<Ticket> tickets = TicketDAO.getInstance().findCustomerTickets(memberId, ticketListTableModel);
            this.setTickets(tickets);
            this.btnRefresh.setBlinking(false);
            for (int i = 0; i < this.ticketUpdateListenerList.size(); ++i) {
                TicketListUpdateListener listener = this.ticketUpdateListenerList.get(i);
                listener.ticketListUpdated();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), e);
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
        try {
            DataUpdateInfo lastUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo();
            if (lastUpdateInfo != null) {
                this.lastUpdateTime = new Date(lastUpdateInfo.getLastUpdateTime().getTime());
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.20"), e);
        }
    }

    public void addTicketListUpateListener(TicketListUpdateListener l) {
        this.ticketUpdateListenerList.add(l);
    }

    public void setTickets(List<Ticket> tickets) {
        this.ticketListTableModel.setRows(tickets);
    }

    public void addTicket(Ticket ticket) {
        this.ticketListTableModel.addItem(ticket);
    }

    @Override
    public Ticket getSelectedTicket() {
        int selectedRow = this.ticketListTable.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        return (Ticket)this.ticketListTableModel.getRowData(this.ticketListTable.convertRowIndexToModel(selectedRow));
    }

    public List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        Ticket selectedTicket = this.getSelectedTicket();
        if (selectedTicket == null) {
            return null;
        }
        tickets.add(selectedTicket);
        return tickets;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            POSMessageDialog.showMessage(Messages.getString("TicketListView.14"));
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JXTable getTable() {
        return this.ticketListTable;
    }

    public TicketListTableModel getTableModel() {
        return this.ticketListTableModel;
    }

    public void setCurrentRowIndexZero() {
        this.getTableModel().setCurrentRowIndex(0);
    }

    public void setAutoUpdateCheck(boolean check) {
        if (!check) {
            this.lastUpateCheckTimer.stop();
        }
    }

    private void updateOrderFilterPanel(boolean isVisible) {
        if (isVisible) {
            this.orderFiltersPanel.setCollapsed(!TerminalConfig.isOrderFilterPanelVisible());
            this.btnOrderFilters.setSelected(!this.orderFiltersPanel.isCollapsed());
        }
    }

    private void saveTableColumnsVisibility(List indices) {
        String selectedColumns = "";
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            String newSelectedColumn = String.valueOf(iterator.next());
            selectedColumns = selectedColumns + newSelectedColumn;
            if (!iterator.hasNext()) continue;
            selectedColumns = selectedColumns + "*";
        }
        TerminalConfig.setTicketListViewHiddenColumns(selectedColumns);
    }

    @Override
    public void dataAdded(Object object) {
        if (object == null) {
            return;
        }
        TicketListTableModel ticketListTableModel = this.getTableModel();
        ArrayList<Ticket> filteredTicketList = new ArrayList<Ticket>();
        filteredTicketList.add((Ticket)object);
        filteredTicketList.addAll(ticketListTableModel.getRows());
        ticketListTableModel.setRows(filteredTicketList);
        ticketListTableModel.setNumRows(ticketListTableModel.getNumRows() + 1);
        this.updateButtonStatus();
    }

    @Override
    public void dataChanged(Object object) {
        if (object == null) {
            return;
        }
        Ticket updatedTicket = (Ticket)object;
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        int row = this.getTicketRowNum(updatedTicket);
        if (!updatedTicket.isClosed().booleanValue() && paymentStatusFilter == PaymentStatusFilter.OPEN) {
            if (row == -1) {
                this.dataAdded(updatedTicket);
            }
        } else if (updatedTicket.isClosed().booleanValue() && paymentStatusFilter != PaymentStatusFilter.CLOSED) {
            this.dataRemoved(updatedTicket);
        } else {
            this.ticketListTableModel.updateItem(row);
            this.ticketListTable.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    private int getTicketRowNum(Ticket updatedTicket) {
        List<Ticket> rows = this.ticketListTableModel.getRows();
        for (int row = 0; row < rows.size(); ++row) {
            Ticket modelTicket = (Ticket)rows.get(row);
            if (!modelTicket.getId().equals(updatedTicket.getId())) continue;
            rows.set(row, updatedTicket);
            return row;
        }
        return -1;
    }

    @Override
    public void dataRemoved(Object object) {
        if (object == null) {
            return;
        }
        this.ticketListTableModel.deleteItem(object);
        this.ticketListTableModel.setNumRows(this.ticketListTableModel.getNumRows() - 1);
        this.ticketListTableModel.fireTableDataChanged();
    }

    @Override
    public Object getSelectedData() {
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            GlobalInputDialog inputDialog = new GlobalInputDialog(Application.getPosWindow());
            inputDialog.setCaption("Enter ticket ID");
            inputDialog.open();
            if (inputDialog.isCanceled()) {
                return null;
            }
            String ticketId = inputDialog.getInput();
            ticket = TicketService.getTicket(ticketId);
        }
        return ticket;
    }

    @Override
    public void dataSetUpdated() {
        this.updateTicketList();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket updatedTicket = (Ticket)object;
        if (updatedTicket.getId() == null) {
            return;
        }
        updatedTicket = TicketDAO.getInstance().get(updatedTicket.getId());
        this.dataChanged(updatedTicket);
    }

    class CustomScrollbarUI
    extends BasicScrollBarUI {
        private ImageIcon downArrow;
        private ImageIcon upArrow = IconFactory.getIcon("/ui_icons/", "up.png");

        public CustomScrollbarUI() {
            this.downArrow = IconFactory.getIcon("/ui_icons/", "down.png");
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            PosButton decreaseButton = new PosButton(this.getAppropriateIcon(orientation)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }
            };
            return decreaseButton;
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            PosButton increaseButton = new PosButton(this.getAppropriateIcon(orientation)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }
            };
            return increaseButton;
        }

        private ImageIcon getAppropriateIcon(int orientation) {
            switch (orientation) {
                case 5: {
                    return this.downArrow;
                }
                case 1: {
                    return this.upArrow;
                }
            }
            return this.upArrow;
        }
    }

    private class TaskLastUpdateCheck
    implements ActionListener {
        private TaskLastUpdateCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            TicketListView.this.lastUpateCheckTimer.stop();
            if (TicketListView.this.btnRefresh.isBlinking()) {
                return;
            }
            DataUpdateInfo lastUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo();
            if (lastUpdateInfo == null) {
                return;
            }
            if (lastUpdateInfo.getLastUpdateTime().after(TicketListView.this.lastUpdateTime)) {
                TicketListView.this.btnRefresh.setBlinking(true);
            }
        }
    }
}

