/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TicketViewerTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color SAVED_ITEM_COLOR = Color.decode("#FFFACD");
    private boolean inTicketScreen = false;
    private MultiLineTableCellRenderer multiLineTableCellRenderer;

    public TicketViewerTableCellRenderer() {
        this(15, 2);
    }

    public TicketViewerTableCellRenderer(int verticalGap, int horizontalGap) {
        this.multiLineTableCellRenderer = new MultiLineTableCellRenderer(verticalGap, horizontalGap);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = null;
        TicketViewerTableModel model = (TicketViewerTableModel)table.getModel();
        Object object = model.get(row);
        if (column == 0) {
            rendererComponent = this.multiLineTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        } else {
            rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            this.setHorizontalAlignment(4);
        }
        if (!this.inTicketScreen || isSelected) {
            return rendererComponent;
        }
        rendererComponent.setBackground(table.getBackground());
        if (object instanceof ITicketItem) {
            ITicketItem iTicketItem = (ITicketItem)object;
            if (iTicketItem instanceof TicketItem && ((TicketItem)iTicketItem).getKitchenStatusValue() == KitchenStatus.BUMP) {
                rendererComponent.setBackground(Color.GREEN);
            } else if (iTicketItem.isPrintedToKitchen().booleanValue()) {
                rendererComponent.setBackground(Color.YELLOW);
            } else if (iTicketItem.isSaved()) {
                rendererComponent.setBackground(SAVED_ITEM_COLOR);
            }
        }
        return rendererComponent;
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        String text = value.toString();
        if (value instanceof Double || value instanceof Float) {
            text = NumberUtil.formatNumberAcceptNegative(((Number)value).doubleValue());
        }
        this.setText(text);
    }

    public boolean isInTicketScreen() {
        return this.inTicketScreen;
    }

    public void setInTicketScreen(boolean inTicketScreen) {
        this.inTicketScreen = inTicketScreen;
    }
}

