/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardEditPinNumberView
extends POSDialog {
    private FixedLengthTextField txtCardNumber;
    private FixedLengthTextField txtOldPinNumber;
    private FixedLengthTextField txtNewPinNumber;
    private FixedLengthTextField txtConfirmPinNumber;
    private GiftCard giftCard;
    private GiftCardProcessor giftCardProcessor;

    public GiftCardEditPinNumberView(GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.init();
    }

    public GiftCardEditPinNumberView(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Pin Card Update");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("GiftCardEditPinNumberView.3"));
        this.txtCardNumber = new FixedLengthTextField(20);
        this.txtOldPinNumber = new FixedLengthTextField(20);
        this.txtOldPinNumber.setLength(8);
        this.txtNewPinNumber = new FixedLengthTextField(20);
        this.txtNewPinNumber.setLength(8);
        this.txtConfirmPinNumber = new FixedLengthTextField(20);
        this.txtConfirmPinNumber.setLength(8);
        centerPanel.add((Component)lblNumberOfCard, "cell 0 0, alignx right");
        centerPanel.add((Component)this.txtCardNumber, "cell 1 0");
        centerPanel.add((Component)new JLabel(Messages.getString("GiftCardEditPinNumberView.6")), "cell 0 1, alignx right");
        centerPanel.add((Component)this.txtOldPinNumber, "cell 1 1");
        centerPanel.add((Component)new JLabel(Messages.getString("GiftCardEditPinNumberView.9")), "cell 0 2, alignx right");
        centerPanel.add((Component)this.txtNewPinNumber, "cell 1 2");
        centerPanel.add((Component)new JLabel(Messages.getString("GiftCardEditPinNumberView.12")), "cell 0 3, alignx right");
        centerPanel.add((Component)this.txtConfirmPinNumber, "cell 1 3");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("GiftCardEditPinNumberView.18"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardEditPinNumberView.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardEditPinNumberView.20"))));
        this.add((Component)buttonPanel, "South");
    }

    public void doGenerate() {
        if (this.save()) {
            this.giftCardProcessor.changePinNumber(this.giftCard);
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardEditPinNumberView.21"));
            this.dispose();
        }
    }

    private boolean save() {
        String cardNo = this.txtCardNumber.getText();
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.22"));
            return false;
        }
        String oldPinNumber = this.txtOldPinNumber.getText();
        if (StringUtils.isEmpty((String)oldPinNumber)) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.23"));
            return false;
        }
        if (!oldPinNumber.equals(this.giftCard.getPinNumber())) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.24"));
            return false;
        }
        String newPinNumber = this.txtNewPinNumber.getText();
        if (StringUtils.isEmpty((String)newPinNumber)) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.25"));
            return false;
        }
        String repeatPinNumber = this.txtConfirmPinNumber.getText();
        if (StringUtils.isEmpty((String)repeatPinNumber)) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.26"));
            return false;
        }
        if (!newPinNumber.equals(repeatPinNumber)) {
            MessageDialog.showError(Messages.getString("GiftCardEditPinNumberView.27"));
            return false;
        }
        this.giftCard.setPinNumber(repeatPinNumber);
        return true;
    }
}

