/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.GiftCardExplorer;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardGeneratorView;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class GiftCardImportCheckingDialog
extends POSDialog {
    private BeanTableModel<GiftCard> tableModel;
    private JXTable table;
    private File file;
    private List<GiftCard> giftCards;
    private TitlePanel titlePanel;

    public GiftCardImportCheckingDialog(File file) {
        this.file = file;
        this.init();
        this.initData();
    }

    private void initData() {
        try {
            List<GiftCard> giftCards = this.importData(this.file.toURI().toURL());
            if (giftCards == null) {
                return;
            }
            this.tableModel.setRows(giftCards);
            this.updateTitle(giftCards.size());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Error in importing file!");
            PosLog.error(GiftCardImportCheckingDialog.class, e.getMessage(), e);
        }
    }

    private void updateTitle(int length) {
        this.titlePanel.setTitle("Imported " + length + " gift cards, please review and then click save to make it permanent.");
    }

    private void init() {
        this.setTitle(AppProperties.getAppName());
        this.titlePanel = new TitlePanel();
        this.tableModel = new BeanTableModel(GiftCard.class);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.46"), "pinNumber", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.48"), "batchNo", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.50"), "balance", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.52"), "issueDate", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.54"), "activationDate", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.56"), "deActivationDate", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.58"), "expiryDate", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.60"), "active", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.62"), "disable", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.64"), "duration", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.66"), "durationType", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.68"), "point", BeanTableModel.EditMode.EDITABLE);
        this.table = new JXTable(this.tableModel){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                GiftCardImportCheckingDialog.this.table.editCellAt(row, column);
                DefaultCellEditor editor = (DefaultCellEditor)GiftCardImportCheckingDialog.this.table.getCellEditor(row, column);
                if (editor.getComponent() instanceof JTextField) {
                    JTextField textField = (JTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                }
            }
        };
        this.table.getColumnModel().getColumn(5).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(6).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(7).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(8).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        JComboBox<String> cbDuration = new JComboBox<String>();
        cbDuration.addItem("DAY");
        cbDuration.addItem("MONTH");
        cbDuration.addItem("YEAR");
        this.table.getColumnModel().getColumn(12).setCellEditor(new JComboBoxEditor(cbDuration));
        this.table.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.resizeColumnWidth((JTable)this.table);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.titlePanel, "North");
        this.add((Component)new PosScrollPane((Component)this.table), "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnSetBatchNumber = new PosButton("SET BATCH NO");
        buttonPanel.add((Component)btnSetBatchNumber, "grow");
        btnSetBatchNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    String batchNumber = JOptionPane.showInputDialog(GiftCardImportCheckingDialog.this, (Object)"Enter batch number:");
                    if (StringUtils.isEmpty((String)batchNumber)) {
                        return;
                    }
                    int option = JOptionPane.showConfirmDialog(GiftCardImportCheckingDialog.this, "This will set batch no. to all imported gift cards. Proceed?");
                    if (option != 0) {
                        return;
                    }
                    ArrayList rows = new ArrayList(GiftCardImportCheckingDialog.this.tableModel.getRows());
                    for (GiftCard giftCard : rows) {
                        giftCard.setBatchNo(batchNumber);
                    }
                    GiftCardImportCheckingDialog.this.tableModel.fireTableRowsUpdated(0, GiftCardImportCheckingDialog.this.table.getRowCount() - 1);
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        });
        PosButton btnSave = new PosButton("SAVE");
        buttonPanel.add((Component)btnSave, "grow");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardImportCheckingDialog.this.giftCards = new ArrayList();
                GiftCardImportCheckingDialog.this.giftCards.addAll(GiftCardImportCheckingDialog.this.tableModel.getRows());
                GiftCardImportCheckingDialog.this.setCanceled(false);
                GiftCardImportCheckingDialog.this.dispose();
            }
        });
        PosButton btnDelete = new PosButton("DELETE");
        buttonPanel.add((Component)btnDelete, "grow");
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardImportCheckingDialog.this.doDeleteItem();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("UserListDialog.5"))));
        this.add((Component)buttonPanel, "South");
    }

    private void doDeleteItem() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to delete selected item?", "Delete item?");
        if (option != 0) {
            return;
        }
        this.tableModel.removeRow(index);
        this.updateTitle(this.tableModel.getRows().size());
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(80);
        columnWidth.add(180);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(85);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(70);
        columnWidth.add(50);
        return columnWidth;
    }

    private List<GiftCard> importData(URL url) {
        return this.doImportCSVFile(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GiftCard> doImportCSVFile(URL url) {
        InputStream in = null;
        try {
            in = url.openStream();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            ArrayList<GiftCard> giftCards = new ArrayList<GiftCard>();
            CSVParser records = CSVFormat.EXCEL.withHeader(new String[0]).parse((Reader)streamReader);
            String batchNumber = GiftCardGeneratorView.generateBatchNumber();
            for (CSVRecord record : records) {
                String cardNumber = this.getStringValue("Card Number", record);
                String ownerName = this.getStringValue("Owner Name", record);
                Date issueDate = this.getDateValue("Issue Date", record);
                Date expirationDate = this.getDateValue("Expiration Date", record);
                Date activationDate = this.getDateValue("Activation Date", record);
                Date deActivationDate = this.getDateValue("Deactivation Date", record);
                Double balance = this.getDoubleValue("Balance", record);
                Boolean isActive = this.getBooleanValue("Active", record);
                Boolean isDisable = this.getBooleanValue("Disable", record);
                String durationType = this.getStringValue("Duration Type", record);
                Integer duration = this.getIntegerValue("Duration", record);
                String pinNumber = this.getStringValue("Pin Number", record);
                Integer point = this.getIntegerValue("Point", record);
                String email = this.getStringValue("Email", record);
                String type = this.getStringValue("Type", record);
                GiftCard giftCard = new GiftCard();
                giftCard.setCardNumber(cardNumber.replace("\"", ""));
                giftCard.setOwnerName(ownerName);
                giftCard.setIssueDate(issueDate);
                giftCard.setExpiryDate(expirationDate);
                giftCard.setActivationDate(activationDate);
                giftCard.setDeActivationDate(deActivationDate);
                giftCard.setBalance(balance);
                giftCard.setActive(isActive);
                giftCard.setDisable(isDisable);
                giftCard.setDurationType(durationType);
                giftCard.setDuration(duration);
                giftCard.setPinNumber(pinNumber);
                giftCard.setPoint(point);
                giftCard.setBatchNo(batchNumber);
                giftCard.setEmail(email);
                giftCard.setType(type);
                giftCards.add(giftCard);
            }
            ArrayList<GiftCard> arrayList = giftCards;
            return arrayList;
        }
        catch (Exception e) {
            PosLog.error(GiftCardExplorer.class, "Error: " + e);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }

    private Date getDateValue(String value, CSVRecord record) {
        try {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            String txtValue = record.get(value);
            if (StringUtils.isNotEmpty((String)txtValue)) {
                return DateUtil.parseByFullDate(txtValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getStringValue(String value, CSVRecord record) {
        try {
            String txtValue = record.get(value);
            if (StringUtils.isNotEmpty((String)txtValue)) {
                return txtValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Double getDoubleValue(String value, CSVRecord record) {
        try {
            String txtValue = record.get(value);
            if (StringUtils.isNotEmpty((String)txtValue)) {
                return Double.parseDouble(txtValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Integer getIntegerValue(String value, CSVRecord record) {
        try {
            String txtValue = record.get(value);
            if (StringUtils.isNotEmpty((String)txtValue)) {
                return Integer.parseInt(txtValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Boolean getBooleanValue(String value, CSVRecord record) {
        try {
            String txtValue = record.get(value);
            if (StringUtils.isNotEmpty((String)txtValue)) {
                return Boolean.parseBoolean(txtValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<GiftCard> getGiftCards() {
        return this.giftCards;
    }

    public void setGiftCards(List<GiftCard> giftCards) {
        this.giftCards = giftCards;
    }

    class JComboBoxEditor
    extends DefaultCellEditor {
        JComboBox combobox;

        public JComboBoxEditor(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.tableModel.getRow(row);
            this.combobox = (JComboBox)this.getComponent();
            if (column == 12 && giftCard.getDurationType() != null) {
                this.combobox.setSelectedItem(giftCard.getDurationType());
            }
            return this.combobox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.combobox.getSelectedItem();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class JDateChooserEditor
    extends DefaultCellEditor {
        DateTimePicker datePicker;

        public JDateChooserEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.datePicker = new DateTimePicker();
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.tableModel.getRow(row);
            if (column == 5) {
                this.datePicker.setDate(giftCard.getIssueDate());
            } else if (column == 6) {
                this.datePicker.setDate(giftCard.getActivationDate());
            } else if (column == 7) {
                this.datePicker.setDate(giftCard.getDeActivationDate());
            } else if (column == 8) {
                this.datePicker.setDate(giftCard.getExpiryDate());
            }
            return this.datePicker;
        }

        @Override
        public Object getCellEditorValue() {
            return this.datePicker.getDate();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}

