/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class OrderInfoDialog
extends POSDialog {
    private OrderInfoView view;
    private boolean reorder = false;
    private PosButton btnReOrder;
    private PosButton btnTransferUser;
    private PosButton btnPrint;
    private PosButton btnPrintDriverCopy;
    private PosButton btnEmail;
    private JPanel buttonPanel;

    public OrderInfoDialog(OrderInfoView view) {
        this.view = view;
        this.setTitle(Messages.getString("OrderInfoDialog.0"));
        this.createUI();
    }

    public void createUI() {
        this.add(this.view);
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.btnReOrder = new PosButton(Messages.getString("OrderInfoDialog.5"));
        this.btnReOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketReorderAction reorderAction = new TicketReorderAction(OrderInfoDialog.this.view.getTickets().get(0), UserPermission.CREATE_TICKET);
                reorderAction.execute();
                if (!reorderAction.isReorder()) {
                    return;
                }
                OrderInfoDialog.this.reorder = true;
                OrderInfoDialog.this.setCanceled(false);
                OrderInfoDialog.this.dispose();
            }
        });
        this.btnEmail = new PosButton("EMAIL");
        this.btnEmail.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return OrderInfoDialog.this.view.getTickets().get(0);
            }
        });
        this.buttonPanel.add(this.btnEmail);
        this.buttonPanel.add(this.btnReOrder);
        this.btnTransferUser = new PosButton();
        this.btnTransferUser.setText(Messages.getString("OrderInfoDialog.3"));
        this.btnTransferUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TicketTransferAction transferAction = new TicketTransferAction(OrderInfoDialog.this.view.getTickets().get(0), Application.getCurrentUser());
                    transferAction.execute();
                    if (!transferAction.isTransfered()) {
                        return;
                    }
                    OrderInfoDialog.this.view.getReportPanel().removeAll();
                    OrderInfoDialog.this.view.createReport();
                    OrderInfoDialog.this.view.revalidate();
                    OrderInfoDialog.this.view.repaint();
                    OrderInfoDialog.this.setCanceled(false);
                    OrderInfoDialog.this.dispose();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(Messages.getString("UserTransferDialog.4"));
                    PosLog.error(this.getClass(), e1);
                }
            }
        });
        this.buttonPanel.add(this.btnTransferUser);
        this.btnPrint = new PosButton();
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderInfoDialog.this.doPrint();
            }
        });
        this.btnPrint.setText(Messages.getString("OrderInfoDialog.1"));
        this.buttonPanel.add(this.btnPrint);
        this.btnPrintDriverCopy = new PosButton();
        this.btnPrintDriverCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderInfoDialog.this.doPrintDriverCopy();
            }
        });
        this.btnPrintDriverCopy.setText("Print (Driver Copy)");
        this.btnPrintDriverCopy.setVisible(false);
        this.buttonPanel.add(this.btnPrintDriverCopy);
        PosButton btnClose = new PosButton();
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderInfoDialog.this.dispose();
            }
        });
        btnClose.setText(Messages.getString("OrderInfoDialog.2"));
        this.buttonPanel.add(btnClose);
    }

    private void doPrintDriverCopy() {
        try {
            this.view.printCopy("Driver Copy");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    public void updateView() {
        this.btnTransferUser.setVisible(false);
        this.btnReOrder.setVisible(false);
        this.btnPrintDriverCopy.setVisible(true);
        this.btnPrint.setText("Print (Customer Copy)");
    }

    protected void doPrint() {
        try {
            this.view.printCopy("Customer Copy");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    public void setReorder(boolean reorder) {
        this.reorder = reorder;
    }

    public boolean isReorder() {
        return this.reorder;
    }

    public void showOnlyPrintButton() {
        this.btnTransferUser.setVisible(false);
        this.btnReOrder.setVisible(false);
        this.btnPrintDriverCopy.setVisible(false);
    }

    public OrderInfoView getOrderInfoView() {
        return this.view;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }
}

