/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.model.OrderType;
import com.floreantpos.ui.tableselection.DefaultTableSelectionView;
import com.floreantpos.ui.tableselection.TableSelector;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;

public class TableMapView
extends ViewPanel {
    public static final String VIEW_NAME = "TABLE_MAP";
    private TableSelector tableSelector = null;
    private static TableMapView instance;

    private TableMapView() {
        this.initComponents();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        FloorLayoutPlugin floorLayoutPlugin = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
        this.tableSelector = floorLayoutPlugin == null ? DefaultTableSelectionView.getInstance() : floorLayoutPlugin.createTableSelector();
        this.tableSelector.setCreateNewTicket(true);
        this.tableSelector.updateView(false);
        this.add((Component)this.tableSelector, "Center");
    }

    @Override
    public DataChangeListener getDataChangeListener() {
        return (DataChangeListener)((Object)this.tableSelector);
    }

    public void updateView() {
        this.tableSelector.rendererTables();
    }

    private static TableMapView getInstance() {
        if (instance == null) {
            instance = new TableMapView();
        }
        return instance;
    }

    public static TableMapView getInstance(OrderType orderType) {
        TableMapView instance2 = TableMapView.getInstance();
        instance2.tableSelector.setOrderType(orderType);
        return instance2;
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }
}

