/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketInfoButton
extends JPanel {
    private Ticket ticket;
    private boolean selected;
    private JLabel lblPaidStatus;
    private JLabel lblTitle;
    private JLabel lblInfo;
    private JLabel lblTotalAmount;
    private boolean isAllowCustomerSelection;

    public TicketInfoButton(Ticket ticket) {
        this.ticket = ticket;
        this.setLayout((LayoutManager)new MigLayout("hidemode 3, inset 0,fill"));
        this.lblTitle = new JLabel();
        this.lblTitle.setBackground(new Color(66, 155, 207));
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1, PosUIManager.getSize(18)));
        this.lblTitle.setOpaque(true);
        this.add((Component)this.lblTitle, "grow,wrap");
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lblInfo = new JLabel();
        this.lblInfo.setHorizontalAlignment(0);
        this.lblInfo.setFont(this.lblTitle.getFont().deriveFont(1, PosUIManager.getSize(12)));
        this.lblInfo.setBackground(Color.white);
        this.lblInfo.setOpaque(true);
        this.add((Component)this.lblInfo, "grow,wrap");
        this.lblTotalAmount = new JLabel();
        this.lblTotalAmount.setHorizontalAlignment(0);
        this.lblTotalAmount.setFont(this.lblTitle.getFont().deriveFont(1, PosUIManager.getSize(14)));
        this.lblTotalAmount.setBackground(Color.white);
        this.lblTotalAmount.setOpaque(true);
        this.add((Component)this.lblTotalAmount, "grow,wrap");
        this.lblPaidStatus = new JLabel();
        this.lblPaidStatus.setHorizontalAlignment(0);
        this.lblPaidStatus.setBackground(Color.white);
        this.lblPaidStatus.setForeground(Color.red);
        this.lblPaidStatus.setFont(this.lblTitle.getFont().deriveFont(1, PosUIManager.getSize(12)));
        this.lblPaidStatus.setOpaque(true);
        this.add((Component)this.lblPaidStatus, "grow,wrap");
        this.updateView();
    }

    public void updateView() {
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        String title = "";
        Terminal terminal = Application.getInstance().getTerminal();
        if (this.ticket == null) {
            title = "[New Ticket]";
            this.lblPaidStatus.setText(String.valueOf(title));
            this.lblTotalAmount.setVisible(false);
        } else {
            Integer tokenNo = this.ticket.getTokenNo();
            String memberInfo = this.ticket.getCustomer() == null ? "" : this.ticket.getCustomer().getName();
            String server = this.ticket.getOwner().getFullName();
            title = tokenNo > 0 ? "Token# " + tokenNo : "[New Ticket]";
            String tableText = terminal.isShowTableNumber() ? this.ticket.getTableNumbersDisplay() : this.ticket.getTableNames();
            String info = "<html><center>";
            if (StringUtils.isNotEmpty((String)tableText)) {
                info = info + "Table# " + tableText;
            }
            if (StringUtils.isNotEmpty((String)memberInfo)) {
                info = info + "<br/>Member: " + memberInfo;
            }
            info = info + "<br/>Server: " + server + "</center></html>";
            this.lblTitle.setText("<html><center>" + String.valueOf(title) + "</center></html>");
            this.lblInfo.setText(info);
            this.lblTotalAmount.setText(this.createSummaryText(currencySymbol));
        }
    }

    private String createSummaryText(String currencySymbol) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><center>");
        stringBuilder.append("Total: " + currencySymbol + NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
        stringBuilder.append("<br/>");
        stringBuilder.append("&nbsp; Due: " + currencySymbol + NumberUtil.formatNumber(this.ticket.getDueAmount()));
        if (this.ticket.isPaid().booleanValue()) {
            stringBuilder.append("<br/>PAID");
        }
        stringBuilder.append("</center></html>");
        return stringBuilder.toString();
    }

    public boolean isAllowCustomerSelection() {
        return this.isAllowCustomerSelection;
    }

    public void setAllowCustomerSelection(boolean isAllowCustomerSelection) {
        this.isAllowCustomerSelection = isAllowCustomerSelection;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 3));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Ticket getTicket() {
        return this.ticket;
    }
}

