/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.ui.views.voidticket.VoidInfoInputDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;

public class OrderController
implements OrderListener,
CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    List<TicketEditListener> ticketEditListenerList;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
        orderView.getTicketView().addOrderListener(this);
        this.ticketEditListenerList = new ArrayList<TicketEditListener>();
    }

    @Override
    public void categorySelected(MenuCategory foodCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(foodCategory);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void groupSelected(MenuGroup foodGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(foodGroup);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemSelected(MenuItem menuItem) {
        Session session = null;
        try {
            POSDialog dialog;
            session = MenuItemDAO.getInstance().createNewSession();
            if (menuItem.getId() != null) {
                menuItem = (MenuItem)session.get(MenuItem.class, (Serializable)((Object)menuItem.getId()));
            }
            if (!this.hasAvailableStock(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                MenuItem parentMenuItem = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem(parentMenuItem);
            }
            if (menuItem.isHasVariant().booleanValue() && menuItem.getVariants() != null && menuItem.getVariants().size() > 0) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            TicketView ticketView = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double itemQuantity = 1.0;
            if (menuItem.isFractionalUnit().booleanValue()) {
                itemQuantity = TerminalConfig.getScaleActivationValue().equals("cas10") ? AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0) : NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.2"), 1.0);
                if (itemQuantity <= -1.0) {
                    return;
                }
                if (itemQuantity == 0.0) {
                    POSMessageDialog.showError(Messages.getString("OrderController.3"));
                    return;
                }
            }
            double itemPrice = 0.0;
            if (menuItem.isEditablePrice().booleanValue()) {
                itemPrice = NumberSelectionDialog2.takeDoubleInput("Please enter price", menuItem.getPrice());
                if (itemPrice <= -1.0) {
                    return;
                }
                menuItem.setPrice(itemPrice);
            }
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, itemQuantity);
            if (this.orderView.isReturnMode()) {
                VoidInfoInputDialog dialog2 = new VoidInfoInputDialog(ticketItem);
                dialog2.setSize(PosUIManager.getSize(400, 600));
                dialog2.open();
                if (dialog2.isCanceled()) {
                    return;
                }
                ticketItem.markVoided(dialog2.getVoidReason(), dialog2.isItemWasted(), dialog2.getVoidQuantity());
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue() && !this.addComboItemsToTicketItem(menuItem, ticketItem)) {
                return;
            }
            ticketItem.setTicket(ticket);
            Object selectedSeat = this.orderView.getSelectedSeatNumber();
            if (selectedSeat instanceof Integer) {
                ticketItem.setSeatNumber((Integer)selectedSeat);
            } else if (selectedSeat instanceof TicketItemSeat) {
                TicketItemSeat seat = (TicketItemSeat)selectedSeat;
                ticketItem.setSeat(seat);
                ticketItem.setSeatNumber(seat.getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                dialog = new PizzaModifierSelectionDialog(ticket, ticketItem, menuItem, false);
                dialog.setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    dialog.openUndecoratedFullScreen();
                } else {
                    dialog.openFullScreen();
                }
                if (dialog.isCanceled()) {
                    return;
                }
                this.fireTicketItemUpdated(ticket, ticketItem);
            } else if (menuItem.hasMandatoryModifiers()) {
                dialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem, menuItem));
                dialog.open();
                if (!dialog.isCanceled()) {
                    ticketView.addTicketItem(ticketItem);
                    this.fireTicketItemUpdated(ticket, ticketItem);
                }
            } else {
                ticketView.addTicketItem(ticketItem);
                this.fireTicketItemUpdated(ticket, ticketItem);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        finally {
            MenuItemDAO.getInstance().closeSession(session);
        }
    }

    private boolean hasAvailableStock(MenuItem menuItem, double selectedQty) {
        List<TicketItem> ticketItems;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double qty = 0.0;
        if (ticket != null && (ticketItems = ticket.getTicketItems()) != null) {
            for (TicketItem item : ticketItems) {
                if (!item.getMenuItemId().equals(menuItem.getId())) continue;
                qty += item.getQuantity() - item.getInventoryAdjustQty();
            }
        }
        qty += selectedQty;
        return !(menuItem.getAvailableUnit() < qty) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Item is not in stock, what do you want?", "Confirm", "ADD ANYWAY", "CLOSE") == 0;
    }

    public void doEditTicketItemQuantity(Object selectedObject) {
        TicketItem ticketItem = (TicketItem)selectedObject;
        double quantity = 0.0;
        quantity = ticketItem.isFractionalUnit() != false ? NumberSelectionDialog2.takeDoubleInput("Enter quantity", Math.abs(ticketItem.getQuantity())) : (double)NumberSelectionDialog2.takeIntInput("Enter quantity", Math.abs(ticketItem.getQuantity()));
        if (quantity < 1.0) {
            return;
        }
        MenuItem menuItem = ticketItem.getMenuItem();
        if (quantity > ticketItem.getQuantity() && !this.hasAvailableStock(menuItem, quantity - ticketItem.getQuantity())) {
            return;
        }
        if (this.orderView.isReturnMode()) {
            ticketItem.markVoided("Return", false, ticketItem.getQuantity());
        } else {
            if (menuItem != null && menuItem.isComboItem().booleanValue()) {
                this.updateComboTicketItemQuantity(ticketItem, quantity);
            }
            ticketItem.setQuantity(quantity);
        }
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double quantity) {
        List<TicketItem> comboticketItems = ticketItem.getComboItems();
        double ticketItemQuantity = ticketItem.getQuantity();
        double adjustQuantity = quantity - ticketItemQuantity;
        if (comboticketItems != null) {
            for (TicketItem comboTicketItem : comboticketItems) {
                comboTicketItem.setQuantity(comboTicketItem.getQuantity() + adjustQuantity * comboTicketItem.getQuantity() / ticketItemQuantity);
            }
        }
    }

    private boolean addComboItemsToTicketItem(MenuItem menuItem, TicketItem ticketItemObj) {
        ComboTicketItem ticketItem = (ComboTicketItem)ticketItemObj;
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            Ticket currentTicket = this.orderView.getCurrentTicket();
            for (ComboItem item : menuItem.getComboItems()) {
                POSDialog dialog;
                if (item.getQuantity() == 0.0) continue;
                MenuItem comboMenuItem = item.getMenuItem();
                TicketItem comboTicketItem = comboMenuItem.convertToTicketItem(currentTicket, item.getQuantity());
                comboTicketItem.setMenuItem(comboMenuItem);
                if (comboMenuItem.hasMandatoryModifiers()) {
                    dialog = new ModifierSelectionDialog(new ModifierSelectionModel(currentTicket, comboTicketItem, comboMenuItem));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    dialog = new PizzaModifierSelectionDialog(currentTicket, comboTicketItem, comboMenuItem, false);
                    dialog.openFullScreen();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                }
                comboTicketItem.setMenuItemId(comboMenuItem.getId());
                comboTicketItem.setName(comboMenuItem.getName());
                comboTicketItem.setQuantity(item.getQuantity());
                comboTicketItem.setParentTicketItem(ticketItem);
                comboTicketItem.setTicket(null);
                comboTicketItem.setGroupId(null);
                ticketItem.addTocomboItems(comboTicketItem);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog dialog = new ComboTicketItemSelectionDialog(menuItem, ticketItem);
            dialog.setTitle("SELECT COMBO ITEMS");
            dialog.setSize(PosUIManager.getSize(1024, 700));
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
        }
        return true;
    }

    public void itemSelectionFinished(MenuGroup parent) {
        GroupView groupView;
        MenuCategory menuCategory = parent.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    @Override
    public void payOrderSelected(Ticket ticket) {
        try {
            if (!new SettleTicketAction(ticket).performSettle()) {
                return;
            }
            RootView.getInstance().showDefaultView();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static void openModifierDialog(ITicketItem ticketItemObject) {
        try {
            POSDialog dialog;
            List<TicketItemModifier> ticketItemModifiers;
            TicketItemModifier ticketItemModifier;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (ticketItemObject instanceof TicketItem) {
                ticketItem = (TicketItem)ticketItemObject;
            } else if (ticketItemObject instanceof TicketItemModifier && (ticketItem = (ticketItemModifier = (TicketItemModifier)ticketItemObject).getTicketItem()) == null) {
                ticketItem = ticketItemModifier.getTicketItem();
            }
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if ((ticketItemModifiers = ticketItem.getTicketItemModifiers()) == null) {
                ticketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            TicketItem cloneTicketItem = ticketItem.clone();
            boolean pizzaType = ticketItem.isPizzaType();
            if (pizzaType) {
                dialog = new PizzaModifierSelectionDialog(ticket, cloneTicketItem, menuItem, true);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                TicketItemModifier sizeModifier = cloneTicketItem.getSizeModifier();
                sizeModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(sizeModifier);
                ticketItem.setQuantity(cloneTicketItem.getQuantity());
                ticketItem.setUnitPrice(cloneTicketItem.getUnitPrice());
            } else {
                dialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, cloneTicketItem, menuItem));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
            List<TicketItemModifier> addedTicketItemModifiers = cloneTicketItem.getTicketItemModifiers();
            if (addedTicketItemModifiers == null) {
                addedTicketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            ticketItemModifiers.clear();
            for (TicketItemModifier ticketItemModifier2 : addedTicketItemModifiers) {
                ticketItemModifier2.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier2);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
        boolean newTicket = ticket.getId() == null;
        ActionHistoryDAO actionHistoryDAO = ActionHistoryDAO.getInstance();
        User user = Application.getCurrentUser();
        if (newTicket) {
            actionHistoryDAO.saveHistory(user, ActionHistory.NEW_CHECK, POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId());
        } else {
            actionHistoryDAO.saveHistory(user, ActionHistory.EDIT_CHECK, POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId());
        }
    }

    public static synchronized void closeOrder(Ticket ticket) {
        if (ticket.getOrderType().isCloseOnPaid().booleanValue() || ticket.isPaid().booleanValue()) {
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
        }
        TicketDAO ticketDAO = new TicketDAO();
        ticketDAO.saveOrUpdate(ticket);
        User driver = ticket.getAssignedDriver();
        if (driver != null) {
            driver.setAvailableForDelivery(true);
            UserDAO.getInstance().saveOrUpdate(driver);
        }
    }

    public void addTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.add(l);
    }

    public void removeTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.remove(l);
    }

    private void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireTicketEditingStart(Ticket ticket) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.ticketEditingStart(ticket);
        }
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.ticketEditingFinish(ticket);
        }
    }
}

